/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.remote;

import com.ge.med.idc.IterativeRenderer;
import com.ge.med.idc.MultipassAlgorithm;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.jnu.JnMatrix4d;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.ParallelTaskManager;
import com.ge.med.terra.jami.capable.VrCapable;
import com.ge.med.terra.jami.j3d.J3DRenderEngine;
import com.ge.med.terra.jami.j3d.T3DBaseRenderEngine;
import com.ge.med.terra.jami.j3d.remote.Rm3DClientServerIF;
import com.ge.med.terra.jami.j3d.remote.RmVolumeModel;
import com.ge.med.terra.jami.j3d.vr.RayTracer;
import com.ge.med.terra.jami.j3d.vr.VrColorLut;
import com.ge.med.terra.jami.j3d.vr.VrPreset;
import com.ge.med.terra.jami.remote.RmCommand;
import com.ge.med.terra.jami.remote.RmPixelBuffer;
import com.ge.med.terra.jami.remote.RmRenderConnection;
import com.ge.med.terra.jami.remote.RmRenderSession;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class RmClient3DEngine
extends T3DBaseRenderEngine
implements Rm3DClientServerIF,
IterativeRenderer,
VrCapable {
    private RmRenderConnection connection = null;
    private ClientMultiPassAlgorithm client_mp = new ClientMultiPassAlgorithm(this);
    private ParallelTaskManager tp = null;
    private RayTracer rt = null;
    private VrPreset preset = new VrPreset();
    private boolean segmentationVisible = false;
    private int[] seg_cmap = null;

    public RmClient3DEngine(RmRenderSession serverSession, String remoteRenderEngineClass) {
        this(serverSession, remoteRenderEngineClass, new ParallelTaskManager());
    }

    public RmClient3DEngine(RmRenderSession serverSession, String remoteRenderEngineClass, ParallelTaskManager ptm) {
        String rengineClass = remoteRenderEngineClass != null ? remoteRenderEngineClass : J3DRenderEngine.class.getCanonicalName();
        super.setRenderStyle("REFORMAT");
        this.connection = serverSession.createConnection("3D", new String[]{rengineClass});
        if (this.connection == null) {
            throw new RuntimeException("Invalid render-engine class, no connection can be created: " + rengineClass);
        }
        this.tp = ptm;
        Class[] mpalg = (Class[])this.connection.execute(new RmCommand(24, null, true));
        this.client_mp.setFillAlgorithmTable(mpalg);
    }

    protected final ParallelTaskManager getParallelTaskManager() {
        return this.tp;
    }

    @Override
    public MultipassAlgorithm getMultipassAlgorithm(int renderOutputLayer) {
        return this.client_mp;
    }

    @Override
    public MultipassAlgorithm[] getSupportedMultipassAlgorithms() {
        return new MultipassAlgorithm[]{this.client_mp};
    }

    @Override
    public void setVolume(XjVolumeInfo volume, int vol_idx) {
        RmVolumeModel vol_model = this.loadRemoteVolume(volume);
        this.setVolumeModel(vol_model, vol_idx);
        if (vol_model != null) {
            // empty if block
        }
    }

    private RmVolumeModel loadRemoteVolume(XjVolumeInfo rmvolume) {
        Integer vmId = (Integer)this.connection.execute(new RmCommand(0, new Object[]{rmvolume}, true));
        return new RmVolumeModel(rmvolume, vmId);
    }

    @Override
    public void setVolumeModel(XjVolumeModel volumeModel, int vol_idx) {
        super.setVolumeModel(volumeModel, vol_idx);
        RmVolumeModel rvm = (RmVolumeModel)volumeModel;
        int volModelId = rvm != null ? rvm.getVolModelId() : -1;
        this.connection.execute(new RmCommand(1, new Object[]{new Integer(vol_idx), new Integer(volModelId)}, true));
    }

    @Override
    protected void newVolumeModel(int vol_idx) {
        super.newVolumeModel(vol_idx);
    }

    @Override
    public void setRenderStyle(String style) {
        this.connection.execute(new RmCommand(2, new Object[]{style}, true));
        super.setRenderStyle(style);
    }

    @Override
    public void setBackground(int rgbbackground, int lumbackground) {
        super.setBackground(rgbbackground, lumbackground);
        this.connection.execute(new RmCommand(3, new Object[]{new Integer(rgbbackground), new Integer(lumbackground)}, true));
    }

    @Override
    public void render(int renderOutputLayer) {
        RmPixelBuffer pixels = this.connection.render(renderOutputLayer, 0, (byte)56);
    }

    @Override
    public void setOutput(int[] rgbBuff, short[] luminanceBuff, int width, int height) {
        super.setOutput(rgbBuff, luminanceBuff, width, height);
        this.connection.execute(new RmCommand(8, new Object[]{new Integer(width), new Integer(height)}, true));
    }

    @Override
    public void clearBuffers() {
        super.clearBuffers();
        this.connection.execute(new RmCommand(9, null, true));
    }

    @Override
    public void clearPixels(int x0, int y0, int width, int height, int stepx, int stepy) {
        super.clearPixels(x0, y0, width, height, stepx, stepy);
        this.connection.execute(new RmCommand(10, new Object[]{new Integer(x0), new Integer(y0), new Integer(width), new Integer(height), new Integer(stepx), new Integer(stepy)}, true));
    }

    @Override
    public String getModality(int vol_idx) {
        XjVolumeModel vol_model = this.getVolumeModel(vol_idx);
        return "" + vol_model.getVolume().getValue(8, 96);
    }

    @Override
    public String[] getSupportedRenderStyles() {
        String[] rstyles = (String[])this.connection.execute(new RmCommand(11, null, true));
        return rstyles;
    }

    @Override
    public void setProperty(String propName, Object value) {
        super.setProperty(propName, value);
        this.connection.execute(new RmCommand(12, new Object[]{propName, value}, true));
        this.notifyChange();
    }

    @Override
    protected boolean calculateVoxelRASTransform(XjVolumeModel vm, CTransform vox2ras, CTransform ras2vox) {
        if (vm != null) {
            RmVolumeModel rvm = (RmVolumeModel)vm;
            JnMatrix4d v2r = rvm.getVoxel2RASTransform();
            JnMatrix4d r2v = rvm.getRAS2VoxelTransform();
            vox2ras.set(v2r.m00, v2r.m01, v2r.m02, v2r.m03, v2r.m10, v2r.m11, v2r.m12, v2r.m13, v2r.m20, v2r.m21, v2r.m22, v2r.m23, v2r.m30, v2r.m31, v2r.m32, v2r.m33);
            ras2vox.set(r2v.m00, r2v.m01, r2v.m02, r2v.m03, r2v.m10, r2v.m11, r2v.m12, r2v.m13, r2v.m20, r2v.m21, r2v.m22, r2v.m23, r2v.m30, r2v.m31, r2v.m32, r2v.m33);
            return true;
        }
        return false;
    }

    @Override
    public void setPerspective(boolean b) {
        this.connection.execute(new RmCommand(13, new Object[]{new Boolean(b)}, true));
        super.setPerspective(b);
    }

    @Override
    public void setLookPoint(double[] point) {
        this.connection.execute(new RmCommand(14, new Object[]{point}, true));
        super.setLookPoint(point);
    }

    @Override
    public void setEyePoint(double[] point) {
        this.connection.execute(new RmCommand(15, new Object[]{point}, true));
        super.setEyePoint(point);
    }

    @Override
    public void setUp(double[] vec) {
        this.connection.execute(new RmCommand(16, new Object[]{vec}, true));
        super.setUp(vec);
    }

    @Override
    public void setCamera(double[] eyepoint, double[] lookpoint, double[] up) {
        this.connection.execute(new RmCommand(17, new Object[]{eyepoint, lookpoint, up}, true));
        super.setCamera(eyepoint, lookpoint, up);
    }

    @Override
    public void setViewHeight(double height) {
        this.connection.execute(new RmCommand(19, new Object[]{new Double(height)}, true));
        super.setViewHeight(height);
    }

    @Override
    public void setViewClip(double[] clipOffsets) {
        this.connection.execute(new RmCommand(18, new Object[]{clipOffsets}, true));
        super.setViewClip(clipOffsets);
    }

    @Override
    public int getDepthStep(int x, int y) {
        Integer dstep = (Integer)this.connection.execute(new RmCommand(20, new Object[]{new Integer(x), new Integer(y)}, true));
        return dstep;
    }

    @Override
    public double[] getRASCoords(int x, int y, double[] rasCoords) {
        if (rasCoords == null) {
            rasCoords = new double[3];
        }
        double[] rcoords = (double[])this.connection.execute(new RmCommand(21, new Object[]{new Integer(x), new Integer(y)}, true));
        System.arraycopy(rcoords, 0, rasCoords, 0, 3);
        return rasCoords;
    }

    @Override
    public double getValue(int x, int y) {
        Double value = (Double)this.connection.execute(new RmCommand(23, new Object[]{new Integer(x), new Integer(y)}, true));
        return value;
    }

    @Override
    public double[] getVolumeCoords(int x, int y, double[] vCoords) {
        double[] volCoords = vCoords;
        if (volCoords == null) {
            volCoords = new double[3];
        }
        double[] vcoords = (double[])this.connection.execute(new RmCommand(22, new Object[]{new Integer(x), new Integer(y)}, true));
        System.arraycopy(vcoords, 0, volCoords, 0, 3);
        return volCoords;
    }

    @Override
    public Object createThreadData() {
        return null;
    }

    @Override
    public void renderPixels(int thread_id, int renderOutputLayer, int x0, int y0, int width, int height, int stepx, int stepy, Object thread_data) {
        System.err.println(">>> Invalid for client render engine..");
    }

    @Override
    public int renderPixel(int thread_id, int renderOutputLayer, int x, int y, Object thread_data) {
        Integer pixval = (Integer)this.connection.execute(new RmCommand(7, new Object[]{new Integer(renderOutputLayer), new Integer(x), new Integer(y)}, true));
        return pixval;
    }

    public int renderPass(int renderOutputLayer, int passno) {
        RmPixelBuffer pixels = this.connection.render(renderOutputLayer, passno, (byte)55);
        int remainingPasses = pixels.decodeMultipass(this);
        this.client_mp.setFillAlgorithm(pixels.mpAlgorithmId);
        return remainingPasses;
    }

    @Override
    public boolean isRenderChange() {
        return false;
    }

    @Override
    public void setColorLut(VrColorLut colorLut) {
        this.connection.execute(new RmCommand(26, new Object[]{colorLut}, true));
        this.notifyChange();
    }

    @Override
    public void setRayTracer(RayTracer rt) {
        this.rt = rt;
        this.connection.execute(new RmCommand(34, new Object[]{rt}, true));
        this.notifyChange();
    }

    @Override
    public RayTracer getRayTracer() {
        return this.rt;
    }

    @Override
    public void setPreset(VrPreset preset) {
        this.preset = preset;
        this.connection.execute(new RmCommand(25, new Object[]{preset}, true));
        this.notifyChange();
    }

    @Override
    public VrPreset getPreset() {
        return this.preset;
    }

    @Override
    public void setSegmentationVisible(boolean segVisible) {
        this.segmentationVisible = segVisible;
        this.connection.execute(new RmCommand(32, new Object[]{new Boolean(segVisible)}, true));
        this.notifyChange();
    }

    @Override
    public boolean isSegmentationVisible() {
        return this.segmentationVisible;
    }

    @Override
    public void setSegmentationColorMap(int[] cmap) {
        this.seg_cmap = cmap;
        this.connection.execute(new RmCommand(33, new Object[]{cmap}, true));
        this.notifyChange();
    }

    @Override
    public int[] getSegmentationColorMap() {
        return this.seg_cmap;
    }

    @Override
    public boolean applySegmentation(short[] labels, int offset) {
        Boolean b = (Boolean)this.connection.execute(new RmCommand(27, new Object[]{labels, new Integer(offset)}, true));
        this.notifyChange();
        return b;
    }

    @Override
    public boolean applySegmentation(byte[] bgrid) {
        Boolean b = (Boolean)this.connection.execute(new RmCommand(27, new Object[]{bgrid, new Integer(0)}, true));
        this.notifyChange();
        return b;
    }

    @Override
    public boolean intersect(byte[] bgrid) {
        Boolean b = (Boolean)this.connection.execute(new RmCommand(29, new Object[]{bgrid}, true));
        this.notifyChange();
        return b;
    }

    @Override
    public boolean union(byte[] bgrid) {
        Boolean b = (Boolean)this.connection.execute(new RmCommand(30, new Object[]{bgrid}, true));
        this.notifyChange();
        return b;
    }

    @Override
    public boolean negation() {
        Boolean b = (Boolean)this.connection.execute(new RmCommand(31, new Object[0], true));
        this.notifyChange();
        return b;
    }

    @Override
    public void clearSegmentation() {
        this.connection.execute(new RmCommand(28, new Object[0], true));
        this.notifyChange();
    }

    public String[] getSupportedCodecs() {
        return this.connection.getSupportedCodecs();
    }

    public String getCodec() {
        return this.connection.getCodec();
    }

    public boolean setCodec(String codecName) {
        return this.connection.setCodec(codecName);
    }

    private static class ClientMultiPassAlgorithm
    implements MultipassAlgorithm {
        private IterativeRenderer renderer = null;
        private RmClient3DEngine c3d = null;
        private MultipassAlgorithm[] filler = null;
        private int fillerIdx = -1;

        public ClientMultiPassAlgorithm(RmClient3DEngine c3d) {
            this.c3d = c3d;
        }

        @Override
        public void shutdown() {
            this.renderer = null;
            this.c3d = null;
            for (MultipassAlgorithm multipassAlgorithm : this.filler) {
                multipassAlgorithm.shutdown();
            }
            this.filler = null;
        }

        public void setFillAlgorithm(int fillIdx) {
            this.fillerIdx = fillIdx;
        }

        public void setFillAlgorithmTable(Class[] mpalg) {
            this.filler = new MultipassAlgorithm[mpalg.length];
            for (int i = 0; i < mpalg.length; ++i) {
                this.filler[i] = this.createFillAlgorithm(mpalg[i]);
            }
        }

        private MultipassAlgorithm createFillAlgorithm(Class fillerClass) {
            Constructor c = null;
            MultipassAlgorithm filler_alg = null;
            try {
                c = fillerClass.getConstructor(ParallelTaskManager.class);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (c != null) {
                try {
                    filler_alg = (MultipassAlgorithm)c.newInstance(this.c3d.getParallelTaskManager());
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    c = fillerClass.getConstructor(null);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                try {
                    filler_alg = (MultipassAlgorithm)c.newInstance(null);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            filler_alg.setT3DIRenderer(this.c3d);
            return filler_alg;
        }

        @Override
        public int render(int x, int y, int w, int h, int renderOutputLayer, int passno) {
            return this.c3d.renderPass(renderOutputLayer, passno);
        }

        @Override
        public void fill(int x, int y, int w, int h, int renderOutputLayer, int passno) {
            this.filler[this.fillerIdx].fill(x, y, w, h, renderOutputLayer, passno);
        }

        @Override
        public void setT3DIRenderer(IterativeRenderer renderer) {
            this.renderer = renderer;
        }

        @Override
        public IterativeRenderer getT3DIRenderer() {
            return this.renderer;
        }

        @Override
        public String getDescriptor() {
            return this.getClass().getCanonicalName();
        }
    }
}

