/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.remote;

import com.ge.med.idc.RemoteVolume;
import com.ge.med.idc.XjTagValue;
import com.ge.med.idc.XjVolume;
import com.ge.med.terra.jami.remote.RmServerDataManager;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMVolume;
import com.ge.med.terra.tap.util.clientServer.Utils;
import com.ge.med.terra.tap.util.clientServer.XmBasicService;
import com.ge.med.terra.tap.util.clientServer.XmSession;
import com.ge.med.terra.tap.util.dicom.tag;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class XmVolume
extends XmBasicService
implements RemoteVolume {
    private static final byte BUILD_CMD = 0;
    private static final byte QUERY_DIMENSION_CMD = 1;
    private static final byte QUERY_ENDIANESS_CMD = 2;
    private static final byte QUERY_BPV_CMD = 3;
    private static final byte QUERY_XDIR_CMD = 4;
    private static final byte QUERY_YDIR_CMD = 5;
    private static final byte QUERY_ZDIR_CMD = 6;
    private static final byte QUERY_ORIG_CMD = 7;
    private static final byte QUERY_VALUE_CMD = 8;
    private static final byte QUERY_VALUES_CMD = 9;
    private static final byte QUERY_VSLICE_VAL_CMD = 10;
    private static final byte QUERY_PIX_TYPE_CMD = 11;
    private static final byte QUERY_REL_COMP_CMD = 12;
    private static final byte NUM_METHODS = 13;
    private static final String[] methodNames = new String[13];
    private static final byte RET_TYPE_OBJ = 0;
    private static final byte RET_TYPE_STRING = 1;
    private static final byte RET_TYPE_DOUBLE = 2;
    private static final byte RET_TYPE_FLOAT = 3;
    private static final byte RET_TYPE_LONG = 4;
    private static final byte RET_TYPE_INT = 5;
    private static final byte RET_TYPE_SHORT = 6;
    private static final byte RET_TYPE_BYTE = 7;
    private DMVolume vol = null;
    private int volId = -1;
    boolean[] endianCache_;
    int[] bitsPerVoxelCache_;
    int pixType;
    boolean pixTypeCached_;
    String relatedComposite;
    Map vsliceValueMap;
    Map vsliceValueCachedMap;
    Map valueMap;
    Map valueCachedMap;
    Map tagValueMap;
    Map tagValueCachedMap;
    double[] origCache_;
    int[] dimCache_;
    double[] xdirCache_;
    double[] ydirCache_;
    double[] zdirCache_;

    public static void main(String[] args) {
        XmSession xms = new XmSession(args == null || args.length == 0 ? "127.0.0.1" : args[0], 7483);
        XmVolume vol = new XmVolume(xms, "C:/images/pesi/images/direct3d/direct3d/direct3d");
        int[] dims = vol.getVolumeDimensions(null);
        System.err.println(Arrays.toString(dims));
        System.err.println(vol.getBitsPerVoxel());
        System.err.println(Arrays.toString(vol.getXDirectionRAS(null)));
        System.err.println(Arrays.toString(vol.getYDirectionRAS(null)));
        System.err.println(Arrays.toString(vol.getZDirectionRAS(null)));
        System.err.println(Arrays.toString(vol.getRASOfOrigin(null)));
        System.err.println(vol.getRelatedComposite());
        System.err.println(vol.getValue(40, 16));
        System.err.println(vol.getValue(16, 16));
        System.err.println(vol.getVSliceValue(2, 16, 16));
    }

    public XmVolume() {
        XmVolume.methodNames[0] = "buildVolume";
        XmVolume.methodNames[1] = "getDimensions";
        XmVolume.methodNames[2] = "isLittleEndian";
        XmVolume.methodNames[3] = "getBitsPerVoxel";
        XmVolume.methodNames[4] = "getXDir";
        XmVolume.methodNames[5] = "getYDir";
        XmVolume.methodNames[6] = "getZDir";
        XmVolume.methodNames[7] = "getOrig";
        XmVolume.methodNames[8] = "getValue";
        XmVolume.methodNames[9] = "getValues";
        XmVolume.methodNames[10] = "getVSliceValue";
        XmVolume.methodNames[11] = "getPixType";
        XmVolume.methodNames[12] = "getRelatedComposite";
        this.setMethods(methodNames);
        this.vsliceValueMap = new HashMap();
        this.vsliceValueCachedMap = new HashMap();
        this.valueMap = new HashMap();
        this.valueCachedMap = new HashMap();
        this.tagValueMap = new HashMap();
        this.tagValueCachedMap = new HashMap();
    }

    public XmVolume(XmSession xms, String remotePath) {
        XmVolume.methodNames[0] = "buildVolume";
        XmVolume.methodNames[1] = "getDimensions";
        XmVolume.methodNames[2] = "isLittleEndian";
        XmVolume.methodNames[3] = "getBitsPerVoxel";
        XmVolume.methodNames[4] = "getXDir";
        XmVolume.methodNames[5] = "getYDir";
        XmVolume.methodNames[6] = "getZDir";
        XmVolume.methodNames[7] = "getOrig";
        XmVolume.methodNames[8] = "getValue";
        XmVolume.methodNames[9] = "getValues";
        XmVolume.methodNames[10] = "getVSliceValue";
        XmVolume.methodNames[11] = "getPixType";
        XmVolume.methodNames[12] = "getRelatedComposite";
        this.setMethods(methodNames);
        this.vsliceValueMap = new HashMap();
        this.vsliceValueCachedMap = new HashMap();
        this.valueMap = new HashMap();
        this.valueCachedMap = new HashMap();
        this.tagValueMap = new HashMap();
        this.tagValueCachedMap = new HashMap();
        super.installInto(xms);
        this.bv(remotePath);
    }

    @Override
    public String getRemoteDescriptor() {
        String dicom_cmp = this.getRelatedComposite();
        int remoteSeparatorChar = dicom_cmp.lastIndexOf(47) >= 0 ? 47 : 92;
        int lastIndex = dicom_cmp.lastIndexOf(remoteSeparatorChar);
        String remoteDir = dicom_cmp.substring(0, lastIndex >= 0 ? lastIndex : dicom_cmp.length());
        return remoteDir;
    }

    @Override
    public int getRemoteId() {
        return this.volId;
    }

    public XjVolume getVolume() {
        return this.vol;
    }

    public long getVSliceOffset(int sliceNo) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public String getVSlicePath(int sliceNo) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public boolean isVolumeLittleEndian() {
        byte[] ret;
        if (this.endianCache_ == null && (ret = this.callSync((byte)2, null)) != null) {
            this.endianCache_ = new boolean[1];
            this.endianCache_[0] = Utils.getBoolean(ret, 0);
        }
        return this.endianCache_ != null ? this.endianCache_[0] : false;
    }

    @Override
    public int getBitsPerVoxel() {
        byte[] ret;
        if (this.bitsPerVoxelCache_ == null && (ret = this.callSync((byte)3, null)) != null) {
            this.bitsPerVoxelCache_ = new int[1];
            this.bitsPerVoxelCache_[0] = ret[0];
        }
        return this.bitsPerVoxelCache_ != null ? this.bitsPerVoxelCache_[0] : 0;
    }

    @Override
    public int getPixelType() {
        if (this.pixTypeCached_) {
            return this.pixType;
        }
        byte[] ret = this.callSync((byte)11, null);
        this.pixTypeCached_ = true;
        this.pixType = Utils.getInt(ret, 0);
        return this.pixType;
    }

    @Override
    public String getRelatedComposite() {
        if (this.relatedComposite != null) {
            return this.relatedComposite;
        }
        byte[] ret = this.callSync((byte)12, null);
        return Utils.getString(ret, 0);
    }

    @Override
    public Object getVSliceValue(int sliceNo, int group, int element) {
        vsliceKey k = new vsliceKey(sliceNo, group, element);
        if (this.vsliceValueCachedMap.get(k) != null) {
            return this.vsliceValueMap.get(k);
        }
        byte[] data = new byte[12];
        Utils.putInt(data, 0, sliceNo);
        Utils.putInt(data, 4, group);
        Utils.putInt(data, 8, element);
        byte[] ret = this.callSync((byte)10, data);
        this.vsliceValueCachedMap.put(k, Boolean.TRUE);
        if (ret != null) {
            Object o = XmVolume.decodeValue(ret);
            if (o == null) {
                o = Utils.bytesToObject(ret);
            }
            if (o != null) {
                this.vsliceValueMap.put(k, o);
            }
            return o;
        }
        return null;
    }

    @Override
    public Object getValue(int group, int element) {
        tag t = new tag((short)group, (short)element);
        if (this.valueCachedMap.get(t) != null) {
            return this.valueMap.get(t);
        }
        byte[] tagarray = new byte[8];
        Utils.putInt(tagarray, 0, group);
        Utils.putInt(tagarray, 4, element);
        byte[] ret = this.callSync((byte)8, tagarray);
        Object val = null;
        if (ret != null && (val = XmVolume.decodeValue(ret)) == null && ret[0] == 0) {
            val = Utils.bytesToObject(ret, 1, ret.length - 1);
        }
        this.valueCachedMap.put(t, Boolean.TRUE);
        if (val != null) {
            this.valueMap.put(t, val);
        }
        return val;
    }

    @Override
    public int getValues(XjTagValue[] tv) {
        int count = 0;
        for (int i = 0; tv != null && i < tv.length; ++i) {
            tag t = new tag((short)tv[i].group, (short)tv[i].element);
            Object tagValue2 = this.tagValueCachedMap.get(t);
            if (tagValue2 != null) {
                if (!(tagValue2 instanceof XjTagValue)) continue;
                XjTagValue xjtv = (XjTagValue)tagValue2;
                tv[i].littleEndian = xjtv.littleEndian;
                tv[i].noValue = xjtv.noValue;
                tv[i].offset = xjtv.offset;
                tv[i].vr = xjtv.vr;
                tv[i].value = xjtv.value;
                ++count;
                continue;
            }
            byte[] data = new byte[8];
            Utils.putInt(data, 0, t.group);
            Utils.putInt(data, 4, t.element);
            byte[] ret = this.callSync((byte)9, data);
            if (ret == null) {
                this.tagValueCachedMap.put(t, Boolean.TRUE);
                continue;
            }
            XjTagValue xjtv = new XjTagValue();
            xjtv.group = t.group;
            xjtv.element = t.element;
            xjtv.littleEndian = Utils.getBoolean(ret, 0);
            xjtv.noValue = Utils.getBoolean(ret, 1);
            xjtv.offset = Utils.getLong(ret, 2);
            xjtv.vr = Utils.getInt(ret, 10);
            xjtv.value = ret[14] == 1 ? new String(ret, 15, ret.length - 15) : Utils.bytesToObject(ret, 15, ret.length - 15);
            ++count;
            this.tagValueCachedMap.put(t, Boolean.TRUE);
            this.tagValueMap.put(t, xjtv);
            tv[i].littleEndian = xjtv.littleEndian;
            tv[i].noValue = xjtv.noValue;
            tv[i].offset = xjtv.offset;
            tv[i].vr = xjtv.vr;
            tv[i].value = xjtv.value;
            ++count;
        }
        return count;
    }

    @Override
    public double[] getRASOfOrigin(double[] ras_ulc) {
        byte[] ret;
        if (this.origCache_ == null && (ret = this.callSync((byte)7, null)) != null) {
            this.origCache_ = new double[3];
            this.origCache_[0] = Utils.getDouble(ret, 0);
            this.origCache_[1] = Utils.getDouble(ret, 8);
            this.origCache_[2] = Utils.getDouble(ret, 16);
        }
        if (ras_ulc == null || ras_ulc.length < 3) {
            ras_ulc = new double[3];
        }
        System.arraycopy(this.origCache_, 0, ras_ulc, 0, 3);
        return ras_ulc;
    }

    @Override
    public int[] getVolumeDimensions(int[] dims) {
        byte[] ret;
        if (this.dimCache_ == null && (ret = this.callSync((byte)1, null)) != null) {
            this.dimCache_ = new int[3];
            this.dimCache_[0] = Utils.getInt(ret, 0);
            this.dimCache_[1] = Utils.getInt(ret, 4);
            this.dimCache_[2] = Utils.getInt(ret, 8);
        }
        if (dims == null || dims.length < 3) {
            dims = new int[3];
        }
        System.arraycopy(this.dimCache_, 0, dims, 0, 3);
        return dims;
    }

    @Override
    public double[] getXDirectionRAS(double[] ras_dx) {
        byte[] ret;
        if (this.xdirCache_ == null && (ret = this.callSync((byte)4, null)) != null) {
            this.xdirCache_ = new double[3];
            this.xdirCache_[0] = Utils.getDouble(ret, 0);
            this.xdirCache_[1] = Utils.getDouble(ret, 8);
            this.xdirCache_[2] = Utils.getDouble(ret, 16);
        }
        if (ras_dx == null || ras_dx.length < 3) {
            ras_dx = new double[3];
        }
        System.arraycopy(this.xdirCache_, 0, ras_dx, 0, 3);
        return ras_dx;
    }

    @Override
    public double[] getYDirectionRAS(double[] ras_dx) {
        byte[] ret;
        if (this.ydirCache_ == null && (ret = this.callSync((byte)5, null)) != null) {
            this.ydirCache_ = new double[3];
            this.ydirCache_[0] = Utils.getDouble(ret, 0);
            this.ydirCache_[1] = Utils.getDouble(ret, 8);
            this.ydirCache_[2] = Utils.getDouble(ret, 16);
        }
        if (ras_dx == null || ras_dx.length < 3) {
            ras_dx = new double[3];
        }
        System.arraycopy(this.ydirCache_, 0, ras_dx, 0, 3);
        return ras_dx;
    }

    @Override
    public double[] getZDirectionRAS(double[] ras_dx) {
        byte[] ret;
        if (this.zdirCache_ == null && (ret = this.callSync((byte)6, null)) != null) {
            this.zdirCache_ = new double[3];
            this.zdirCache_[0] = Utils.getDouble(ret, 0);
            this.zdirCache_[1] = Utils.getDouble(ret, 8);
            this.zdirCache_[2] = Utils.getDouble(ret, 16);
        }
        if (ras_dx == null || ras_dx.length < 3) {
            ras_dx = new double[3];
        }
        System.arraycopy(this.zdirCache_, 0, ras_dx, 0, 3);
        return ras_dx;
    }

    public void connectionList() {
        super.connectionLost();
    }

    public byte[] buildVolume(byte[] data) {
        String path = Utils.getString(data, 0);
        System.err.println("XmVolume.buildVolume(): Path: " + path);
        DMSession ses = new DMSession(new String[]{"file", path});
        DMObject[] dmo = ses.getRelated("series");
        this.vol = DMVolume.buildVolume("DMObjectVolume", new Object[]{dmo[0]});
        this.volId = RmServerDataManager.instance().addDataObject(this.vol);
        byte[] retval = new byte[4];
        Utils.putInt(retval, 0, this.volId);
        return retval;
    }

    public byte[] getDimensions(byte[] data) {
        if (this.vol == null) {
            return null;
        }
        int[] dims = this.vol.getVolumeDimensions(null);
        byte[] ret = new byte[12];
        Utils.putInt(ret, 0, dims[0]);
        Utils.putInt(ret, 4, dims[1]);
        Utils.putInt(ret, 8, dims[2]);
        return ret;
    }

    public byte[] isLittleEndian(byte[] data) {
        if (this.vol == null) {
            return null;
        }
        boolean b = this.vol.isVolumeLittleEndian();
        byte[] ret = new byte[1];
        Utils.putBoolean(ret, 0, b);
        return ret;
    }

    public byte[] getBitsPerVoxel(byte[] data) {
        if (this.vol == null) {
            return null;
        }
        int b = this.vol.getBitsPerVoxel();
        byte[] ret = new byte[]{(byte)b};
        return ret;
    }

    public byte[] getOrig(byte[] data) {
        if (this.vol == null) {
            return null;
        }
        double[] orig = this.vol.getRASOfOrigin(null);
        byte[] ret = new byte[24];
        Utils.putDouble(ret, 0, orig[0]);
        Utils.putDouble(ret, 8, orig[1]);
        Utils.putDouble(ret, 16, orig[2]);
        return ret;
    }

    public byte[] getXDir(byte[] data) {
        if (this.vol == null) {
            return null;
        }
        double[] dir = this.vol.getXDirectionRAS(null);
        byte[] ret = new byte[24];
        Utils.putDouble(ret, 0, dir[0]);
        Utils.putDouble(ret, 8, dir[1]);
        Utils.putDouble(ret, 16, dir[2]);
        return ret;
    }

    public byte[] getYDir(byte[] data) {
        if (this.vol == null) {
            return null;
        }
        double[] dir = this.vol.getYDirectionRAS(null);
        byte[] ret = new byte[24];
        Utils.putDouble(ret, 0, dir[0]);
        Utils.putDouble(ret, 8, dir[1]);
        Utils.putDouble(ret, 16, dir[2]);
        return ret;
    }

    public byte[] getZDir(byte[] data) {
        if (this.vol == null) {
            return null;
        }
        double[] dir = this.vol.getZDirectionRAS(null);
        byte[] ret = new byte[24];
        Utils.putDouble(ret, 0, dir[0]);
        Utils.putDouble(ret, 8, dir[1]);
        Utils.putDouble(ret, 16, dir[2]);
        return ret;
    }

    private static Object decodeValue(byte[] ret) {
        Object value = null;
        if (ret[0] == 1) {
            value = Utils.getString(ret, 1);
        } else if (ret[0] == 2) {
            value = Utils.getDouble(ret, 1);
        } else if (ret[0] == 3) {
            value = Float.valueOf(Utils.getFloat(ret, 1));
        } else if (ret[0] == 5) {
            value = Utils.getInt(ret, 1);
        } else if (ret[0] == 6) {
            value = Utils.getShort(ret, 1);
        } else if (ret[0] == 7) {
            value = new Byte(ret[1]);
        } else if (ret[0] == 4) {
            value = Utils.getLong(ret, 1);
        }
        return value;
    }

    private static byte[] encodeValue(Object o) {
        if (o instanceof String) {
            byte[] ret = new byte[Utils.getStringLengthInBytes((String)o) + 1];
            Utils.putString(ret, 1, (String)o);
            ret[0] = 1;
            return ret;
        }
        if (o instanceof Double) {
            int len = 8;
            byte[] ret = new byte[len + 1];
            Utils.putDouble(ret, 1, (Double)o);
            ret[0] = 2;
        } else if (o instanceof Float) {
            int len = 4;
            byte[] ret = new byte[len + 1];
            Utils.putFloat(ret, 1, ((Float)o).floatValue());
            ret[0] = 3;
        } else if (o instanceof Integer) {
            int len = 4;
            byte[] ret = new byte[len + 1];
            Utils.putInt(ret, 1, (Integer)o);
            ret[0] = 5;
        } else if (o instanceof Short) {
            int len = 2;
            byte[] ret = new byte[len + 1];
            Utils.putShort(ret, 1, (Short)o);
            ret[0] = 6;
        } else if (o instanceof Byte) {
            int len = 1;
            byte[] ret = new byte[len + 1];
            ret[1] = (Byte)o;
            ret[0] = 7;
        } else if (o instanceof Long) {
            int len = 8;
            byte[] ret = new byte[len + 1];
            Utils.putLong(ret, 1, (Long)o);
            ret[0] = 4;
        }
        return null;
    }

    public byte[] getValue(byte[] data) {
        int element;
        if (this.vol == null) {
            return null;
        }
        int group = Utils.getInt(data, 0);
        Object o = this.vol.getValue(group, element = Utils.getInt(data, 4));
        byte[] retval = XmVolume.encodeValue(o);
        if (retval != null) {
            return retval;
        }
        byte[] oarr = Utils.objectToBytes(o);
        byte[] ret = new byte[oarr.length + 1];
        ret[0] = 0;
        System.arraycopy(oarr, 0, ret, 1, oarr.length);
        return ret;
    }

    public byte[] getVSliceValue(byte[] data) {
        int element;
        int group;
        if (this.vol == null) {
            return null;
        }
        int sliceNo = Utils.getInt(data, 0);
        Object o = this.vol.getVSliceValue(sliceNo, group = Utils.getInt(data, 4), element = Utils.getInt(data, 8));
        byte[] retval = XmVolume.encodeValue(o);
        if (retval != null) {
            return retval;
        }
        return o != null ? Utils.objectToBytes(o) : null;
    }

    public byte[] getValues(byte[] data) {
        if (this.vol == null) {
            return null;
        }
        int group = Utils.getInt(data, 0);
        int element = Utils.getInt(data, 4);
        XjTagValue xjtv = new XjTagValue();
        xjtv.group = group;
        xjtv.element = element;
        this.vol.getValues(new XjTagValue[]{xjtv});
        byte[] objbytes = null;
        objbytes = xjtv.value instanceof String ? ((String)xjtv.value).getBytes() : Utils.objectToBytes(xjtv.value);
        byte[] ret = new byte[14 + objbytes.length + 1];
        Utils.putBoolean(ret, 0, xjtv.littleEndian);
        Utils.putBoolean(ret, 1, xjtv.noValue);
        Utils.putLong(ret, 2, xjtv.offset);
        Utils.putInt(ret, 10, xjtv.vr);
        ret[14] = xjtv.value instanceof String ? (byte)1 : 0;
        System.arraycopy(objbytes, 0, ret, 15, objbytes.length);
        return ret;
    }

    public byte[] getPixType(byte[] data) {
        if (this.vol == null) {
            return null;
        }
        byte[] ret = new byte[4];
        Utils.putInt(ret, 0, this.vol.getPixelType());
        return ret;
    }

    public byte[] getRelatedComposite(byte[] data) {
        if (this.vol == null) {
            return null;
        }
        String path = this.vol.getRelatedComposite();
        byte[] buf = new byte[path.length() * 2 + 3];
        Utils.putString(buf, 0, path);
        return buf;
    }

    private void bv(String path) {
        byte[] buf = new byte[Utils.getStringLengthInBytes(path)];
        Utils.putString(buf, 0, path);
        try {
            byte[] returnVal = this.callSync((byte)0, buf);
            this.volId = Utils.getInt(returnVal, 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static class vsliceKey {
        int group;
        int element;
        int slice;

        public vsliceKey(int s, int g, int e) {
            this.group = g;
            this.element = e;
            this.slice = s;
        }
    }
}

