/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr;

import com.ge.med.jnu.JnMatrix3d;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.RayCastPlaneVolume;
import com.ge.med.terra.jami.JVolume;
import com.ge.med.terra.jami.j3d.RayCastCalculator;
import com.ge.med.terra.jami.j3d.vr.VrContext;
import com.ge.med.terra.jami.j3d.vr.VrPresetCurves;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class VrCamera {
    public static final int MAX_VRCONTEXT = 5;
    private boolean perspective = false;
    public float[] directions = null;
    private boolean highQuality = true;
    public VrContext vr_ctxt = null;
    private List auxiliaryVolumes = new ArrayList();
    public Map user_data = null;
    public double[] light = new double[3];
    public double[] ul = new double[3];
    public double[] xstep = new double[3];
    public double[] ystep = new double[3];
    public double[] zstep = new double[3];
    public int[] output = null;
    public byte[] stencil_raster = null;
    public byte[] ray_raster = null;
    public short[] lum_raster = null;
    public short[] depth_buffer = null;
    public int owidth = 0;
    public int oheight = 0;
    private int background = 0;
    private double[] backgroundf = new double[3];
    private int air_value = -2048;
    public int[] startBuff = null;
    public int[] endBuff = null;
    private RayCastCalculator raycalc = null;
    private boolean useVoi = true;
    public double[] eyePointVol = new double[3];
    public double[] lookPointVol = new double[3];

    public VrCamera(VrContext ctxt) {
        this(ctxt, null);
    }

    public VrCamera(VrContext ctxt, RayCastCalculator rcCalc) {
        this.initVrCamera(ctxt, rcCalc);
    }

    public void initVrCamera(VrContext ctxt, RayCastCalculator rcCalc) {
        this.vr_ctxt = ctxt;
        JVolume.LinearVolume vol = ctxt.vol;
        this.raycalc = rcCalc;
        if (this.raycalc == null) {
            this.raycalc = new RayCastPlaneDef(vol.origin.toArray(), vol.dir_x.toArray(), vol.dir_y.toArray(), vol.dir_z.toArray(), vol.dx, vol.dy, vol.dz);
        } else {
            this.raycalc.setVolume(vol.origin.toArray(), vol.dir_x.toArray(), vol.dir_y.toArray(), vol.dir_z.toArray(), vol.dx, vol.dy, vol.dz);
        }
        this.setBackground(this.background);
    }

    public RayCastCalculator getRayCastCalculator() {
        return this.raycalc;
    }

    public void setUseVoi(boolean useVoi) {
        this.useVoi = useVoi;
        this.updateVolumeBounds();
    }

    public boolean isUseVoi() {
        return this.useVoi;
    }

    public void updateVolumeBounds() {
        if (this.vr_ctxt != null) {
            if (this.isUseVoi()) {
                this.raycalc.updateBoundingBox(this.vr_ctxt.bbox.min, this.vr_ctxt.bbox.max);
            } else {
                int dx = this.vr_ctxt.vol.dx;
                int dy = this.vr_ctxt.vol.dy;
                int dz = this.vr_ctxt.vol.dz;
                this.raycalc.updateBoundingBox(new int[]{0, 0, 0}, new int[]{dx - 1, dy - 1, dz - 1});
            }
        }
    }

    public void setDisplaySession(int[] output, short[] lum_raster, short[] depth_buff, int w, int h) {
        this.output = output;
        this.owidth = w;
        this.oheight = h;
        this.lum_raster = lum_raster != null ? lum_raster : new short[w * h];
        this.ray_raster = new byte[w * h];
        this.startBuff = new int[w * h];
        this.endBuff = new int[w * h];
        this.depth_buffer = depth_buff;
        this.stencil_raster = new byte[w * h];
        this.directions = new float[w * h * 3];
        this.updateVolumeBounds();
    }

    public void setDisplaySession(int[] output, short[] depth_buff, int w, int h) {
        this.setDisplaySession(output, null, depth_buff, w, h);
    }

    public void setVRView(JnMatrix3d view_mat, double[] eye_pt, double[] look_pt, double fovX, double fovY) {
        System.arraycopy(eye_pt, 0, this.eyePointVol, 0, 3);
        System.arraycopy(look_pt, 0, this.lookPointVol, 0, 3);
        int n_int = this.raycalc.raycastPlaneVolume(this.isPerspective(), fovX, fovY, view_mat, eye_pt, look_pt, this.owidth, this.oheight, this.startBuff, this.endBuff, this.ul, this.xstep, this.ystep, this.zstep, this.directions, this.ray_raster);
        int ctype = 105;
        if (this.vr_ctxt.preset != null) {
            ctype = VrPresetCurves.vr_curvetype(this.vr_ctxt.preset.curvetype);
        }
        switch (ctype) {
            case 104: {
                this.light[0] = view_mat.m02 + view_mat.m00 - view_mat.m01;
                this.light[1] = view_mat.m12 + view_mat.m10 - view_mat.m11;
                this.light[2] = view_mat.m22 + view_mat.m20 - view_mat.m21;
                break;
            }
            default: {
                this.light[0] = this.zstep[0];
                this.light[1] = this.zstep[1];
                this.light[2] = this.zstep[2];
            }
        }
        JnVector3d.normalize(this.light);
        Arrays.fill(this.stencil_raster, (byte)0);
        Arrays.fill(this.depth_buffer, (short)8192);
    }

    public boolean isHighQuality() {
        return this.highQuality;
    }

    public void setHighQuality(boolean highQuality) {
        this.highQuality = highQuality;
    }

    public boolean isPerspective() {
        return this.perspective;
    }

    public void setPerspective(boolean perspective) {
        this.perspective = perspective;
    }

    public void setBackground(int bg) {
        this.background = bg;
        this.backgroundf[0] = (double)((this.background & 0xFF0000) >> 16) / 255.0;
        this.backgroundf[1] = (double)((this.background & 0xFF00) >> 8) / 255.0;
        this.backgroundf[2] = (double)(this.background & 0xFF) / 255.0;
    }

    public final int getBackground() {
        return this.background;
    }

    public final int getAirValue() {
        return this.air_value;
    }

    public final void setAirValue(int air_val) {
        this.air_value = air_val;
    }

    public final double[] getBackgroundf() {
        return this.backgroundf;
    }

    public int getNumVolumes() {
        return 1 + this.auxiliaryVolumes.size();
    }

    public JVolume.LinearVolume getVolume(int volumeId) {
        if (volumeId == 0) {
            return this.vr_ctxt.vol;
        }
        return (JVolume.LinearVolume)this.auxiliaryVolumes.get(volumeId - 1);
    }

    public void removeVolume(int volumeId) {
        if (volumeId > 0) {
            this.auxiliaryVolumes.remove(volumeId - 1);
        }
    }

    public int addVolume(JVolume.LinearVolume vol) {
        this.auxiliaryVolumes.add(vol);
        return this.auxiliaryVolumes.size();
    }

    public void clearVolumes() {
        this.auxiliaryVolumes.clear();
    }

    private static class RayCastPlaneDef
    implements RayCastCalculator {
        private RayCastPlaneVolume rcpVol = null;

        public RayCastPlaneDef(double[] vol_origin, double[] dir_x, double[] dir_y, double[] dir_z, int dx, int dy, int dz) {
            this.rcpVol = new RayCastPlaneVolume(vol_origin, dir_x, dir_y, dir_z, dx, dy, dz);
        }

        @Override
        public void setVolume(double[] vol_origin, double[] dir_x, double[] dir_y, double[] dir_z, int dx, int dy, int dz) {
            this.rcpVol.setVolume(vol_origin, dir_x, dir_y, dir_z, dx, dy, dz);
        }

        @Override
        public int raycastPlaneVolume(boolean perspective, double fovX, double fovY, JnMatrix3d rot, double[] eye_pt, double[] look_pt, int w, int h, int[] start, int[] end, double[] ul_vol, double[] xvec, double[] yvec, double[] zvec, float[] directions, byte[] raster) {
            if (perspective) {
                return this.rcpVol.raycastPerspectivePlaneVolume(fovX, fovY, rot, eye_pt, look_pt, w, h, start, end, ul_vol, xvec, yvec, zvec, directions, raster);
            }
            return this.rcpVol.raycastPlaneVolume(fovX, fovY, rot, look_pt, w, h, start, end, ul_vol, xvec, yvec, zvec, raster);
        }

        @Override
        public void updateBoundingBox(int[] min, int[] max) {
            this.rcpVol.updateBoundingBox(min, max);
        }
    }
}

