/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr;

import com.ge.med.idc.TaskMonitor;
import com.ge.med.terra.jami.JVolume;
import com.ge.med.terra.jami.ParallelTaskManager;
import com.ge.med.terra.jami.Worker;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.j3d.vr.VrColorLut;
import com.ge.med.terra.jami.j3d.vr.VrPreset;
import com.ge.med.terra.jami.j3d.vr.VrPresetCurves;
import com.ge.med.terra.jami.render.PixelWindowing;
import com.ge.med.terra.jami.render.XpImagePixelAttributes;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class VrContext {
    public static final int MINMAX_SIDE_DIV = 2;
    public static final int MINMAX_DIV = 6;
    public static final int BINGRID_DIV = 3;
    public static final int BINGRID_MOD = 7;
    private static final String REFRESH_BINGRID = "REFRESH_BINGRID";
    public static final double CONTRIB_THRESHOLD = 1.0E-4;
    public JVolume.LinearVolume vol = null;
    public VrPreset preset = null;
    public VrPresetCurves presetCurves = null;
    private short[] mingrid = null;
    private short[] maxgrid = null;
    private byte[] bingrid = null;
    private byte[] base_bingrid = null;
    private byte[] seg_bingrid = null;
    public BoundingBox bbox = new BoundingBox();
    public int[] wlTable = new int[65536];
    private PixelWindowing pw = new PixelWindowing();
    private XpImagePixelAttributes ipa = new XpImagePixelAttributes();
    private List taskMonitors = new ArrayList();
    private static WeakReference weak_ptm;
    private ParallelTaskManager ptm = null;
    private Object minmaxLock = new Object();
    private boolean initMinMax = true;

    private ParallelTaskManager getThreadPool() {
        ParallelTaskManager ptm;
        if (weak_ptm != null && weak_ptm.get() != null) {
            ptm = (ParallelTaskManager)weak_ptm.get();
        } else {
            ptm = new ParallelTaskManager();
            weak_ptm = new WeakReference<ParallelTaskManager>(ptm);
        }
        return ptm;
    }

    public VrContext(JVolume.LinearVolume vol) {
        this.vol = vol;
        this.bbox.init();
        this.setWindowing(vol.initWW, vol.initWL);
    }

    private VrContext(JVolume.LinearVolume vol, VrPreset preset, byte[] bingrid, byte[] basebingrid, byte[] segbingrid, BoundingBox bb) {
        this(vol);
        this.preset = preset;
        this.base_bingrid = new byte[basebingrid.length];
        System.arraycopy(basebingrid, 0, this.base_bingrid, 0, basebingrid.length);
        this.bingrid = new byte[bingrid.length];
        System.arraycopy(bingrid, 0, this.bingrid, 0, bingrid.length);
        this.seg_bingrid = new byte[segbingrid.length];
        System.arraycopy(segbingrid, 0, this.seg_bingrid, 0, segbingrid.length);
        this.bbox.set(bb);
        this.init(false);
    }

    public void savePreset(String fileName) {
        if (this.presetCurves != null) {
            this.presetCurves.savePreset(fileName);
        }
    }

    public void setWindowing(double ww, double wl) {
        this.ipa.setWindowing(ww, wl);
        this.pw.fillColorTable(this.ipa, this.wlTable, this.vol.rescaleSlope, this.vol.rescaleIntercept, this.vol.pixelRepresentation);
    }

    public static VrContext genContext(JVolume.LinearVolume vol, VrPreset preset) {
        VrContext vrc = new VrContext(vol);
        vrc.setPreset(preset);
        return vrc;
    }

    public int[] createColorLut() {
        return this.presetCurves.createColorLut();
    }

    public void setPreset(VrPreset preset) {
        this.preset = preset;
        this.init(true);
    }

    public void setColorLut(VrColorLut clut) {
        this.presetCurves.build_colortable(clut.colorlut, clut.startX, clut.deltaX);
    }

    public final void refreshVrContext(int[] zpos, int zposlen) {
        double preset_scale = this.getModalityPresetScale();
        int[] rawthresh = this.modalityThreshToRaw(this.preset.thresh1, this.preset.thresh2, preset_scale);
        this.refresh_bingrid(rawthresh[0], rawthresh[1], zpos, zposlen, false, false);
    }

    private final void init(boolean initBingrid) {
        double preset_scale = this.getModalityPresetScale();
        int[] rawthresh = this.modalityThreshToRaw(this.preset.thresh1, this.preset.thresh2, preset_scale);
        this.presetCurves = new VrPresetCurves(this.preset, preset_scale, this.vol.rescaleSlope, this.vol.rescaleIntercept, this.vol.ras_spx, this.vol.ras_spy);
        if (initBingrid) {
            this.init_bingrid(rawthresh[0], rawthresh[1]);
        }
    }

    private double getModalityPresetScale() {
        double preset_scale = 1.0;
        if (this.preset != null && this.preset.modality.toUpperCase().equals("PET")) {
            preset_scale = 1000.0;
        }
        return preset_scale;
    }

    private int[] modalityThreshToRaw(int modthresh1, int modthresh2, double preset_scale) {
        JVolume.LinearVolume jvs = this.vol;
        double slope = jvs.rescaleSlope;
        double intercept = jvs.rescaleIntercept;
        double thresh1 = (double)modthresh1 * preset_scale;
        double thresh2 = (double)modthresh2 * preset_scale;
        int rawthresh1 = VrContext.raw_value(thresh1, slope, intercept);
        int rawthresh2 = VrContext.raw_value(thresh2, slope, intercept);
        return new int[]{rawthresh1, rawthresh2};
    }

    public final boolean bingridAnd(byte[] mask) {
        if (this.seg_bingrid != null && this.seg_bingrid.length == mask.length) {
            for (int i = 0; i < this.seg_bingrid.length; ++i) {
                int mval = mask[i] & 0xFF;
                int bval = this.seg_bingrid[i] & 0xFF;
                int sval = mval & bval;
                this.seg_bingrid[i] = (byte)sval;
                int bbval = this.base_bingrid[i] & 0xFF;
                this.bingrid[i] = (byte)(sval & bbval);
            }
            return true;
        }
        if (this.seg_bingrid != null) {
            XpLog.logger().warning("bingrid mismatch!" + this.seg_bingrid.length + " <-> " + mask.length);
        }
        return false;
    }

    public final boolean bingridOr(byte[] mask) {
        if (this.seg_bingrid != null && this.seg_bingrid.length == mask.length) {
            for (int i = 0; i < this.seg_bingrid.length; ++i) {
                int mval = mask[i] & 0xFF;
                int bval = this.seg_bingrid[i] & 0xFF;
                int sval = mval | bval;
                this.seg_bingrid[i] = (byte)sval;
                int bbval = this.base_bingrid[i] & 0xFF;
                this.bingrid[i] = (byte)(sval & bbval);
            }
            return true;
        }
        if (this.seg_bingrid != null) {
            XpLog.logger().warning("bingrid mismatch!" + this.seg_bingrid.length + " <-> " + mask.length);
        }
        return false;
    }

    public final boolean setSegBingrid(byte[] mask) {
        if (this.seg_bingrid != null && this.seg_bingrid.length == mask.length) {
            System.arraycopy(mask, 0, this.seg_bingrid, 0, this.seg_bingrid.length);
            for (int i = 0; i < this.seg_bingrid.length; ++i) {
                int bval = this.seg_bingrid[i] & 0xFF;
                int bbval = this.base_bingrid[i] & 0xFF;
                this.bingrid[i] = (byte)(bval & bbval);
            }
            return true;
        }
        if (this.seg_bingrid != null) {
            XpLog.logger().warning("bingrid mismatch!" + this.seg_bingrid.length + " <-> " + mask.length);
        }
        return false;
    }

    public final boolean bingridNot() {
        for (int i = 0; i < this.seg_bingrid.length; ++i) {
            int bval = this.seg_bingrid[i] & 0xFF;
            int sval = ~bval;
            this.seg_bingrid[i] = (byte)sval;
            int bbval = this.base_bingrid[i] & 0xFF;
            this.bingrid[i] = (byte)(sval & bbval);
        }
        return true;
    }

    public final void resetBingrid() {
        System.arraycopy(this.base_bingrid, 0, this.bingrid, 0, this.bingrid.length);
        Arrays.fill(this.seg_bingrid, (byte)-1);
        this.bbox.init();
        this.getBoundingBox(this.bingrid, this.vol.dx, this.vol.dy, this.vol.dz, this.bbox);
    }

    public void init_bingrid(double thresh1, double thresh2) {
        long t0 = System.currentTimeMillis();
        int[] zpos = new int[this.vol.dz];
        for (int i = 0; i < zpos.length; ++i) {
            zpos[i] = i;
        }
        int visible_voxels = this.refresh_bingrid(thresh1, thresh2, zpos, zpos.length, true, true);
        int totalvoxels = this.vol.dx * this.vol.dy * this.vol.dz;
        double pctvisible = (double)visible_voxels / (double)totalvoxels * 100.0;
        long t = System.currentTimeMillis() - t0;
        XpLog.logger().config("VrContext.init_bingrid: " + t + "  [" + pctvisible + "]");
        System.err.println("VrContext.init_bingrid: " + t + "  [" + pctvisible + "]");
    }

    public static double visible_grid(byte[] grid, int dx, int dy, int dz) {
        int rowlen = dx + 7 >> 3;
        int pgsize = rowlen * dy;
        int visible = 0;
        for (int z = 0; z < dz; ++z) {
            int zoffset = pgsize * z;
            for (int y = 0; y < dy; ++y) {
                int offset = zoffset + y * rowlen;
                for (int xx = 0; xx < rowlen; ++xx) {
                    byte grid_item = grid[offset + xx];
                    for (int i = 0; i < 8; ++i) {
                        int bit = grid_item >> i & 1;
                        visible += bit;
                    }
                }
            }
        }
        double pct = (double)visible / (double)(dx * dy * dz);
        return pct;
    }

    private static void mark_bingrid8(byte[] bingrid, int x, int y, int z, int bx, int by) {
        int ix = x;
        int iy = y;
        int iz = z;
        int bpsize = bx * by >> 3;
        int brsize = bx >> 3;
        int idx = iz * bx * by + iy * bx + ix;
        int mod = idx & 7;
        int v = 1 << mod;
        int n = idx >>= 3;
        bingrid[n] = (byte)(bingrid[n] | v);
        int n2 = idx - brsize;
        bingrid[n2] = (byte)(bingrid[n2] | v);
        int n3 = idx - bpsize;
        bingrid[n3] = (byte)(bingrid[n3] | v);
        int n4 = idx - bpsize - brsize;
        bingrid[n4] = (byte)(bingrid[n4] | v);
        if (mod > 0) {
            v = 1 << mod - 1;
            int n5 = idx;
            bingrid[n5] = (byte)(bingrid[n5] | v);
            int n6 = idx - brsize;
            bingrid[n6] = (byte)(bingrid[n6] | v);
            int n7 = idx - bpsize;
            bingrid[n7] = (byte)(bingrid[n7] | v);
            int n8 = idx - bpsize - brsize;
            bingrid[n8] = (byte)(bingrid[n8] | v);
        } else {
            v = 128;
            int n9 = --idx;
            bingrid[n9] = (byte)(bingrid[n9] | v);
            int n10 = idx - brsize;
            bingrid[n10] = (byte)(bingrid[n10] | v);
            int n11 = idx - bpsize;
            bingrid[n11] = (byte)(bingrid[n11] | v);
            int n12 = idx - bpsize - brsize;
            bingrid[n12] = (byte)(bingrid[n12] | v);
        }
    }

    private void build_minmax_thread(int x0, int xstep, int mdx, int mdy, int mdz, int mpgsize) {
        int MINMAX_SIDE = 4;
        int VOL_OFFSET = this.vol.PAD;
        int pgsize = this.vol.dx * this.vol.dy;
        if (this.vol instanceof JVolume.LinearShort) {
            short[] volume = ((JVolume.LinearShort)this.vol).volume;
            for (int z = 0; z < mdz - 1; ++z) {
                int iz = z << 2;
                int zoffset = z * mpgsize;
                for (int y = 0; y < mdy - 1; ++y) {
                    int iy = y << 2;
                    int moffset = zoffset + y * mdx;
                    for (int x = x0; x < mdx - 1; x += xstep) {
                        int ix = x << 2;
                        short s = Integer.MAX_VALUE;
                        short s2 = Integer.MIN_VALUE;
                        for (int zz = 0; zz <= 4; ++zz) {
                            int zzoffset = VOL_OFFSET + (iz + zz) * pgsize;
                            for (int yy = 0; yy <= 4; ++yy) {
                                int voffset = zzoffset + (iy + yy) * this.vol.dx;
                                for (int xx = 0; xx <= 4; ++xx) {
                                    short voxel = volume[voffset + ix + xx];
                                    if (voxel > s2) {
                                        s2 = voxel;
                                    }
                                    if (voxel >= s) continue;
                                    s = voxel;
                                }
                            }
                        }
                        this.mingrid[moffset + x] = s;
                        this.maxgrid[moffset + x] = s2;
                    }
                }
            }
        } else {
            byte[] volume = ((JVolume.LinearByte)this.vol).volume;
            for (int z = 0; z < mdz - 1; ++z) {
                int iz = z << 2;
                int zoffset = z * mpgsize;
                for (int y = 0; y < mdy - 1; ++y) {
                    int iy = y << 2;
                    int moffset = zoffset + y * mdx;
                    for (int x = x0; x < mdx - 1; x += xstep) {
                        int ix = x << 2;
                        int n = Integer.MAX_VALUE;
                        int n2 = Integer.MIN_VALUE;
                        for (int zz = 0; zz <= 4; ++zz) {
                            int zzoffset = VOL_OFFSET + (iz + zz) * pgsize;
                            for (int yy = 0; yy <= 4; ++yy) {
                                int voffset = zzoffset + (iy + yy) * this.vol.dx;
                                for (int xx = 0; xx <= 4; ++xx) {
                                    int voxel = volume[voffset + ix + xx] & 0xFF;
                                    if (voxel > n2) {
                                        n2 = voxel;
                                    }
                                    if (voxel >= n) continue;
                                    n = voxel;
                                }
                            }
                        }
                        this.mingrid[moffset + x] = (short)n;
                        this.maxgrid[moffset + x] = (short)n2;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void build_minmax() {
        long t0 = System.currentTimeMillis();
        Object object = this.minmaxLock;
        synchronized (object) {
            if (this.initMinMax) {
                int PADIT = 3;
                int mdx = this.vol.dx + 3 >> 2;
                int mdy = this.vol.dy + 3 >> 2;
                int mdz = (int)Math.ceil((double)this.vol.dz / 4.0);
                int mlen = mdx * mdy * mdz;
                this.alloc_grids();
                if (this.mingrid == null || this.mingrid.length != mlen) {
                    this.mingrid = new short[mlen];
                    this.maxgrid = new short[mlen];
                }
                Arrays.fill(this.mingrid, (short)-32766);
                Arrays.fill(this.maxgrid, (short)32766);
                ParallelTaskManager ptm = this.getThreadPool();
                int nworkers = ParallelTaskManager.getNumCPU();
                Worker[] worker = new MinMaxGridWorker[nworkers];
                for (int i = 0; i < worker.length; ++i) {
                    worker[i] = new MinMaxGridWorker(ptm, i);
                }
                ptm.setWorkers(worker);
                MinMaxGridWorkData wdata = new MinMaxGridWorkData();
                wdata.mdx = mdx;
                wdata.mdy = mdy;
                wdata.mdz = mdz;
                wdata.mpgsize = mdx * mdy;
                ptm.launch(wdata);
                this.initMinMax = false;
            }
        }
        long time = System.currentTimeMillis() - t0;
        System.err.println("----- new-min/maxgrid = " + time);
    }

    private static int updateBingridOpacity(double thresh1, double thresh2, int z0, int z1, int zdelta, int[] zpos, VrContext ctxt, int ctype, BoundingBox bbox, byte[] bingrid) {
        int visible_voxels = 0;
        int max_x = bbox.max[0];
        int max_y = bbox.max[1];
        int max_z = bbox.max[2];
        int min_x = bbox.min[0];
        int min_y = bbox.min[1];
        int min_z = bbox.min[2];
        double[] opacity_table = ctxt.presetCurves.opacity_table;
        JVolume.LinearVolume vol = ctxt.vol;
        int pgsize = vol.dx * vol.dy;
        int bx = vol.dx;
        int by = vol.dy;
        int bz = vol.dz;
        int blen = bx * by * bz;
        int bingrid_len = blen >> 3;
        int PAD = vol.PAD;
        if (vol instanceof JVolume.LinearShort) {
            short[] volume = ((JVolume.LinearShort)vol).volume;
            for (int zidx = z0; zidx < z1; zidx += zdelta) {
                short v0;
                int x;
                int idx;
                int yoffset;
                int y;
                int z = zpos[zidx];
                if (z == 0) continue;
                int zoffset = PAD + z * pgsize;
                if (ctype != 105) {
                    for (y = 1; y < vol.dy; ++y) {
                        yoffset = y * vol.dx;
                        idx = zoffset + yoffset + 1;
                        for (x = 1; x < vol.dx; ++x) {
                            int n = idx++;
                            v0 = volume[n];
                            if (!((double)v0 >= thresh1) || !((double)v0 <= thresh2)) continue;
                            VrContext.mark_bingrid8(bingrid, x, y, z, bx, by);
                            ++visible_voxels;
                            if (max_x < x) {
                                max_x = x;
                            } else if (min_x > x) {
                                min_x = x;
                            }
                            if (max_y < y) {
                                max_y = y;
                            } else if (min_y > y) {
                                min_y = y;
                            }
                            max_z = z;
                        }
                    }
                } else {
                    for (y = 1; y < vol.dy; ++y) {
                        yoffset = y * vol.dx;
                        idx = zoffset + yoffset + 1;
                        for (x = 1; x < vol.dx; ++x) {
                            int n = idx++;
                            v0 = volume[n];
                            double op_val = opacity_table[8192 + v0];
                            if (!(op_val > 0.0)) continue;
                            VrContext.mark_bingrid8(bingrid, x, y, z, bx, by);
                            ++visible_voxels;
                            if (max_x < x) {
                                max_x = x;
                            } else if (min_x > x) {
                                min_x = x;
                            }
                            if (max_y < y) {
                                max_y = y;
                            } else if (min_y > y) {
                                min_y = y;
                            }
                            max_z = z;
                        }
                    }
                }
                if (visible_voxels > 0 && z < min_z) {
                    min_z = z;
                }
                ctxt.notifyTaskProgress(REFRESH_BINGRID, zidx);
            }
        } else if (vol instanceof JVolume.LinearByte) {
            byte[] volume = ((JVolume.LinearByte)vol).volume;
            for (int zidx = z0; zidx < z1; zidx += zdelta) {
                int v0;
                int x;
                int idx;
                int yoffset;
                int y;
                int z = zpos[zidx];
                if (z == 0) continue;
                int zoffset = PAD + z * pgsize;
                if (ctype != 105) {
                    for (y = 1; y < vol.dy; ++y) {
                        yoffset = y * vol.dx;
                        idx = zoffset + yoffset + 1;
                        for (x = 1; x < vol.dx; ++x) {
                            int n = idx++;
                            v0 = volume[n] & 0xFF;
                            if (!((double)v0 >= thresh1) || !((double)v0 <= thresh2)) continue;
                            VrContext.mark_bingrid8(bingrid, x, y, z, bx, by);
                            ++visible_voxels;
                            if (max_x < x) {
                                max_x = x;
                            } else if (min_x > x) {
                                min_x = x;
                            }
                            if (max_y < y) {
                                max_y = y;
                            } else if (min_y > y) {
                                min_y = y;
                            }
                            max_z = z;
                        }
                    }
                } else {
                    for (y = 1; y < vol.dy; ++y) {
                        yoffset = y * vol.dx;
                        idx = zoffset + yoffset + 1;
                        for (x = 1; x < vol.dx; ++x) {
                            int n = idx++;
                            v0 = volume[n] & 0xFF;
                            double op_val = opacity_table[8192 + v0];
                            if (!(op_val > 0.0)) continue;
                            VrContext.mark_bingrid8(bingrid, x, y, z, bx, by);
                            ++visible_voxels;
                            if (max_x < x) {
                                max_x = x;
                            } else if (min_x > x) {
                                min_x = x;
                            }
                            if (max_y < y) {
                                max_y = y;
                            } else if (min_y > y) {
                                min_y = y;
                            }
                            max_z = z;
                        }
                    }
                }
                if (visible_voxels > 0 && z < min_z) {
                    min_z = z;
                }
                ctxt.notifyTaskProgress(REFRESH_BINGRID, zidx);
            }
        }
        VrContext.updateBingridBBox(bbox, min_x, min_y, min_z, max_x, max_y, max_z);
        return visible_voxels;
    }

    private void rebuild_bingrid() {
        for (int i = 0; i < this.seg_bingrid.length; ++i) {
            int bval = this.seg_bingrid[i] & 0xFF;
            int bbval = this.base_bingrid[i] & 0xFF;
            this.bingrid[i] = (byte)(bval & bbval);
        }
    }

    private void alloc_grids() {
        int bx = this.vol.dx;
        int by = this.vol.dy;
        int bz = this.vol.dz;
        int bingrid_len = ((bx - 1) / 8 + 1) * by * bz;
        if (this.bingrid == null || this.bingrid.length != bingrid_len) {
            this.bingrid = new byte[bingrid_len];
            this.base_bingrid = new byte[bingrid_len];
            this.seg_bingrid = new byte[bingrid_len];
            Arrays.fill(this.seg_bingrid, (byte)-1);
        }
    }

    private int refresh_bingrid(double thresh1, double thresh2, int[] zpos, int zposlen, boolean erase, boolean dilate) {
        int ctype = this.preset != null ? VrPresetCurves.vr_curvetype(this.preset.curvetype) : 301;
        this.alloc_grids();
        if (erase) {
            Arrays.fill(this.bingrid, (byte)0);
            Arrays.fill(this.base_bingrid, (byte)0);
            this.bbox.init();
        }
        this.notifyTaskBegin(REFRESH_BINGRID, zpos.length);
        int nworkers = ParallelTaskManager.getNumCPU();
        BingridWorkData bdata = new BingridWorkData(nworkers);
        Worker[] bworkers = new BingridWorker[nworkers];
        this.ptm = this.getThreadPool();
        bdata.clearVisibleVoxels();
        bdata.setBBox(this.bbox);
        bdata.thresh1 = thresh1;
        bdata.thresh2 = thresh2;
        bdata.zpos = zpos;
        bdata.ctype = ctype;
        bdata.opacity_table = this.presetCurves.opacity_table;
        bdata.bingrid = this.base_bingrid;
        bdata.ctxt = this;
        for (int i = 0; i < nworkers; ++i) {
            bworkers[i] = new BingridWorker(this.ptm, i);
        }
        this.ptm.setWorkers(bworkers);
        this.ptm.launch(bdata);
        bdata.ctxt = null;
        bdata.bingrid = null;
        bdata.opacity_table = null;
        this.bbox.set(bdata.getBoundingBox());
        int visible_voxels = bdata.getVisibleVoxels();
        int max_x = this.bbox.max[0];
        int max_y = this.bbox.max[1];
        int max_z = this.bbox.max[2];
        int min_x = this.bbox.min[0];
        int min_y = this.bbox.min[1];
        int min_z = this.bbox.min[2];
        if (visible_voxels <= 0 && erase) {
            min_x = 0;
            min_y = 0;
            min_z = 0;
            max_x = this.vol.dx - 1;
            max_y = this.vol.dy - 1;
            max_z = this.vol.dz - 1;
        }
        VrContext.updateBingridBBox(this.bbox, min_x, min_y, min_z, max_x, max_y, max_z);
        if (dilate) {
            VrContext.dilate(this.base_bingrid, this.vol.dx, this.vol.dy, this.vol.dz);
        }
        this.rebuild_bingrid();
        this.notifyTaskDone(REFRESH_BINGRID);
        return visible_voxels;
    }

    private static void updateBingridBBox(BoundingBox bbox, int min_x, int min_y, int min_z, int max_x, int max_y, int max_z) {
        bbox.min[0] = bbox.min[0] > min_x ? min_x : bbox.min[0];
        bbox.min[1] = bbox.min[1] > min_y ? min_y : bbox.min[1];
        bbox.min[2] = bbox.min[2] > min_z ? min_z : bbox.min[2];
        bbox.max[0] = bbox.max[0] < max_x ? max_x : bbox.max[0];
        bbox.max[1] = bbox.max[1] < max_y ? max_y : bbox.max[1];
        bbox.max[2] = bbox.max[2] < max_z ? max_z : bbox.max[2];
        bbox.center[0] = bbox.min[0] + bbox.max[0] >> 1;
        bbox.center[1] = bbox.min[1] + bbox.max[1] >> 1;
        bbox.center[2] = bbox.min[2] + bbox.max[2] >> 1;
    }

    private void getBoundingBox(byte[] bingrid, int dx, int dy, int dz, BoundingBox bb) {
        int max_x = 0;
        int max_y = 0;
        int max_z = 0;
        int min_x = dx - 1;
        int min_y = dy - 1;
        int min_z = dz - 1;
        int idx = 0;
        for (int z = 0; z < dz; ++z) {
            for (int y = 0; y < dy; ++y) {
                int x = 0;
                while (x < dx) {
                    int bidx = idx >> 3;
                    byte binval = bingrid[bidx];
                    int bpos = idx & 7;
                    int one = binval & 1 << bpos;
                    if (one != 0) {
                        if (max_x < x) {
                            max_x = x;
                        }
                        if (min_x > x) {
                            min_x = x;
                        }
                        if (max_y < y) {
                            max_y = y;
                        }
                        if (min_y > y) {
                            min_y = y;
                        }
                        if (max_z < z) {
                            max_z = z;
                        }
                        if (min_z > z) {
                            min_z = z;
                        }
                    }
                    ++x;
                    ++idx;
                }
            }
        }
        this.bbox.min[0] = min_x;
        this.bbox.min[1] = min_y;
        this.bbox.min[2] = min_z;
        this.bbox.max[0] = max_x;
        this.bbox.max[1] = max_y;
        this.bbox.max[2] = max_z;
        this.bbox.center[0] = this.bbox.min[0] + this.bbox.max[0] >> 1;
        this.bbox.center[1] = this.bbox.min[1] + this.bbox.max[1] >> 1;
        this.bbox.center[2] = this.bbox.min[2] + this.bbox.max[2] >> 1;
    }

    private static double modality_value(double rawval, double slope, double intercept) {
        return (int)(rawval * slope + intercept);
    }

    private static int raw_value(double modval, double slope, double intercept) {
        return (int)((modval - intercept) / slope);
    }

    public void addTaskMonitor(TaskMonitor tm) {
        this.taskMonitors.add(tm);
    }

    public void removeTaskMonitor(TaskMonitor tm) {
        this.taskMonitors.remove(tm);
    }

    protected void notifyTaskBegin(String taskName, int totalWork) {
        int len = this.taskMonitors.size();
        for (int i = 0; i < len; ++i) {
            TaskMonitor tm = (TaskMonitor)this.taskMonitors.get(i);
            tm.taskBegin(taskName, totalWork);
        }
    }

    protected void notifyTaskDone(String taskName) {
        int len = this.taskMonitors.size();
        for (int i = 0; i < len; ++i) {
            TaskMonitor tm = (TaskMonitor)this.taskMonitors.get(i);
            tm.taskDone(taskName);
        }
    }

    protected void notifyTaskProgress(String taskName, int units) {
        int len = this.taskMonitors.size();
        for (int i = 0; i < len; ++i) {
            TaskMonitor tm = (TaskMonitor)this.taskMonitors.get(i);
            tm.taskProgress(taskName, units);
        }
    }

    public static void dilate(byte[] bits, int dx, int dy, int dz) {
        VrContext.dilate_x(bits, dx, dy, dz);
        VrContext.dilate_y(bits, dx, dy, dz);
        VrContext.dilate_z(bits, dx, dy, dz);
    }

    public static void erode(byte[] bits, int dx, int dy, int dz) {
        int i;
        for (i = 0; i < bits.length; ++i) {
            bits[i] = (byte)(~(bits[i] & 0xFF));
        }
        VrContext.dilate(bits, dx, dy, dz);
        for (i = 0; i < bits.length; ++i) {
            bits[i] = (byte)(~(bits[i] & 0xFF));
        }
    }

    private static void dilate_x(byte[] bits, int dx, int dy, int dz) {
        int idx = 0;
        for (int z = 0; z < dz; ++z) {
            for (int y = 0; y < dy; ++y) {
                byte m;
                int x = 0;
                int a = 0;
                a = 0;
                for (x = 0; x < dx - 8; x += 8) {
                    m = bits[idx];
                    byte c = bits[idx + 1];
                    int val = (m | m << 1 | m >> 1 | a | c) & 0xFF;
                    bits[idx++] = (byte)val;
                    a = (m & 0x80) >> 7;
                }
                m = bits[idx];
                int val = (m | m << 1 | m >> 1 | a) & 0xFF;
                bits[idx++] = (byte)val;
            }
        }
    }

    private static void dilate_y(byte[] bits, int dx, int dy, int dz) {
        int SIZEOF_INT = 4;
        int lsize_int = dx / 8;
        int pglen = dx * dy / 8;
        int idx = 0;
        int z = 0;
        while (z < dz) {
            for (int x = 0; x < dx; x += 32) {
                int val;
                int idx1 = idx + (x >> 3);
                int b0 = bits[idx1] & 0xFF;
                int b1 = bits[idx1 + 1] & 0xFF;
                int b2 = bits[idx1 + 2] & 0xFF;
                int b3 = bits[idx1 + 3] & 0xFF;
                int b = b0 | b1 << 8 | b2 << 16 | b3 << 24;
                int y = 0;
                int a = 0;
                while (y < dy - 2) {
                    b0 = bits[idx1 + lsize_int] & 0xFF;
                    b1 = bits[idx1 + lsize_int + 1] & 0xFF;
                    b2 = bits[idx1 + lsize_int + 2] & 0xFF;
                    b3 = bits[idx1 + lsize_int + 3] & 0xFF;
                    int c = b0 | b1 << 8 | b2 << 16 | b3 << 24;
                    val = a | b | c;
                    bits[idx1] = (byte)(val & 0xFF);
                    bits[idx1 + 1] = (byte)(val >> 8 & 0xFF);
                    bits[idx1 + 2] = (byte)(val >> 16 & 0xFF);
                    bits[idx1 + 3] = (byte)(val >> 24 & 0xFF);
                    ++y;
                    a = b;
                    b = c;
                    idx1 += lsize_int;
                }
                val = a | b;
                bits[idx1] = (byte)(val & 0xFF);
                bits[idx1 + 1] = (byte)(val >> 8 & 0xFF);
                bits[idx1 + 2] = (byte)(val >> 16 & 0xFF);
                bits[idx1 + 3] = (byte)(val >> 24 & 0xFF);
            }
            ++z;
            idx += pglen;
        }
    }

    private static void dilate_z(byte[] bits, int dx, int dy, int dz) {
        int psize = dx * dy / 8;
        int SIZEOF_INT = 4;
        int idx = 0;
        byte[] tmpslice = new byte[psize];
        if (dx / 8 % 4 == 0 && tmpslice != null) {
            int z = 0;
            while (z < dz - 1) {
                int line1 = idx;
                int line2 = line1 + psize;
                int tmp = 0;
                int x = 0;
                while (x < psize) {
                    byte line1Val = bits[line1];
                    byte line2Val = bits[line2];
                    byte tmpVal = tmpslice[tmp];
                    int a = tmpVal | line1Val | line2Val;
                    tmpslice[tmp] = line1Val;
                    bits[line1] = (byte)a;
                    ++x;
                    ++line1;
                    ++line2;
                    ++tmp;
                }
                ++z;
                idx += psize;
            }
        } else {
            int lplane = psize;
            int y = 0;
            while (y < dy) {
                for (int x = 0; x < dx; x += 8) {
                    int idx1 = idx + (x >> 3);
                    int z = 0;
                    byte a = 0;
                    byte b = bits[idx1];
                    while (z < dz - 1) {
                        byte c = bits[idx1 + lplane];
                        int val = a | b | c;
                        bits[idx1] = (byte)val;
                        ++z;
                        a = b;
                        b = c;
                        idx1 += lplane;
                    }
                    bits[idx1] = (byte)(a | b);
                }
                ++y;
                idx += dx / 8;
            }
        }
    }

    private static void bingrid_stats(byte[] bingrid) {
        int nones = 0;
        int nzeros = 0;
        int total = 0;
        for (int i = 0; i < bingrid.length; ++i) {
            byte val = bingrid[i];
            for (int j = 0; j < 8; ++j) {
                if ((val & 1 << j) != 0) {
                    ++nones;
                } else {
                    ++nzeros;
                }
                ++total;
            }
        }
        double pct = (double)nones / (double)total * 100.0;
        System.err.println("BINGRID STATS:  #1s=" + nones + " [" + pct + "%]   #0s=" + nzeros);
    }

    public final byte[] getBaseBingrid() {
        return this.base_bingrid;
    }

    public final byte[] getBingrid() {
        return this.bingrid;
    }

    public final byte[] getSegBingrid() {
        return this.seg_bingrid;
    }

    public Object clone() {
        VrContext vrc = new VrContext(this.vol, this.preset, this.bingrid, this.base_bingrid, this.seg_bingrid, this.bbox);
        return vrc;
    }

    public void reset() {
        this.initMinMax = true;
    }

    public void initMip() {
        if (this.initMinMax) {
            this.build_minmax();
        }
    }

    public short[] getMingrid() {
        this.initMip();
        return this.mingrid;
    }

    public short[] getMaxgrid() {
        this.initMip();
        return this.maxgrid;
    }

    public boolean isDirtyMinMax() {
        return this.initMinMax;
    }

    private static class BingridWorker
    extends Worker {
        public BingridWorker(ParallelTaskManager ptm, int workerId) {
            super(ptm, workerId);
        }

        @Override
        public void work(int workerId, int nWorkers, Object data) {
            BingridWorkData bwd = (BingridWorkData)data;
            int ref_zskip = nWorkers;
            int ref_zstart = workerId;
            bwd.visible_voxels[workerId] = VrContext.updateBingridOpacity(bwd.thresh1, bwd.thresh2, ref_zstart, bwd.zpos.length, ref_zskip, bwd.zpos, bwd.ctxt, bwd.ctype, bwd.bbox[workerId], bwd.bingrid);
        }
    }

    private static class BingridWorkData {
        public int[] visible_voxels = null;
        public BoundingBox[] bbox = null;
        private BoundingBox thebbox = new BoundingBox();
        public double thresh1;
        public double thresh2;
        public int[] zpos;
        public VrContext ctxt;
        public int ctype;
        public double[] opacity_table;
        public byte[] bingrid;

        public BingridWorkData(int nworkers) {
            this.thebbox.init();
            this.visible_voxels = new int[nworkers];
            this.bbox = new BoundingBox[nworkers];
            for (int i = 0; i < nworkers; ++i) {
                this.bbox[i] = new BoundingBox();
                this.bbox[i].init();
            }
        }

        public void clearVisibleVoxels() {
            for (int i = 0; i < this.visible_voxels.length; ++i) {
                this.visible_voxels[i] = 0;
            }
        }

        public void setBBox(BoundingBox bb) {
            for (int i = 0; i < this.bbox.length; ++i) {
                this.bbox[i].set(bb);
            }
        }

        public int getVisibleVoxels() {
            int sum = 0;
            for (int i = 0; i < this.visible_voxels.length; ++i) {
                sum += this.visible_voxels[i];
            }
            return sum;
        }

        public BoundingBox getBoundingBox() {
            int i;
            int s;
            int dim;
            for (dim = 0; dim < 3; ++dim) {
                s = 9999999;
                for (i = 0; i < this.bbox.length; ++i) {
                    if (this.bbox[i].min[dim] >= s) continue;
                    s = this.bbox[i].min[dim];
                }
                this.thebbox.min[dim] = s;
            }
            for (dim = 0; dim < 3; ++dim) {
                s = -9999999;
                for (i = 0; i < this.bbox.length; ++i) {
                    if (this.bbox[i].max[dim] <= s) continue;
                    s = this.bbox[i].max[dim];
                }
                this.thebbox.max[dim] = s;
            }
            this.thebbox.center[0] = this.thebbox.min[0] + this.thebbox.max[0] >> 1;
            this.thebbox.center[1] = this.thebbox.min[1] + this.thebbox.max[1] >> 1;
            this.thebbox.center[2] = this.thebbox.min[2] + this.thebbox.max[2] >> 1;
            return this.thebbox;
        }
    }

    private class MinMaxGridWorker
    extends Worker {
        public MinMaxGridWorker(ParallelTaskManager ptm, int workerId) {
            super(ptm, workerId);
        }

        @Override
        public void work(int workerId, int nWorkers, Object data) {
            MinMaxGridWorkData mworkData = (MinMaxGridWorkData)data;
            VrContext.this.build_minmax_thread(workerId, nWorkers, mworkData.mdx, mworkData.mdy, mworkData.mdz, mworkData.mpgsize);
        }
    }

    private static class MinMaxGridWorkData {
        public int mdx;
        public int mdy;
        public int mdz;
        public int mpgsize;

        private MinMaxGridWorkData() {
        }
    }

    public static class BoundingBox {
        public int[] min = new int[3];
        public int[] max = new int[3];
        public int[] center = new int[3];

        public BoundingBox() {
            this.init();
        }

        public String toString() {
            return " BBOX: min=[" + this.min[0] + "," + this.min[1] + "," + this.min[2] + "] max=[" + this.max[0] + "," + this.max[1] + "," + this.max[2] + "] center=[" + this.center[0] + "," + this.center[1] + "," + this.center[2] + "]";
        }

        public void init() {
            this.min[0] = 99999;
            this.min[1] = 99999;
            this.min[2] = 99999;
            this.max[0] = -99999;
            this.max[1] = -99999;
            this.max[2] = -99999;
        }

        public void set(BoundingBox other) {
            System.arraycopy(other.min, 0, this.min, 0, this.min.length);
            System.arraycopy(other.max, 0, this.max, 0, this.max.length);
            System.arraycopy(other.center, 0, this.center, 0, this.center.length);
        }
    }
}

