/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr.presetsEditor;

import com.ge.med.terra.jami.j3d.vr.Preset;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.ColorMenu;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.Layout;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.UIcontrol;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;

class ColorCTL
implements UIcontrol {
    static final int CTRL_SIZE = 14;
    static final int NUDGE_FACTOR = 2;
    Preset p;
    Layout l;
    public boolean mousePressed = false;
    static DecimalFormat format = new DecimalFormat("#####.##");
    ColorMenu colMenu = new ColorMenu();
    JComponent source;

    public ColorCTL() {
        this.colMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorCTL.this.p.fireActionPerformed(e);
            }
        });
    }

    @Override
    public boolean mousePressed(MouseEvent e) {
        this.source = (JComponent)e.getSource();
        if (this.p.blackwhitemode) {
            return false;
        }
        int temp = this.getMouseOver(e);
        if (temp == -1) {
            int y = e.getY();
            return y > this.l.color_top && y < this.l.color_bottom;
        }
        this.p.setRGBselected(temp);
        this.mousePressed = true;
        e.getComponent().repaint();
        if (e.getClickCount() == 2) {
            this.p.fireActionPerformed(new ActionEvent(this, 0, "show_wheel"));
        }
        return true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.mousePressed = false;
        if (e.isPopupTrigger()) {
            System.out.println("popup trigger");
            this.colMenu.show(e.getComponent(), e.getX(), e.getY());
            this.colMenu.setPosition(e.getPoint());
        }
        e.getComponent().repaint();
        this.p.fireActionPerformed(new ActionEvent(this, 0, "color_mouseReleased"));
    }

    int getMouseOver(MouseEvent e) {
        Component c = e.getComponent();
        int w = c.getWidth();
        int h = c.getHeight();
        this.l.setHeight(h);
        int yp = (int)((double)this.l.color_bottom + 10.5 - 2.0);
        int x = e.getX();
        int y = e.getY();
        for (int i = 0; i < this.p.rgbPos.length; ++i) {
            double pos = this.p.rgbPos[i];
            int xp = this.l.getXpos(w, pos);
            if (Math.abs(xp - x) > 7 || !((double)Math.abs(yp - y) <= 10.5)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean mouseMoved(MouseEvent e) {
        if (this.p.blackwhitemode) {
            return false;
        }
        if (this.getMouseOver(e) != -1) {
            e.getComponent().setCursor(new Cursor(11));
            return true;
        }
        return false;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.p.rgbSelected == -1) {
            return;
        }
        Component c = e.getComponent();
        this.p.rgbPos[this.p.rgbSelected] = this.l.getVfromX(c.getWidth(), e.getX());
        this.p.sortColor();
        if (this.p.opacityMode == 6) {
            this.p.updateOpacityPts();
        }
        this.p.putProperty("paintCache", null);
        c.repaint();
    }

    @Override
    public void setLayout(Layout layout) {
        this.l = layout;
    }

    @Override
    public void paint(Graphics g, int w, int h, Rectangle r) {
        if (this.p.blackwhitemode) {
            return;
        }
        this.l.setHeight(h);
        int y = this.l.getColorY();
        int[] xpts = new int[5];
        int[] ypts = new int[5];
        int[] xspts = new int[4];
        int[] yspts = new int[4];
        int[] xtpts = new int[3];
        int[] ytpts = new int[3];
        for (int i = 0; i < this.p.rgbPos.length; ++i) {
            int rgb = this.p.rgbValue[i];
            double pos = this.p.rgbPos[i];
            int x = this.l.getXpos(w, pos);
            if (this.p.rgbSelected == i) {
                g.setColor(Color.lightGray);
                if (this.mousePressed) {
                    g.draw3DRect(x, this.l.op_bottom + 1, 1, this.l.color_bottom - this.l.op_bottom - 1, true);
                    String s = format.format(pos);
                    FontMetrics f = g.getFontMetrics();
                    Rectangle2D rect = f.getStringBounds(s, g);
                    int off = 0;
                    int rwidth = 5 + (int)rect.getWidth();
                    if (r.x + r.width <= x + 1 + rwidth) {
                        off = -rwidth;
                    }
                    g.setColor(UIManager.getColor("ToolTip.background"));
                    g.fillRect(x + 1 + off, this.l.tick_bottom - f.getHeight() + 1, rwidth, 2 + (int)rect.getHeight());
                    Border ttborder = UIManager.getBorder("ToolTip.border");
                    ttborder.paintBorder(this.source, g, x + 1 + off, this.l.tick_bottom - f.getHeight() + 1, rwidth, 2 + (int)rect.getHeight());
                    g.setColor(Color.black);
                    int colorTextPos = this.l.tick_bottom - 2;
                    g.drawString(s, x + 4 + off, colorTextPos);
                }
            }
            xpts[0] = x - 7;
            ypts[0] = this.l.color_bottom - 2;
            xpts[1] = x - 7;
            ypts[1] = this.l.color_bottom + 14 - 2;
            xpts[2] = x + 7;
            ypts[2] = this.l.color_bottom + 14 - 2;
            xpts[3] = x + 7;
            ypts[3] = this.l.color_bottom - 2;
            xpts[4] = x;
            ypts[4] = this.l.color_bottom - 7 - 2;
            g.setColor(Color.BLACK);
            g.drawPolygon(xpts, ypts, 5);
            g.setColor(Color.WHITE);
            g.fillPolygon(xpts, ypts, 5);
            int margin = this.p.rgbSelected == i ? 2 : 1;
            xtpts[0] = xpts[0] + margin;
            ytpts[0] = ypts[0];
            xtpts[1] = xpts[3] - margin;
            ytpts[1] = ypts[3];
            xtpts[2] = xpts[4];
            ytpts[2] = ypts[4] + margin;
            g.setColor(UIManager.getColor("P3"));
            g.fillPolygon(xtpts, ytpts, 3);
            xspts[0] = xpts[0] + margin;
            yspts[0] = ypts[0] + margin;
            xspts[1] = xpts[1] + margin;
            yspts[1] = ypts[1] - margin;
            xspts[2] = xpts[2] - margin;
            yspts[2] = ypts[2] - margin;
            xspts[3] = xpts[3] - margin;
            yspts[3] = ypts[3] + margin;
            g.setColor(new Color(~rgb));
            g.drawPolygon(xspts, yspts, 4);
            g.setColor(new Color(rgb));
            g.fillPolygon(xspts, yspts, 4);
        }
    }

    @Override
    public void setPresets(Preset p) {
        this.p = p;
    }
}

