/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr.presetsEditor;

import com.ge.med.terra.jami.j3d.vr.Preset;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.Layout;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.UIelement;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.VrHistogram;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.UIManager;

class HistogramUI
implements UIelement {
    private Layout layout;
    private VrHistogram histogram;
    public static int COMPACT_FACTOR = 10;
    public static final float CURVE_WIDTH = 1.0f;
    private static final Stroke CURVE_STROKE = new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{6.0f, 6.0f}, 0.0f);
    private static final Stroke CURVE_STROKE_PLAIN = new BasicStroke(1.0f);
    Rectangle rect = new Rectangle();
    int[] xPoints;
    int[] yPoints;

    HistogramUI() {
    }

    @Override
    public void paint(Graphics g, int w, int h, Rectangle r) {
        this.layout.setHeight(h);
        this.rect.x = this.layout.BORDER.left;
        this.rect.y = this.layout.op_top;
        this.rect.width = this.layout.getXRange(w);
        this.rect.height = this.layout.op_bottom - this.layout.op_top;
        this.drawHistogram(g, this.rect, false, false);
    }

    public void drawHistogram(Graphics g, Rectangle rect, boolean uselog, boolean fillonly) {
        if (this.histogram == null) {
            return;
        }
        if (this.histogram.count == null) {
            return;
        }
        if (this.xPoints == null || this.histogram.count.length + 2 != this.xPoints.length) {
            this.xPoints = new int[this.histogram.count.length + 2];
            this.yPoints = new int[this.histogram.count.length + 2];
        }
        int yrange = rect.height;
        int startx = this.layout.getRawXpos(rect.width, Math.min(Math.max(Layout.MIN, (double)this.histogram.min * this.histogram.slope + this.histogram.intercept), Layout.MAX)) + rect.x;
        int endx = this.layout.getRawXpos(rect.width, Math.min(Math.max(Layout.MIN, (double)this.histogram.max * this.histogram.slope + this.histogram.intercept), Layout.MAX)) + rect.x;
        double xstep = (double)(endx - startx) / (double)this.histogram.count.length;
        double max = this.histogram.count[0];
        for (int i = 1; i < this.histogram.count.length; ++i) {
            if (!(max < (double)this.histogram.count[i])) continue;
            max = this.histogram.count[i];
        }
        if (uselog && max > 0.0) {
            max = Math.log(max);
        }
        double ystep = (double)yrange / max;
        this.xPoints[0] = startx;
        this.yPoints[0] = rect.y + yrange;
        for (int i = 0; i < this.histogram.count.length; ++i) {
            this.xPoints[i + 1] = (int)(xstep * (double)i + (double)startx);
            this.yPoints[i + 1] = (int)((double)(rect.y + yrange) - (uselog ? (this.histogram.count[i] > 0 ? ystep * Math.log(this.histogram.count[i]) : 0.0) : ystep * (double)this.histogram.count[i]));
        }
        this.xPoints[this.xPoints.length - 1] = endx;
        this.yPoints[this.yPoints.length - 1] = rect.y + yrange;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (!fillonly) {
            g2d.setColor(Color.BLACK);
            g2d.setStroke(CURVE_STROKE_PLAIN);
            g.drawPolyline(this.xPoints, this.yPoints, this.yPoints.length);
            g.setColor(UIManager.getColor("ToolTip.background"));
            g2d.setStroke(CURVE_STROKE);
            g.drawPolyline(this.xPoints, this.yPoints, this.yPoints.length);
        } else {
            g2d.setColor(new Color(Color.DARK_GRAY.getRGB() & 0xFFFFFF | Integer.MIN_VALUE, true));
            g2d.drawPolyline(this.xPoints, this.yPoints, this.yPoints.length);
            g2d.fillPolygon(this.xPoints, this.yPoints, this.yPoints.length);
        }
    }

    public void setHistogram(VrHistogram h) {
        this.histogram = h;
    }

    @Override
    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    @Override
    public void setPresets(Preset p) {
    }
}

