/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.vr.presetsEditor;

import com.ge.med.terra.jami.j3d.vr.Preset;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.Layout;
import com.ge.med.terra.jami.j3d.vr.presetsEditor.UIelement;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

class TickMarksUI
implements UIelement {
    public static String UNIT = "HU";
    Layout l;
    Preset p;
    double actualTickSpacing;
    final int MIN_TICK_PIXELS = 50;
    final int TICK_HEIGHT = 20;
    Component c;
    static final double[] spacings = new double[]{0.1, 0.2, 0.25, 0.5, 1.0, 2.0, 5.0, 10.0, 20.0, 25.0, 50.0, 100.0, 200.0, 250.0, 500.0, 1000.0, 2000.0, 2500.0, 5000.0, 10000.0, 20000.0, 25000.0, 50000.0, 100000.0, 200000.0, 250000.0, 500000.0};

    @Override
    public void paint(Graphics g, int w, int h, Rectangle r) {
        this.l.setHeight(h);
        int gridWidth = w - this.l.BORDER.left - this.l.BORDER.right;
        double iwidth = Layout.MAX - Layout.MIN;
        int maxTickSpacing = 100;
        int minTickSpacing = 80;
        double tsMax = iwidth * (double)maxTickSpacing / (double)gridWidth;
        double tsMin = iwidth * (double)minTickSpacing / (double)gridWidth;
        double ts = 100000.0;
        for (int i = 0; i < spacings.length; ++i) {
            if (!(spacings[i] > tsMin)) continue;
            ts = spacings[i];
            break;
        }
        int ystart = this.l.tick_top;
        FontMetrics fm = g.getFontMetrics();
        g.setColor(Color.BLACK);
        int strh = fm.getHeight();
        int ylen = (28 - strh) / 2 + 3;
        int strY = ystart + 28 - strh + fm.getAscent();
        double cw = (double)fm.stringWidth("-123456789.0") / 24.0;
        double start = Layout.MIN - Layout.MIN % ts;
        g.drawRect(this.l.BORDER.left, ystart, w, 1);
        double i = start;
        while (true) {
            if (!(i <= Layout.MAX)) break;
            int x = (int)((double)gridWidth * (i - Layout.MIN) / iwidth) + this.l.BORDER.left;
            String s = Float.toString((float)i);
            g.fillRect(x, ystart + 1, 1, ylen);
            g.drawString(s, x - (int)((double)s.length() * cw), strY + 1);
            i += ts;
        }
        g.drawRect(this.l.BORDER.left, ystart + 28 + 2, w, 0);
        Rectangle2D rect = fm.getStringBounds(UNIT, g);
        g.drawString(UNIT, (int)((double)(r.x + r.width) - rect.getWidth()), this.l.tick_bottom - 2);
    }

    @Override
    public void setLayout(Layout layout) {
        this.l = layout;
    }

    @Override
    public void setPresets(Preset p) {
        this.p = p;
    }
}

