/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.platform.dm;

import com.ge.med.idc.XjDicomObject;
import com.ge.med.idc.XjTagValue;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.util.dicom.DicomComposite;
import com.ge.med.terra.tap.util.dicom.DicomData;
import com.ge.med.terra.tap.util.dicom.KeyObjectSelectionComposite;
import java.io.InputStream;
import java.sql.Date;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class KeyImageNote {
    public static final int MAX_DISPLAY_LENGTH = 40;
    public static final String KIN_MODALITY = "KO";
    public static final String LINE_SEP = System.getProperty("line.separator");
    private KeyObjectSelectionComposite composite = null;
    private String titleCode;
    private String title;
    private String observation;
    private String subtitleCode = null;
    private String subtitle = null;
    private String observer;
    private Set<String> linkedImageUIDs = new HashSet<String>();
    public static final String OF_INTEREST_CODE = "113000";
    public static final String REJECTED_FOR_QUALITY_REASONS_CODE = "113001";
    public static final String FOR_REFERRING_PROVIDER_CODE = "113002";
    public static final String FOR_SURGERY_CODE = "113003";
    public static final String FOR_TEACHING_CODE = "113004";
    public static final String FOR_CONFERENCE_CODE = "113005";
    public static final String FOR_THERAPY_CODE = "113006";
    public static final String FOR_PATIENT_CODE = "113007";
    public static final String FOR_PEER_REVIEW_CODE = "113008";
    public static final String FOR_RESEARCH_CODE = "113009";
    public static final String QUALITY_ISSUE_CODE = "113010";
    public static final String BEST_IN_SET_CODE = "113013";
    public static final String FOR_PRINTING_CODE = "113018";
    public static final String FOR_REPORT_ATTACHMENT_CODE = "113020";
    public static final String MANIFEST_CODE = "113030";
    public static final String SIGNED_MANIFEST_CODE = "113031";
    public static final String COMPLETE_STUDY_CONTENT_CODE = "113032";
    public static final String SIGNED_COMPLETE_STUDY_CONTENT_CODE = "113033";
    public static final String COMPLETE_ACQUISITION_CONTENT_CODE = "113034";
    public static final String SIGNED_COMPLETE_ACQUISITION_CONTENT_CODE = "113035";
    public static final String GROUP_OF_FRAMES_FOR_DISPLAY_CODE = "113036";
    public static final String REJECTED_FOR_PATIENT_SAFETY_REASONS_CODE = "113037";
    private static HashMap<String, String> titleMap = new HashMap(22);
    public static final String IMAGE_ARTIFACTS_CODE = "111207";
    public static final String GRID_ARTIFACTS_CODE = "111208";
    public static final String POSITIONING_CODE = "111209";
    public static final String MOTION_BLUR_CODE = "111210";
    public static final String UNDER_EXPOSED_CODE = "111211";
    public static final String OVER_EXPOSED_CODE = "111212";
    public static final String NO_IMAGE_CODE = "111213";
    public static final String DETECTOR_ARTIFACTS_CODE = "111214";
    public static final String ARTIFACTS_OTHER_THAN_GRID_OR_DETECTOR_ARTIFACT_CODE = "111215";
    public static final String MECHANICAL_FAILURE_CODE = "111216";
    public static final String ELECTRICAL_FAILURE_CODE = "111217";
    public static final String SOFTWARE_FAILURE_CODE = "111218";
    public static final String INAPPROPRIATE_IMAGE_PROCESSING_CODE = "111219";
    public static final String OTHER_FAILURE_CODE = "111220";
    public static final String UNKNOWN_FAILURE_CODE = "111221";
    public static final String DOUBLE_EXPOSURE_CODE = "111226";
    private static HashMap<String, String> subtitleQualityReasonsMap;
    public static final String STUDY_CODE = "113014";
    public static final String SERIES_CODE = "113015";
    public static final String PERFORMED_PROCEDURE_STEP_CODE = "113016";
    public static final String STAGE_VIEW_CODE = "113017";
    private static HashMap<String, String> subtitleBestInSetMap;
    public static final String CODING_SCHEME_DESIGNATOR = "DCM";
    public static final String RELATIONSHIP_TYPE_OBSERVATION = "CONTAINS";
    public static final String RELATIONSHIP_TYPE_SUBTITLE = "HAS CONCEPT MOD";
    public static final String CONTINUITY_OF_CONTENT = "SEPARATE";
    public static final String MAPPING_RESOURCE = "DCMR";
    public static final String TEMPLATE_IDENTIFIER = "2010";
    public static final String VALUE_TYPE_CODE = "CODE";
    public static final String VALUE_TYPE_TEXT = "TEXT";
    public static final String VALUE_TYPE_IMAGE = "IMAGE";
    public static final String VALUE_TYPE_CONTAINER = "CONTAINER";
    public static final String CODE_VALUE_SUBTITLE = "113011";
    public static final String CODE_MEANING_SUBTITLE = "Document Title Modifier";
    public static final String CODE_VALUE_OBSERVATION = "121106";
    public static final String CODE_MEANING_OBSERVATION = "Comment";
    public static final String COMPLETION_FLAG_COMPLETE = "COMPLETE";
    public static final String COMPLETION_FLAG_PARTIAL = "PARTIAL";
    public static final String VERIFICATION_FLAG_VERIFIED = "VERIFIED";
    public static final String VERIFICATION_FLAG_UNVERIFIED = "UNVERIFIED";
    public static final String PERSON = "PSN";
    public static final String DEVICE = "DEV";

    public static Map getTitleMap() {
        return titleMap;
    }

    public static Map getSubtitleQualityReasonsMap() {
        return subtitleQualityReasonsMap;
    }

    public static Map getsubtitleBestInSetMap() {
        return subtitleBestInSetMap;
    }

    public String getTitleCode() {
        return this.titleCode;
    }

    public String getTitle() {
        return this.title;
    }

    public String getObservation() {
        return this.observation;
    }

    public String getSubtitleCode() {
        return this.subtitleCode;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public String getObserver() {
        return this.observer;
    }

    public String[] getLinkedImageUIDs() {
        return this.linkedImageUIDs.toArray(new String[0]);
    }

    public KeyImageNote(String titleCode, String observation, XpDicomObject[] linkedObjects, String subtitleCode, String observer, DMObject refObject) {
        XjDicomObject[] kosLinkedObjects = new XjDicomObject[linkedObjects.length];
        for (int i = 0; i < linkedObjects.length; ++i) {
            kosLinkedObjects[i] = new KOSDicomObject(linkedObjects[i]);
        }
        this.init(titleCode, observation, kosLinkedObjects, subtitleCode, observer, refObject);
    }

    public KeyImageNote(String titleCode, String observation, XjDicomObject[] linkedObjects, String subtitleCode, String observer, DMObject refObject) {
        this.init(titleCode, observation, linkedObjects, subtitleCode, observer, refObject);
    }

    private KeyImageNote(KeyObjectSelectionComposite composite) {
        int itemIndex;
        this.composite = composite;
        this.titleCode = (String)composite.getValue("(0x0040, 0xA043)[0](0x0008, 0x0100)");
        this.title = titleMap.get(this.titleCode);
        if (REJECTED_FOR_QUALITY_REASONS_CODE.equals(this.titleCode) || QUALITY_ISSUE_CODE.equals(this.titleCode)) {
            for (itemIndex = 0; itemIndex <= ((Object[])composite.getValues(64, 42800)).length && this.subtitleCode == null; ++itemIndex) {
                if (!RELATIONSHIP_TYPE_SUBTITLE.equals(composite.getValue("(0x0040, 0xA730)[" + itemIndex + "](0x0040, 0xA010)"))) continue;
                this.subtitleCode = (String)composite.getValue("(0x0040, 0xA730)[" + itemIndex + "](0x0040, 0xA168)[0](0x0008, 0x0100");
                this.subtitle = subtitleQualityReasonsMap.get(this.subtitleCode);
            }
        } else if (BEST_IN_SET_CODE.equals(this.titleCode)) {
            for (itemIndex = 0; itemIndex <= ((Object[])composite.getValues(64, 42800)).length && this.subtitleCode == null; ++itemIndex) {
                if (!RELATIONSHIP_TYPE_SUBTITLE.equals(composite.getValue("(0x0040, 0xA730)[" + itemIndex + "](0x0040, 0xA010)"))) continue;
                this.subtitleCode = (String)composite.getValue("(0x0040, 0xA730)[" + itemIndex + "](0x0040, 0xA168)[0](0x0008, 0x0100");
                this.subtitle = subtitleBestInSetMap.get(this.subtitleCode);
            }
        }
        for (itemIndex = 0; itemIndex <= ((Object[])composite.getValues(64, 42800)).length && this.observation == null; ++itemIndex) {
            if (!VALUE_TYPE_TEXT.equals(composite.getValue("(0x0040, 0xA730)[" + itemIndex + "](0x0040, 0xA040)"))) continue;
            this.observation = (String)composite.getValue("(0x0040, 0xA730)[" + itemIndex + "](0x0040, 0xA160)");
        }
        int imageIndex = 0;
        Object imageUID = composite.getValue("(0x0040, 0xA375)[0](0x0008, 0x1115)[" + imageIndex + "](0x0008, 0x1199)[0](0x0008, 0x1155)");
        while (imageUID != null) {
            this.linkedImageUIDs.add((String)imageUID);
            imageUID = composite.getValue("(0x0040, 0xA375)[0](0x0008, 0x1115)[" + ++imageIndex + "](0x0008, 0x1199)[0](0x0008, 0x1155)");
        }
    }

    private void init(String titleCode, String observation, XjDicomObject[] dicomObj, String subtitleCode, String observer, DMObject refObject) {
        this.titleCode = titleCode;
        this.title = titleMap.get(titleCode);
        this.observation = observation;
        this.subtitleCode = subtitleCode;
        this.subtitle = subtitleQualityReasonsMap.get(subtitleCode);
        if (this.subtitle == null) {
            this.subtitle = subtitleBestInSetMap.get(subtitleCode);
        }
        this.observer = observer;
        this.composite = new KeyObjectSelectionComposite();
        if (null == refObject) {
            this.composite.fill(dicomObj[0]);
        } else {
            this.composite.fill(refObject);
        }
        this.fillKOS(dicomObj, refObject);
    }

    private void fillKOS(XjDicomObject[] imgs, DMObject refObject) {
        if (refObject != null) {
            this.composite.fill(refObject);
        } else {
            this.setValue(64, 42129, COMPLETION_FLAG_COMPLETE);
            this.setValue(64, 42131, VERIFICATION_FLAG_UNVERIFIED);
            this.setValue(64, 41024, VALUE_TYPE_CONTAINER);
            DicomData titleTag = new DicomData();
            titleTag.setValue(8, 256, this.titleCode);
            titleTag.setValue(8, 258, CODING_SCHEME_DESIGNATOR);
            titleTag.setValue(8, 260, this.title);
            this.setValue(64, 41027, 0, titleTag);
            this.setValue(64, 41040, CONTINUITY_OF_CONTENT);
            DicomData dcmrTag = new DicomData();
            dcmrTag.setValue(8, 261, MAPPING_RESOURCE);
            dcmrTag.setValue(64, 56064, TEMPLATE_IDENTIFIER);
            this.setValue(64, 42244, 0, dcmrTag);
            int itemIndex = 0;
            if (this.subtitleCode != null) {
                DicomData subtitleTag = new DicomData();
                subtitleTag.setValue(64, 40976, RELATIONSHIP_TYPE_SUBTITLE);
                subtitleTag.setValue(64, 41024, VALUE_TYPE_CODE);
                DicomData subtitleCodeTag = new DicomData();
                subtitleCodeTag.setValue(8, 256, CODE_VALUE_SUBTITLE);
                subtitleCodeTag.setValue(8, 258, CODING_SCHEME_DESIGNATOR);
                subtitleCodeTag.setValue(8, 260, CODE_MEANING_SUBTITLE);
                subtitleTag.setValue(64, 41027, 0, subtitleCodeTag);
                DicomData subtitleValueTag = new DicomData();
                subtitleValueTag.setValue(8, 256, this.subtitleCode);
                subtitleValueTag.setValue(8, 258, CODING_SCHEME_DESIGNATOR);
                subtitleValueTag.setValue(8, 260, this.subtitle);
                subtitleTag.setValue(64, 41320, 0, subtitleValueTag);
                this.setValue(64, 42800, itemIndex, subtitleTag);
                ++itemIndex;
            }
            if (this.observation != null) {
                DicomData observationTag = new DicomData();
                observationTag.setValue(64, 40976, RELATIONSHIP_TYPE_OBSERVATION);
                observationTag.setValue(64, 41024, VALUE_TYPE_TEXT);
                DicomData obsCodeTag = new DicomData();
                obsCodeTag.setValue(8, 256, CODE_VALUE_OBSERVATION);
                obsCodeTag.setValue(8, 258, CODING_SCHEME_DESIGNATOR);
                obsCodeTag.setValue(8, 260, CODE_MEANING_OBSERVATION);
                observationTag.setValue(64, 41027, 0, obsCodeTag);
                DicomData textTag = new DicomData();
                textTag.setValue(64, 41312, this.observation);
                observationTag.setValue(64, 41312, this.observation);
                this.setValue(64, 42800, itemIndex, observationTag);
                ++itemIndex;
            }
            for (XjDicomObject img : imgs) {
                DicomData refImageSeq = new DicomData();
                refImageSeq.setValue(64, 40976, RELATIONSHIP_TYPE_OBSERVATION);
                refImageSeq.setValue(64, 41024, VALUE_TYPE_IMAGE);
                XpDicomElement[] imageSOPElements = new XpDicomElement[]{new XpDicomElement(8, 22), new XpDicomElement(8, 24)};
                if (imgs instanceof XpDicomObject[]) {
                    ((XpDicomObject)((Object)img)).getValues(imageSOPElements);
                } else {
                    for (int elementIndex = 0; elementIndex < imageSOPElements.length; ++elementIndex) {
                        imageSOPElements[elementIndex].value = ((XjDicomObject)img).getValue(imageSOPElements[elementIndex].group, imageSOPElements[elementIndex].element);
                    }
                }
                this.linkedImageUIDs.add("" + imageSOPElements[1].value);
                DicomData referencedSOPSeq = new DicomData();
                referencedSOPSeq.setValue(8, 4432, imageSOPElements[0].value);
                referencedSOPSeq.setValue(8, 4437, imageSOPElements[1].value);
                refImageSeq.setValue(8, 4505, 0, referencedSOPSeq);
                this.setValue(64, 42800, itemIndex, refImageSeq);
                ++itemIndex;
            }
            this.setValue(8, 4369, 0, null);
            DicomData evidenceSeq = new DicomData();
            evidenceSeq.setValue(32, 13, this.composite.getValue(32, 13));
            for (int imageIndex = 0; imageIndex < imgs.length; ++imageIndex) {
                XpDicomElement[] imageSOPElements = new XpDicomElement[]{new XpDicomElement(32, 14), new XpDicomElement(8, 22), new XpDicomElement(8, 24)};
                if (imgs instanceof XpDicomObject[]) {
                    ((XpDicomObject)((Object)imgs[imageIndex])).getValues(imageSOPElements);
                } else {
                    for (int elementIndex = 0; elementIndex < imageSOPElements.length; ++elementIndex) {
                        imageSOPElements[elementIndex].value = imgs[imageIndex].getValue(imageSOPElements[elementIndex].group, imageSOPElements[elementIndex].element);
                    }
                }
                DicomData refSOPSeq = new DicomData();
                refSOPSeq.setValue(8, 4432, imageSOPElements[1].value);
                refSOPSeq.setValue(8, 4437, imageSOPElements[2].value);
                DicomData seriesSeq = new DicomData();
                seriesSeq.setValue(32, 14, imageSOPElements[0].value);
                seriesSeq.setValue(8, 4505, refSOPSeq);
                evidenceSeq.setValue(8, 4373, imageIndex, seriesSeq);
            }
            this.setValue(64, 41845, 0, evidenceSeq);
            if (this.observer != null) {
                DicomData observerSeq = new DicomData();
                observerSeq.setValue(64, 40976, "HAS OBS CONTEXT");
                observerSeq.setValue(64, 41024, "PNAME");
                DicomData observerCodeSeq = new DicomData();
                observerCodeSeq.setValue(8, 256, "121008");
                observerCodeSeq.setValue(8, 258, CODING_SCHEME_DESIGNATOR);
                observerCodeSeq.setValue(8, 260, "Person Observer Name");
                observerSeq.setValue(64, 41027, 0, observerCodeSeq);
                observerSeq.setValue(64, 41251, this.observer);
                this.setValue(64, 42800, itemIndex, observerSeq);
                ++itemIndex;
            }
        }
    }

    public void setAuthorObserver(String name, String observerType, String deviceUID, String manufacturer, String manufacturerModel) {
        DicomData authorObsSeq = new DicomData();
        authorObsSeq.setValue(64, 41092, observerType);
        if (PERSON.equals(observerType)) {
            authorObsSeq.setValue(64, 41251, name);
            authorObsSeq.setValue(64, 4353, 0, null);
        } else if (DEVICE.equals(observerType)) {
            authorObsSeq.setValue(8, 4112, name);
            authorObsSeq.setValue(24, 4098, deviceUID);
            authorObsSeq.setValue(8, 112, manufacturer);
            authorObsSeq.setValue(8, 4240, manufacturerModel);
        }
        this.setValue(64, 41080, 0, authorObsSeq);
    }

    public void setVerifyingObserver(String name, String organization, Date date) {
        this.setValue(64, 42131, VERIFICATION_FLAG_VERIFIED);
        DicomData verObsSeq = new DicomData();
        verObsSeq.setValue(64, 41077, name);
        verObsSeq.setValue(64, 41096, null);
        verObsSeq.setValue(64, 40999, organization);
        if (null != date) {
            verObsSeq.setValue(64, 40999, date);
        } else {
            verObsSeq.setValue(64, 40999, Calendar.getInstance().getTime());
        }
        this.setValue(64, 41075, verObsSeq);
    }

    private void setValue(int group, int element, Object value) {
        this.composite.setValue(group, element, value);
    }

    private void setValue(int group, int element, int i, DicomData value) {
        this.composite.setValue(group, element, i, value);
    }

    public InputStream getDicomKIN() {
        InputStream is = this.composite.getInputStream(true, DicomComposite.TS_ELE);
        return is;
    }

    public InputStream getDicomKIN(XpDicomElement[] overrides) {
        for (int i = 0; i < overrides.length; ++i) {
            Object obj = this.composite.getValue(overrides[i].group, overrides[i].element);
            if (obj == null) continue;
            this.setValue(overrides[i].group, overrides[i].element, overrides[i].value);
        }
        return this.getDicomKIN();
    }

    public String toString() {
        String description = this.title + " [" + this.observation;
        if (description.length() <= 40) {
            return description + "]";
        }
        return description.substring(0, 39) + "...]";
    }

    public String toStringBulk() {
        StringBuffer description = new StringBuffer();
        description.append("=== Contents of Key Image Note ===");
        description.append(LINE_SEP);
        description.append("Title: ");
        description.append(this.getTitle());
        description.append(LINE_SEP);
        description.append("Subtitle: ");
        description.append(this.getSubtitle());
        description.append(LINE_SEP);
        description.append("Observation: ");
        description.append(this.getObservation());
        description.append(LINE_SEP);
        description.append("Observer: ");
        description.append(this.getObserver());
        description.append(LINE_SEP);
        String[] imageUIDs = this.getLinkedImageUIDs();
        description.append("number of linked images: ");
        description.append(imageUIDs.length);
        description.append(LINE_SEP);
        for (int i = 0; i < imageUIDs.length; ++i) {
            description.append("Image ");
            description.append(i);
            description.append(": ");
            description.append(imageUIDs[i]);
            description.append(LINE_SEP);
        }
        return description.toString();
    }

    public KeyImageNote clone() {
        KeyImageNote kin = new KeyImageNote(this.composite);
        return kin;
    }

    public static KeyImageNote getKeyImageNote(InputStream is) {
        KeyObjectSelectionComposite composite = new KeyObjectSelectionComposite();
        composite.read(is);
        KeyImageNote kin = null;
        if (KIN_MODALITY.equals(composite.getValue(8, 96))) {
            kin = new KeyImageNote(composite);
        }
        return kin;
    }

    static {
        titleMap.put(OF_INTEREST_CODE, "Of Interest");
        titleMap.put(REJECTED_FOR_QUALITY_REASONS_CODE, "Rejected For Quality Reasons");
        titleMap.put(FOR_REFERRING_PROVIDER_CODE, "For Referring Provider");
        titleMap.put(FOR_SURGERY_CODE, "For Surgery");
        titleMap.put(FOR_TEACHING_CODE, "For Teaching");
        titleMap.put(FOR_CONFERENCE_CODE, "For Conference");
        titleMap.put(FOR_THERAPY_CODE, "For Therapy");
        titleMap.put(FOR_PATIENT_CODE, "For Patient");
        titleMap.put(FOR_PEER_REVIEW_CODE, "For Peer Review");
        titleMap.put(FOR_RESEARCH_CODE, "For Research");
        titleMap.put(QUALITY_ISSUE_CODE, "Quality Issue");
        titleMap.put(BEST_IN_SET_CODE, "Best In Set");
        titleMap.put(FOR_PRINTING_CODE, "For Printing");
        titleMap.put(FOR_REPORT_ATTACHMENT_CODE, "For Report Attachment");
        titleMap.put(MANIFEST_CODE, "Manifest");
        titleMap.put(SIGNED_MANIFEST_CODE, "Signed Manifest");
        titleMap.put(COMPLETE_STUDY_CONTENT_CODE, "Complete Study Content");
        titleMap.put(SIGNED_COMPLETE_STUDY_CONTENT_CODE, "Signed Complete Study Content");
        titleMap.put(COMPLETE_ACQUISITION_CONTENT_CODE, "Complete Acquisition Content");
        titleMap.put(SIGNED_COMPLETE_ACQUISITION_CONTENT_CODE, "Signed Complete Acquisition Content");
        titleMap.put(GROUP_OF_FRAMES_FOR_DISPLAY_CODE, "Group of Frames For Display");
        titleMap.put(REJECTED_FOR_PATIENT_SAFETY_REASONS_CODE, "Rejected For Patient Safety Reasons");
        subtitleQualityReasonsMap = new HashMap(16);
        subtitleQualityReasonsMap.put(IMAGE_ARTIFACTS_CODE, "Image artifact(s)");
        subtitleQualityReasonsMap.put(GRID_ARTIFACTS_CODE, "Grid artifact(s)");
        subtitleQualityReasonsMap.put(POSITIONING_CODE, "Positioning");
        subtitleQualityReasonsMap.put(MOTION_BLUR_CODE, "Motion blur");
        subtitleQualityReasonsMap.put(UNDER_EXPOSED_CODE, "Under exposed");
        subtitleQualityReasonsMap.put(OVER_EXPOSED_CODE, "Over exposed");
        subtitleQualityReasonsMap.put(NO_IMAGE_CODE, "No image");
        subtitleQualityReasonsMap.put(DETECTOR_ARTIFACTS_CODE, "Detector artifact(s)");
        subtitleQualityReasonsMap.put(ARTIFACTS_OTHER_THAN_GRID_OR_DETECTOR_ARTIFACT_CODE, "Artifact(s) other than grid or detector artifact");
        subtitleQualityReasonsMap.put(MECHANICAL_FAILURE_CODE, "Mechanical failure");
        subtitleQualityReasonsMap.put(ELECTRICAL_FAILURE_CODE, "Electrical failure");
        subtitleQualityReasonsMap.put(SOFTWARE_FAILURE_CODE, "Software failure");
        subtitleQualityReasonsMap.put(INAPPROPRIATE_IMAGE_PROCESSING_CODE, "Inappropriate image processing");
        subtitleQualityReasonsMap.put(OTHER_FAILURE_CODE, "Other failure");
        subtitleQualityReasonsMap.put(UNKNOWN_FAILURE_CODE, "Unknown failure");
        subtitleQualityReasonsMap.put(DOUBLE_EXPOSURE_CODE, "Double exposure");
        subtitleBestInSetMap = new HashMap(4);
        subtitleBestInSetMap.put(STUDY_CODE, "Study");
        subtitleBestInSetMap.put(SERIES_CODE, "Series");
        subtitleBestInSetMap.put(PERFORMED_PROCEDURE_STEP_CODE, "Performed Procedure Step");
        subtitleBestInSetMap.put(STAGE_VIEW_CODE, "Stage-View");
    }

    private static class KOSDicomObject
    implements XjDicomObject {
        private XpDicomObject ref;

        public KOSDicomObject(XpDicomObject src) {
            this.ref = src;
        }

        @Override
        public Object getValue(int group, int element) {
            XpDicomElement value = new XpDicomElement(group, element);
            this.ref.getValue(value);
            return value.value;
        }

        @Override
        public int getValues(XjTagValue[] tvs) {
            int counter = 0;
            for (int i = 0; i < tvs.length; ++i) {
                tvs[i].value = this.getValue(tvs[i].group, tvs[i].element);
                if (null == tvs[i].value) continue;
                ++counter;
            }
            return counter;
        }
    }
}

