/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.platform.dm;

import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpMedicalImageListListener;
import com.ge.med.terra.jami.XpMedicalImageProvider;
import com.ge.med.terra.jami.annotation.XpAnnotationManager;
import com.ge.med.terra.jami.image.XpBufferedImage;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class XpDMSessionProvider
implements XpMedicalImageProvider {
    public static final int LOAD_FULL = 0;
    public static final int LOAD_LIGHT = 1;
    private XpMedicalImage[] mdi = null;
    private Set _listeners = new HashSet();
    private DMSession session = null;
    private DMObject[][] series = null;
    private DMTag[] dmTags = null;
    private DMImage[] dmimgs = null;
    private int examNo = 0;
    private int seriesNo = 0;
    private int nExams = 0;
    private int[] nSeries = null;
    private String[][] modality = null;
    private String[][] imageType = null;
    private String[][] ref_uid = null;
    private boolean reload = true;
    private int loadMode = 1;

    public XpDMSessionProvider(String path) {
        this(new String[]{"file", path});
    }

    public XpDMSessionProvider(String[] dmsessionStrs) {
        File f;
        String[] files = dmsessionStrs;
        if (files[0].equals("file") && !(f = new File(files[1])).isDirectory()) {
            int len = files.length;
            String[] strs = new String[len + 1];
            strs[0] = files[0];
            strs[1] = null;
            for (int i = 2; i < len + 1; ++i) {
                strs[i] = files[i - 1];
            }
            files = strs;
        }
        this.buildSession(files);
    }

    private void buildSession(String[] dmsessionStrs) {
        this.session = new DMSession(dmsessionStrs);
        this.parseStudies();
    }

    public final void setExamSeries(int ex, int se) {
        if (ex >= 0 && ex < this.getNumExams()) {
            int nseries = this.getNumSeries(ex);
            if (se >= 0 && se < nseries) {
                this.examNo = ex;
                this.seriesNo = se;
                this.reload = true;
            }
        }
    }

    public final DMObject getCurrentDMSeries() {
        return this.series[this.examNo][this.seriesNo];
    }

    public final void nextExam() {
        int ex = (this.examNo + 1) % this.nExams;
        this.setExamSeries(ex, 0);
    }

    public final void previousExam() {
        int ex = this.examNo - 1;
        if (ex < 0) {
            ex = this.nExams - 1;
        }
        this.setExamSeries(ex, 0);
    }

    public final void nextSeries() {
        int nseries = this.nSeries[this.examNo];
        int se = (this.seriesNo + 1) % nseries;
        this.setExamSeries(this.examNo, se);
    }

    public final void previousSeries() {
        int nseries = this.nSeries[this.examNo];
        int se = this.seriesNo - 1;
        if (se < 0) {
            se = nseries - 1;
        }
        this.setExamSeries(this.examNo, se);
    }

    public final void printESInfo() {
        int nex = this.getNumExams();
        for (int i = 0; i < nex; ++i) {
            int nse = this.getNumSeries(i);
            for (int j = 0; j < nse; ++j) {
                String modality = this.getModality(i, j);
                String ref_uid = this.getRefUid(i, j);
                XpLog.logger().config("(" + i + "," + j + ") : modality=" + modality + "  ref_uid=" + ref_uid);
            }
        }
    }

    private void makeTags(String modalityHint, String imgType) {
        String[] tags = XpAnnotationManager.getNeededTags(modalityHint, imgType);
        if (tags != null) {
            int len = tags.length;
            XpLog.logger().config("Number of Tags: " + len);
            XpLog.logger().config("# Tags: " + len);
            this.dmTags = new DMTag[len];
            for (int i = 0; i < len; ++i) {
                StringTokenizer st = new StringTokenizer(tags[i], ",");
                String groupStr = st.nextToken();
                String elemStr = st.nextToken();
                int group = Integer.parseInt(groupStr);
                int element = Integer.parseInt(elemStr);
                this.dmTags[i] = new DMTag(group, element);
            }
        }
    }

    private boolean parseStudies() {
        DMObject[] exam = null;
        exam = this.session.getRelated("Study");
        XpLog.logger().config("Found " + exam.length + " stud" + (exam.length == 1 ? "y" : "ies"));
        if (exam.length == 0) {
            return false;
        }
        this.nExams = exam.length;
        this.series = new DMObject[this.nExams][];
        this.modality = new String[this.nExams][];
        this.imageType = new String[this.nExams][];
        this.ref_uid = new String[this.nExams][];
        this.nSeries = new int[this.nExams];
        for (int i = 0; i < exam.length; ++i) {
            int ns;
            this.series[i] = exam[i].getRelated("series");
            this.nSeries[i] = ns = this.series[i].length;
            this.modality[i] = new String[ns];
            this.imageType[i] = new String[ns];
            this.ref_uid[i] = new String[ns];
            XpLog.logger().config("JAMI DMSession: Exam " + i + "  [" + ns + " series]");
            for (int j = 0; j < ns; ++j) {
                Object val = this.series[i][j].getValue(8, 96);
                this.modality[i][j] = "" + val;
                Object iType = this.series[i][j].getValue(8, 8);
                this.imageType[i][j] = "" + iType;
                Object refval = this.series[i][j].getValue(32, 82);
                this.ref_uid[i][j] = "" + refval;
            }
        }
        return true;
    }

    private boolean loadES() {
        DMObject main = null;
        XpLog.logger().config("Found " + this.series.length + " series");
        int lenSeries = this.series.length;
        main = this.series[this.examNo][this.seriesNo];
        this.makeTags(this.modality[this.examNo][this.seriesNo], this.imageType[this.examNo][this.seriesNo]);
        if (this.loadMode == 0) {
            BufferedImage[] bufimgs = main.getPixelData(this.dmTags);
            this.mdi = this.wrapMedicalBufferedImage(bufimgs);
        } else if (this.loadMode == 1) {
            this.dmimgs = main.getImages(this.dmTags);
            this.mdi = this.wrapMedicalImage(this.dmimgs);
        }
        XpLog.logger().config("JAMI DMSession: Loading exam/series: " + this.examNo + "/" + this.seriesNo + "   [" + this.mdi.length + " images]");
        return true;
    }

    public final DMImage[] getDMImages() {
        if (this.reload) {
            this.loadES();
            this.reload = false;
        }
        return this.dmimgs;
    }

    private XpMedicalImage[] wrapMedicalImage(DMImage[] dmi) {
        int nImages = dmi.length;
        XpMedicalImage[] xmi = new XpMedicalImage[nImages];
        for (int i = 0; i < nImages; ++i) {
            xmi[i] = new XpMedicalDmImage(dmi[i]);
        }
        return xmi;
    }

    private XpMedicalImage[] wrapMedicalBufferedImage(BufferedImage[] bi) {
        int nImages = bi.length;
        XpMedicalImage[] xmi = new XpMedicalImage[nImages];
        for (int i = 0; i < nImages; ++i) {
            xmi[i] = new XpBufferedImage(bi[i]);
        }
        return xmi;
    }

    @Override
    public final XpMedicalImage[] getImages() {
        if (this.reload) {
            this.loadES();
            this.reload = false;
        }
        return this.mdi;
    }

    public final int getNumExams() {
        return this.nExams;
    }

    public final int getNumSeries(int ex) {
        if (ex >= 0 && ex < this.nExams) {
            return this.nSeries[ex];
        }
        return 0;
    }

    public final String getModality(int ex, int se) {
        if (ex >= 0 && ex < this.nExams && se >= 0 && se < this.nSeries[ex]) {
            return this.modality[ex][se];
        }
        return null;
    }

    public final String getRefUid(int ex, int se) {
        if (ex >= 0 && ex < this.nExams && se >= 0 && se < this.nSeries[ex]) {
            return this.ref_uid[ex][se];
        }
        return null;
    }

    public final void setLoadMode(int lm) {
        if (lm != 0 && lm != 1) {
            return;
        }
        this.loadMode = lm;
    }

    public final int getLoadMode() {
        return this.loadMode;
    }

    @Override
    public void addMedicalImageListListener(XpMedicalImageListListener listener) {
        this._listeners.add(listener);
    }

    @Override
    public void removeMedicalImageListListener(XpMedicalImageListListener listener) {
        this._listeners.remove(listener);
    }
}

