/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.plot;

import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public final class XpDrawTextUtils {
    public static Rectangle2D drawText(Graphics2D g, String msg, double posX, double posY) {
        FontRenderContext frc = g.getFontRenderContext();
        Rectangle2D bounds = g.getFont().getStringBounds(msg, frc);
        double dy = bounds.getY();
        double dx = bounds.getX();
        g.drawString(msg, (float)(posX - dx), (float)(posY - dy));
        return bounds;
    }

    public static Rectangle2D centerText(Graphics2D g, String msg, double posY, double centerPos) {
        FontRenderContext frc = g.getFontRenderContext();
        Rectangle2D bounds = g.getFont().getStringBounds(msg, frc);
        double posX = centerPos - bounds.getWidth() / 2.0;
        double dy = bounds.getY();
        double dx = bounds.getX();
        g.drawString(msg, (float)(posX - dx), (float)(posY - dy));
        return bounds;
    }

    public static Rectangle2D centerVerticalText(Graphics2D g, String msg, double posX, double height) {
        FontRenderContext frc = g.getFontRenderContext();
        Rectangle2D bounds = g.getFont().getStringBounds(msg, frc);
        double posY = height / 2.0 + bounds.getWidth() / 2.0;
        AffineTransform rot90 = AffineTransform.getRotateInstance(-1.5707963267948966, posX, posY);
        AffineTransform curr = g.getTransform();
        double dy = bounds.getY();
        double dx = bounds.getX();
        g.transform(rot90);
        g.drawString(msg, (float)(posX - dx), (float)(posY - dy));
        g.setTransform(curr);
        return bounds;
    }
}

