/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.plot;

import com.ge.med.terra.jami.plot.XpWaveformSource;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class XpWaveform
extends XpWaveformSource {
    private GeneralPath theWaveform = null;
    private List listPts = null;
    private Stroke theStroke = new BasicStroke();
    private Color theColor = Color.black;
    private boolean empty = true;
    private float minX = Float.POSITIVE_INFINITY;
    private float maxX = Float.NEGATIVE_INFINITY;
    private float minY = Float.POSITIVE_INFINITY;
    private float maxY = Float.NEGATIVE_INFINITY;
    private float[] coords = new float[6];

    public XpWaveform(String name) {
        super(name);
        this.theWaveform = new GeneralPath();
        this.listPts = new ArrayList();
    }

    public XpWaveform(List pts, String name) {
        this(name);
        for (Point2D p : pts) {
            this.addPoint(p);
        }
        this.notifyListeners();
    }

    private final Point2D getPointAt(int index) {
        return (Point2D)this.listPts.get(index);
    }

    public void deletePoints(int beginIndex, int endIndex) {
        this.theWaveform.reset();
        this.empty = true;
        for (int i = beginIndex; i < endIndex; ++i) {
            this.listPts.remove(i);
        }
        for (Point2D p : this.listPts) {
            float x = (float)p.getX();
            float y = (float)p.getY();
            this.addWaveformPoint(x, y);
        }
    }

    @Override
    public float getValue(float x) {
        float theValue = 0.0f;
        int numPts = this.listPts.size();
        int begin = 0;
        int end = numPts - 1;
        Point2D ptBegin = this.getPointAt(begin);
        float xBegin = (float)ptBegin.getX();
        float yBegin = (float)ptBegin.getY();
        Point2D ptEnd = this.getPointAt(end);
        float xEnd = (float)ptEnd.getX();
        float yEnd = (float)ptEnd.getY();
        if (x >= xBegin && x <= xEnd) {
            while (end - begin > 1) {
                int midIndex = (end + begin) / 2;
                Point2D midPt = this.getPointAt(midIndex);
                float midX = (float)midPt.getX();
                float midY = (float)midPt.getY();
                if (x <= midX) {
                    end = midIndex;
                    xEnd = midX;
                    yEnd = midY;
                    continue;
                }
                begin = midIndex;
                xBegin = midX;
                yBegin = midY;
            }
            float rangeX = xEnd - xBegin;
            float rangeY = yEnd - yBegin;
            theValue = rangeX == 0.0f ? (yBegin + yEnd) / 2.0f : yBegin + (x - xBegin) / rangeX * rangeY;
        }
        return theValue;
    }

    public float getValueLinear(float x) {
        PathIterator pi = this.theWaveform.getPathIterator(null);
        float prevX = -1.0f;
        float prevY = -1.0f;
        float currX = -1.0f;
        float currY = -1.0f;
        float theValue = 0.0f;
        boolean found = false;
        boolean firstVal = false;
        while (!pi.isDone()) {
            int type = pi.currentSegment(this.coords);
            if (type == 1 || type == 0) {
                currX = this.coords[0];
                currY = this.coords[1];
            }
            if (firstVal && x >= prevX && x <= currX) {
                float rangeX = currX - prevX;
                float rangeY = currY - prevY;
                found = true;
                theValue = rangeX == 0.0f ? (currY + prevY) / 2.0f : prevY + (x - prevX) / rangeX * rangeY;
            }
            if (found) break;
            prevX = currX;
            prevY = currY;
            firstVal = true;
            pi.next();
        }
        return theValue;
    }

    private void addWaveformPoint(float x, float y) {
        if (this.empty) {
            this.empty = false;
            this.theWaveform.moveTo(x, y);
        } else {
            this.theWaveform.lineTo(x, y);
        }
    }

    public final void addPoint(Point2D p) {
        float x = (float)p.getX();
        float y = (float)p.getY();
        this.addPoint(x, y);
    }

    public final void addPoint(float x, float y) {
        this.addWaveformPoint(x, y);
        this.listPts.add(new Point2D.Float(x, y));
        if (x < this.minX) {
            this.minX = x;
        }
        if (y < this.minY) {
            this.minY = y;
        }
        if (x > this.maxX) {
            this.maxX = x;
        }
        if (y > this.maxY) {
            this.maxY = y;
        }
    }

    public final int size() {
        return this.listPts.size();
    }

    @Override
    public Shape getWaveform() {
        return this.theWaveform;
    }

    @Override
    public Color getColor() {
        return this.theColor;
    }

    @Override
    public void setColor(Color color) {
        this.theColor = color != null ? color : Color.black;
    }

    @Override
    public Stroke getStroke() {
        return this.theStroke;
    }

    @Override
    public void setStroke(Stroke stroke) {
        this.theStroke = stroke != null ? stroke : new BasicStroke();
    }

    @Override
    public final float getMinX() {
        return this.minX;
    }

    public void setMinX(float _minX) {
        this.minX = _minX;
    }

    @Override
    public final float getMaxX() {
        return this.maxX;
    }

    public void setMaxX(float _maxX) {
        this.maxX = _maxX;
    }

    @Override
    public final float getMinY() {
        return this.minY;
    }

    public void setMinY(float _minY) {
        this.minY = _minY;
    }

    @Override
    public final float getMaxY() {
        return this.maxY;
    }

    public void setMaxY(float _maxY) {
        this.maxY = _maxY;
    }
}

