/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render;

import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.image.XpImageData;
import com.ge.med.terra.jami.render.NearestNeighbor;
import com.ge.med.terra.jami.render.XpColorOverlay;
import com.ge.med.terra.jami.render.XpDrawableFactory;
import com.ge.med.terra.jami.render.XpImage2DRenderer;
import com.ge.med.terra.jami.render.XpImageDrawable;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.XpJPipeline;
import com.ge.med.terra.jami.render.XpPipeline;
import com.ge.med.terra.jami.render.XpPixels;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;

public class XpXray2DRenderer
extends XpImage2DRenderer {
    public static short BG_VAL = (short)16384;
    private static final int TABLE_SIZE = 65536;
    private int[] colorTable = new int[65536];
    private int dataOffset = 0;
    private RenderedImage srcImage = null;
    private boolean computeWWWL = true;
    private boolean computeCTABLE = true;
    private boolean computeAFFINE = true;
    private int vpWidth = 0;
    private int vpHeight = 0;
    private AffineTransform inverse = new AffineTransform();
    private XpGeomUtils gu = new XpGeomUtils();
    private double[] tx = new double[6];
    private double[] itx = new double[6];
    private BufferedImage shortOutput = null;
    private BufferedImage byteOutput = null;
    private byte[] byteoutput = null;
    private short[] shortoutput = null;
    private double currWW;
    private double currWL;
    private XpColorOverlay currOverlay = null;
    private boolean invVideo = false;
    private IndexColorModel colortable = null;
    private double rescaleSlope = 1.0;
    private double rescaleIntercept = 0.0;
    private double currPanX;
    private double currPanY;
    private double currAngle;
    private double currZoom;
    private boolean currFlip;
    private boolean currFVP;
    private long sum = 0L;
    private int times = 0;
    private XpPixels pixels = new XpPixels();
    private XpImageDrawable drawable = null;
    private XpPipeline.RowBuffer rbuffer = null;
    private NearestNeighbor nneighbor = new NearestNeighbor();

    public XpXray2DRenderer() {
        this.setDrawableFactory(new XrayDrawableFactory());
        this.currPanY = 0.0;
        this.currPanX = 0.0;
        this.currAngle = 0.0;
        this.currZoom = 1.0;
        this.currFlip = false;
    }

    public final RenderedImage getSourceImage() {
        return this.srcImage;
    }

    @Override
    public void newImageCB(RenderedImage image) {
        this.srcImage = image;
        this.loadRenderedImage(this.srcImage);
    }

    private void loadRenderedImage(RenderedImage bi) {
        RenderedImage inputImage = bi;
        this.computeAFFINE = true;
        this.computeWWWL = true;
        DataBuffer db = null;
        db = inputImage instanceof BufferedImage ? ((BufferedImage)inputImage).getRaster().getDataBuffer() : inputImage.getData().getDataBuffer();
        this.dataOffset = db.getOffset();
        double rs = this.getRescaleSlope();
        double ri = this.getRescaleIntercept();
        if (this.rescaleSlope != rs || this.rescaleIntercept != ri) {
            this.computeCTABLE = true;
            this.computeWWWL = true;
            this.rescaleSlope = rs;
            this.rescaleIntercept = ri;
        }
    }

    @Override
    public void newImageRenderAttributesCB(XpImageRenderAttributes attr) {
        if (!attr.equalsPixelTransfer(this.currWW, this.currWL, this.invVideo, this.colortable, this.currOverlay)) {
            this.computeWWWL = true;
            this.computeCTABLE = true;
        }
        this.currWW = attr.getWindowWidth();
        this.currWL = attr.getWindowLevel();
        this.invVideo = attr.isVideoInverted();
        this.colortable = attr.getColormap();
        this.currOverlay = attr.getColorOverlay();
        if (this.currPanX != attr.getPanX() || this.currPanY != attr.getPanY() || this.currAngle != attr.getImageOrientation().getAngle() || this.currZoom != attr.getZoom() || this.currFlip != attr.getImageOrientation().getFlip() || this.currFVP != this.getFitToViewport()) {
            this.computeAFFINE = true;
            this.computeWWWL = true;
        }
        this.currPanX = attr.getPanX();
        this.currPanY = attr.getPanY();
        this.currAngle = attr.getImageOrientation().getAngle();
        this.currZoom = attr.getZoom();
        this.currFlip = attr.getImageOrientation().getFlip();
        this.currFVP = this.getFitToViewport();
    }

    private final void computePixelTransfer() {
        XpImageRenderAttributes ira = this.getAttributes();
        this.drawable.pixelTransfer(this.pixels, this.colorTable, ira);
    }

    @Override
    protected final void setChangeRender() {
        this.computeAFFINE = true;
        this.computeWWWL = true;
    }

    @Override
    public final void render(Graphics graphics, Rectangle viewport) {
        Graphics2D g2 = (Graphics2D)graphics;
        boolean createOut = false;
        long t1 = System.currentTimeMillis();
        if (this.vpWidth != viewport.width || this.vpHeight != viewport.height) {
            this.computeAFFINE = true;
            this.computeWWWL = true;
            createOut = true;
        }
        this.vpWidth = viewport.width;
        this.vpHeight = viewport.height;
        int w = this.srcImage.getWidth();
        int h = this.srcImage.getHeight();
        int img_bpp = this.getBitsStored();
        int pixelRepresentation = this.getPixelRepresentation();
        if (this.computeAFFINE) {
            AffineTransform at = this.getAffineTransform();
            this.gu.calcInverse(at, this.inverse);
            this.inverse.getMatrix(this.itx);
            at.getMatrix(this.tx);
            if (createOut) {
                XpDrawableFactory drwFactory = this.getDrawableFactory();
                this.drawable = drwFactory.createDrawable(img_bpp, this.vpWidth, this.vpHeight);
                this.rbuffer = new XpPipeline.RowBuffer(this.vpWidth, this.vpHeight);
            }
            DataBuffer db = XpImageData.getDataBuffer(this.srcImage);
            if (img_bpp > 8) {
                if (createOut || this.shortOutput == null) {
                    this.byteOutput = null;
                    this.shortOutput = new BufferedImage(this.vpWidth, this.vpHeight, 11);
                    this.shortoutput = ((DataBufferUShort)XpImageData.getDataBuffer(this.shortOutput)).getData();
                    this.pixels.setData(this.shortoutput, 2, img_bpp, 0, this.shortoutput.length);
                }
                short[] in = null;
                in = db instanceof DataBufferUShort ? ((DataBufferUShort)db).getData() : ((DataBufferShort)db).getData();
                Object iHint = this.getInterpolationHint();
                if (iHint == RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR) {
                    this.nneighbor.doINNShortToShort(this.tx, this.itx, in, this.dataOffset, w, h, this.shortoutput, this.vpWidth, this.vpHeight, BG_VAL);
                } else {
                    boolean zeroFlag;
                    double dx = this.itx[0] * 1.0 + this.itx[2] * 0.0;
                    double dy = this.itx[1] * 1.0 + this.itx[3] * 0.0;
                    double angle = Math.acos((dx * 1.0 + dy * 0.0) / Math.sqrt(dx * dx + dy * dy));
                    double deg = Math.toDegrees(angle) * 10000.0;
                    int ideg = (int)deg;
                    boolean uprightFlag = false;
                    boolean bl = zeroFlag = ideg % 3600000 == 0;
                    if (zeroFlag) {
                        dx = this.itx[0] * 1.0 + this.itx[2] * 1.0;
                        dy = this.itx[1] * 1.0 + this.itx[3] * 1.0;
                        if (dx > 0.0 && dy > 0.0) {
                            uprightFlag = true;
                        }
                    }
                    if (uprightFlag) {
                        XpJPipeline.doBilinearShortToShortUpright(this.tx, this.itx, in, this.dataOffset, w, h, pixelRepresentation, img_bpp, this.shortoutput, this.vpWidth, this.vpHeight, BG_VAL);
                    } else {
                        XpJPipeline.doBilinearShortToShortBox(this.tx, this.itx, in, this.dataOffset, w, h, pixelRepresentation, img_bpp, this.shortoutput, this.vpWidth, this.vpHeight, this.rbuffer, BG_VAL);
                    }
                }
                this.byteoutput = null;
            } else if (img_bpp <= 8) {
                if (createOut || this.byteOutput == null) {
                    this.shortOutput = null;
                    this.byteOutput = new BufferedImage(this.vpWidth, this.vpHeight, 10);
                    this.byteoutput = ((DataBufferByte)XpImageData.getDataBuffer(this.byteOutput)).getData();
                    this.pixels.setData(this.byteoutput, img_bpp, 0, this.byteoutput.length);
                }
                this.shortoutput = null;
            }
            this.computeAFFINE = false;
        }
        if (this.computeWWWL) {
            XpImageRenderAttributes ira = this.getAttributes();
            if (this.computeCTABLE) {
                this.fillColorTable(ira, this.colorTable);
                this.computeCTABLE = false;
            }
            this.computePixelTransfer();
            this.computeWWWL = false;
        }
        this.blitImage(g2, this.drawable);
        long t2 = System.currentTimeMillis();
        this.sum += t2 - t1;
        ++this.times;
    }

    protected void blitImage(Graphics2D g2, XpImageDrawable drawable) {
        BufferedImage blitImage = drawable.getBufferedImage();
        g2.drawRenderedImage(blitImage, null);
    }

    public static class NNeighbor
    extends XpXray2DRenderer {
        public NNeighbor() {
            this.setInterpolationHint(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        }
    }

    private static class XrayDrawableFactory
    implements XpDrawableFactory {
        private XrayDrawableFactory() {
        }

        @Override
        public final XpImageDrawable createDrawable(int bpp, int w, int h) {
            XpImageDrawable drawable = null;
            switch (bpp) {
                case 8: {
                    drawable = new XpImageDrawable.LuminanceByte(w, h);
                    break;
                }
                default: {
                    drawable = new XpImageDrawable.IntRGB(w, h);
                }
            }
            return drawable;
        }

        @Override
        public final int getDrawableType(int bpp, int w, int h) {
            return 10;
        }
    }
}

