/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render.remote;

import com.ge.med.idc.RenderEngine;
import com.ge.med.idc.TaskMonitor;
import com.ge.med.idc.XjChangeListener;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.j3d.mprender.MultipassPolicy;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;

public abstract class Base2DRenderEngine
implements RenderEngine {
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private Set changeListeners = new TreeSet();
    private int rgb_background = -16777216;
    private List taskMonitors = new ArrayList();
    private Map props = new TreeMap();
    private XpImageRenderAttributes ira = new XpImageRenderAttributes();
    private int[] pixbuff = null;
    private int width = 0;
    private int height = 0;

    public abstract XpMedicalImage getMedicalImage();

    public void setOutput(int[] pixbuff, int width, int height) {
        this.pixbuff = pixbuff;
        this.width = width;
        this.height = height;
    }

    @Override
    public Object getPixelBuffer() {
        return this.pixbuff;
    }

    public XpImageRenderAttributes getImageRenderAttributes() {
        return this.ira;
    }

    public void setImageRenderAttributes(XpImageRenderAttributes attr) {
        this.ira = attr;
    }

    @Override
    public int getBackgroundColor() {
        return this.rgb_background;
    }

    @Override
    public int getBufferHeight() {
        return this.height;
    }

    @Override
    public int getBufferWidth() {
        return this.width;
    }

    @Override
    public short[] getZBuffer() {
        return null;
    }

    @Override
    public int getNumChannels() {
        Object buff = this.getPixelBuffer();
        if (buff instanceof int[]) {
            return 3;
        }
        return 1;
    }

    @Override
    public int getBPP() {
        Object buff = this.getPixelBuffer();
        if (buff instanceof int[]) {
            return 8;
        }
        if (buff instanceof short[]) {
            XpMedicalImage mimg = this.getMedicalImage();
            if (mimg != null) {
                XpDicomElement dcm_elem = new XpDicomElement(8, 96);
                int result = mimg.getValue(dcm_elem);
                String modality = ("" + dcm_elem.value).toUpperCase();
                if (modality.equals("CT")) {
                    return 12;
                }
            }
            return 16;
        }
        if (buff instanceof byte[]) {
            return 8;
        }
        return 0;
    }

    @Override
    public void clearBuffers() {
        Arrays.fill(this.pixbuff, this.getBackgroundColor());
    }

    @Override
    public int getNumOutputs() {
        return 1;
    }

    @Override
    public void setProperty(String propName, Object value) {
        this.props.put(propName, value);
    }

    @Override
    public Object getProperty(String propName) {
        return this.props.get(propName);
    }

    @Override
    public void initRender() {
    }

    @Override
    public void setBackground(int rgbbackground, int lumbackground) {
        this.rgb_background = rgbbackground;
        this.notifyChange();
    }

    @Override
    public double getRescaleSlope(int renderOutputLayer) {
        XpMedicalImage mimg;
        Object buff = this.getPixelBuffer();
        if (buff instanceof short[] && (mimg = this.getMedicalImage()) != null) {
            return mimg.getRescaleSlope();
        }
        return 1.0;
    }

    @Override
    public double getRescaleIntercept(int renderOutputLayer) {
        XpMedicalImage mimg;
        Object buff = this.getPixelBuffer();
        if (buff instanceof short[] && (mimg = this.getMedicalImage()) != null) {
            return mimg.getRescaleIntercept();
        }
        return 0.0;
    }

    @Override
    public void addTaskMonitor(TaskMonitor tm) {
        this.taskMonitors.add(tm);
    }

    @Override
    public void removeTaskMonitor(TaskMonitor tm) {
        this.taskMonitors.remove(tm);
    }

    protected void notifyTaskBegin(String taskName, int totalWork) {
        int len = this.taskMonitors.size();
        for (int i = 0; i < len; ++i) {
            TaskMonitor tm = (TaskMonitor)this.taskMonitors.get(i);
            tm.taskBegin(taskName, totalWork);
        }
    }

    protected void notifyTaskDone(String taskName) {
        int len = this.taskMonitors.size();
        for (int i = 0; i < len; ++i) {
            TaskMonitor tm = (TaskMonitor)this.taskMonitors.get(i);
            tm.taskDone(taskName);
        }
    }

    protected void notifyTaskProgress(String taskName, int units) {
        int len = this.taskMonitors.size();
        for (int i = 0; i < len; ++i) {
            TaskMonitor tm = (TaskMonitor)this.taskMonitors.get(i);
            tm.taskProgress(taskName, units);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(String propName, PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(propName, l);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(prop, l);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.firePropertyChange(propertyName, new Boolean(oldValue), new Boolean(newValue));
    }

    protected void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.firePropertyChange(propertyName, new Integer(oldValue), new Integer(newValue));
    }

    protected void firePropertyChange(String propertyName, double oldValue, double newValue) {
        this.firePropertyChange(propertyName, new Double(oldValue), new Double(newValue));
    }

    @Override
    public void addChangeListener(XjChangeListener cl) {
        this.changeListeners.add(cl);
    }

    @Override
    public void removeChangeListener(XjChangeListener cl) {
        this.changeListeners.remove(cl);
    }

    protected final void notifyChange() {
        EventObject ce = new EventObject(this);
        for (XjChangeListener cl : this.changeListeners) {
            cl.stateChanged(ce);
        }
    }

    protected static InputStream mpassInputStream(String propName) {
        StringTokenizer st = new StringTokenizer(propName, ",");
        String resourceType = st.nextToken();
        String resourceName = st.nextToken();
        InputStream policyStream = null;
        System.err.println("Base2DRenderEngine: Loading multipass policy=[" + resourceType + "," + resourceName + "]");
        if (resourceType.equalsIgnoreCase("profile")) {
            if (resourceName.equalsIgnoreCase("local")) {
                policyStream = MultipassPolicy.class.getResourceAsStream("local_mpass.xml");
            } else if (resourceName.equalsIgnoreCase("remotefast")) {
                policyStream = MultipassPolicy.class.getResourceAsStream("remotefast_mpass.xml");
            } else if (resourceName.equalsIgnoreCase("remoteslow")) {
                policyStream = MultipassPolicy.class.getResourceAsStream("remoteslow_mpass.xml");
            }
        } else if (resourceType.equalsIgnoreCase("file")) {
            try {
                policyStream = new FileInputStream(resourceName);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return policyStream;
    }
}

