/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.render.remote;

import com.ge.med.idc.MultipassAlgorithm;
import com.ge.med.idc.XjFusionPixelCombiner;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpImage2DVc;
import com.ge.med.terra.jami.XpImageOrientation;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.remote.RmRenderSession;
import com.ge.med.terra.jami.render.XpDrawableFactory;
import com.ge.med.terra.jami.render.XpImagePixelAttributes;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.jami.render.remote.RmClient2DEngine;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.util.List;

public class RmImage2DVc
extends XpImage2DVc {
    private RmClient2DEngine engine = null;
    private BufferedImage outimg = null;
    private BufferedImage dispimg = null;
    private long paintCount = 0L;
    private boolean enabled = true;
    private String rendererType = "";
    private static String defaultRenderer = null;
    private boolean startIRE = true;
    private volatile boolean ire = true;
    private volatile boolean renderFinal = true;
    private transient boolean changeDisplay = false;
    private boolean keeprunning = true;
    private Object lock = new Object();
    private Object ireDone = new Object();

    public RmImage2DVc(RmClient2DEngine engine) {
        this.engine = engine;
        this.initializeImageVc(null);
    }

    public RmImage2DVc(RmRenderSession serverSession, String remoteRenderer) {
        this.engine = new RmClient2DEngine(serverSession, remoteRenderer);
        this.initializeImageVc(remoteRenderer);
    }

    private void initializeImageVc(String rType) {
        this.setDoubleBuffered(true);
        this.rendererType = rType;
        this.setBackground(Color.black);
        if (defaultRenderer == null) {
            defaultRenderer = XpPropertiesManager.getProperty("jami.render", "com.ge.med.terra.jami.render.XpJImage2DRenderer");
            XpLog.logger().config("JAMI: Using " + defaultRenderer + " renderer.");
        }
        if (this.rendererType == null) {
            this.rendererType = defaultRenderer;
        }
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.resizeBuffers(width, height);
    }

    @Override
    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.setSize(this.getWidth(), this.getHeight());
    }

    @Override
    public CTransform getTransform(byte in, byte out) {
        return this.engine.getTransform(in, out);
    }

    @Override
    public boolean contains(int x, int y) {
        return this.enabled;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.startIRE) {
            int w = this.getWidth();
            int h = this.getHeight();
            this.resizeBuffers(w, h);
            this.startIRE = false;
            this.startRenderThread();
        }
        g2.drawRenderedImage(this.dispimg, null);
        ++this.paintCount;
    }

    @Override
    public void setImage(XpImage image) {
        this.engine.setImage(image);
        this.updateDisplay();
    }

    protected void resizeBuffers(int width, int height) {
        this.outimg = new BufferedImage(width, height, 1);
        this.dispimg = new BufferedImage(width, height, 1);
        int[] rgbbuff = ((DataBufferInt)this.outimg.getRaster().getDataBuffer()).getData();
        this.engine.setOutput(rgbbuff, width, height);
        this.updateDisplay();
    }

    @Override
    public void dispose() {
        this.engine.dispose();
        this.shutdown();
    }

    @Override
    public AffineTransform getAffineTransform() {
        return this.engine.getAffineTransform();
    }

    @Override
    public XpImageOrientation getDisplayOrientation() {
        return this.engine.getDisplayOrientation();
    }

    @Override
    public boolean getFitToViewport() {
        return this.engine.getFitToViewport();
    }

    @Override
    public XpImage getFrame() {
        return this.engine.getFrame();
    }

    @Override
    public RenderedImage getImage() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getImageLayer() {
        return this.engine.getImageLayer();
    }

    @Override
    public XpImagePixelAttributes getImagePixelAttributes(int layer) {
        return this.engine.getImagePixelAttributes(layer);
    }

    @Override
    public Object getInterpolationHint() {
        return this.engine.getInterpolationHint();
    }

    @Override
    public int getNumImageLayers() {
        return this.engine.getNumImageLayers();
    }

    @Override
    public XjFusionPixelCombiner getPixelCombiner() {
        return this.engine.getPixelCombiner();
    }

    @Override
    public long getRenderTimeStamp() {
        return this.engine.getRenderTimeStamp();
    }

    @Override
    public boolean isClipGraphics() {
        return false;
    }

    @Override
    public boolean isFusionCapable() {
        return this.engine.isFusionCapable();
    }

    @Override
    public void refreshImage() {
        this.updateDisplay();
    }

    @Override
    public void refreshImageRenderAttributes() {
        this.refreshImage();
        this.updateDisplay();
    }

    @Override
    public void selectImageLayer(int layer) {
        this.engine.selectImageLayer(layer);
        this.updateDisplay();
    }

    @Override
    public void setClipGraphics(boolean clipGraphics) {
        this.engine.setClipGraphics(clipGraphics);
        this.updateDisplay();
    }

    @Override
    public void setDrawableFactory(XpDrawableFactory drwF) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFitToViewport(boolean toViewport) {
        this.engine.setFitToViewport(toViewport);
        this.updateDisplay();
    }

    @Override
    public void setImage(RenderedImage image) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List getImageLayers() {
        return null;
    }

    @Override
    public void setImageLayers(List imgLayers) {
        this.engine.setImageLayers(imgLayers);
        this.updateDisplay();
    }

    @Override
    public void setInterpolationHint(Object interpolationHint) {
        this.engine.setInterpolationHint(interpolationHint);
        this.updateDisplay();
    }

    @Override
    public void setPixelCombiner(XjFusionPixelCombiner fpc) {
        this.engine.setPixelCombiner(fpc);
        this.updateDisplay();
    }

    @Override
    public XpImageRenderAttributes getImageRenderAttributes() {
        return this.engine.getImageRenderAttributes();
    }

    @Override
    public void setImageRenderAttributes(XpImageRenderAttributes attr) {
        this.engine.setImageRenderAttributes(attr);
        this.updateDisplay();
    }

    @Override
    public long getPaintCount() {
        return this.paintCount;
    }

    @Override
    public Shape getClipShape() {
        return this.engine.getClipShape();
    }

    @Override
    public Shape getImageClip() {
        return this.engine.getImageClip();
    }

    @Override
    public void setClipShape(Shape clipShape) {
        this.engine.setClipShape(clipShape);
        this.updateDisplay();
    }

    @Override
    public void setImageClip(Shape s) {
        this.engine.setImageClip(s);
        this.updateDisplay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderThread() {
        while (true) {
            Object object = this.lock;
            synchronized (object) {
                while (!this.changeDisplay) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (!this.keeprunning) break;
            int w = this.getWidth();
            int h = this.getHeight();
            if (this.outimg == null || w != this.engine.getBufferWidth() || h != this.engine.getBufferHeight()) {
                this.resizeBuffers(w, h);
            }
            this.engine.clearBuffers();
            this.changeDisplay = false;
            this.renderFinal = false;
            boolean nengineoutputs = true;
            try {
                this.engine.initRender();
                if (this.ire) {
                    int passno = 0;
                    while (true) {
                        boolean donerender = false;
                        boolean rendercancel = false;
                        for (int layer = 0; layer < 1; ++layer) {
                            MultipassAlgorithm ma = this.engine.getMultipassAlgorithm(layer);
                            int rempasses = ma.render(0, 0, w, h, layer, passno);
                            ma.fill(0, 0, w, h, layer, passno);
                            if (rempasses == -99999) {
                                rendercancel = true;
                                break;
                            }
                            this.sendToOutput(layer);
                            if (!this.changeDisplay && rempasses != 0) continue;
                            donerender = true;
                        }
                        if (!rendercancel) {
                            this.paintToScreen();
                            if (!donerender) {
                                ++passno;
                                continue;
                            }
                        }
                        break;
                    }
                } else {
                    this.engine.render(0);
                    this.sendToOutput(0);
                    this.paintToScreen();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Object object2 = this.ireDone;
            synchronized (object2) {
                this.renderFinal = true;
                this.ireDone.notifyAll();
            }
        }
    }

    private void paintToScreen() {
        this.repaint();
    }

    private void sendToOutput(int layerNo) {
        int[] rgbbuff = ((DataBufferInt)this.outimg.getRaster().getDataBuffer()).getData();
        int[] dispbuff = ((DataBufferInt)this.dispimg.getRaster().getDataBuffer()).getData();
        System.arraycopy(rgbbuff, 0, dispbuff, 0, rgbbuff.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDisplay() {
        Object object = this.lock;
        synchronized (object) {
            this.changeDisplay = true;
            this.lock.notify();
        }
    }

    public void refresh() {
        this.updateDisplay();
    }

    public void shutdown() {
        this.keeprunning = false;
        this.updateDisplay();
    }

    private void startRenderThread() {
        Thread rt = new Thread(){

            @Override
            public void run() {
                RmImage2DVc.this.renderThread();
            }
        };
        rt.setName("RenderThread");
        rt.setDaemon(true);
        rt.start();
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForIRE() {
        Object object = this.ireDone;
        synchronized (object) {
            while (!this.renderFinal) {
                try {
                    this.ireDone.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

