/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.roi;

import com.ge.med.idc.Selectable;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.ClipRoiActor;
import com.ge.med.terra.jami.GSPSGraphic;
import com.ge.med.terra.jami.XpAnchorable;
import com.ge.med.terra.jami.XpAppContext;
import com.ge.med.terra.jami.XpHandle;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.capable.Replicable;
import com.ge.med.terra.jami.roi.XpRoiEventListener;
import com.ge.med.terra.jami.roi.XpRoiHandleContainer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.JComponent;

public class XpImageMatte
extends XpRoiHandleContainer
implements ClipRoiActor,
Selectable,
Replicable,
Serializable {
    private transient RectangularShape rs = null;
    private transient GeneralPath gp = null;
    private transient XpImage theImage = null;
    private CPoint display_pt1 = new CPoint(1);
    private CPoint display_pt2 = new CPoint(1);
    private CPoint img_pt = new CPoint(0);
    private boolean selected = true;
    private transient Point2D cp = new Point2D.Double();
    private boolean displayborder = false;
    boolean debug = false;
    private Color matteColor = Color.black;
    private transient Point2D startPos = null;
    private transient Point2D dragPos = null;
    private static int MIN_SIZE = 4;
    private static int HANDLE_LIMITS = 4;
    private Insets is = new Insets(0, 0, 0, 0);
    private Rectangle clipRectangle = new Rectangle();
    private CPoint display_pta = new CPoint(1);
    private CPoint display_ptb = new CPoint(1);
    private CPoint display_ptc = new CPoint(1);
    private float[] segment = new float[6];

    public XpImageMatte(RectangularShape rs) {
        this.rs = rs;
        this.gp = new GeneralPath();
        this.startPos = new Point2D.Double();
        this.dragPos = new Point2D.Double();
        this.createHandles();
    }

    @Override
    public Object clone() {
        RectangularShape newrs = (RectangularShape)this.rs.clone();
        XpImageMatte ccr = new XpImageMatte(newrs);
        this.copyObject(ccr);
        return ccr;
    }

    @Override
    protected void copyObject(Object o) {
        XpImageMatte pr = (XpImageMatte)o;
        pr.selected = this.selected;
        pr.matteColor = this.matteColor;
        pr.display_pt1 = (CPoint)this.display_pt1.clone();
        pr.display_pt2 = (CPoint)this.display_pt2.clone();
        pr.img_pt = (CPoint)this.img_pt.clone();
        pr.displayborder = this.displayborder;
        pr.cp = (Point2D)this.cp.clone();
    }

    @Override
    public void anchorDragged(MouseEvent e, CPoint drag, Object source) {
        if (this.debug) {
            System.out.println("drag x: " + drag.x + " drag y: " + drag.y);
        }
        this.cp = e.getPoint();
        XpHandle xph = (XpHandle)source;
        int idx = xph.getAnchorPointIndex();
        if (idx == 0) {
            this.drag(drag);
        }
        if (idx == 1) {
            this.resize(drag);
        }
    }

    public void resize(CPoint drag) {
        if (this.theImage != null) {
            int imgwidth = this.theImage.getSlice().width;
            int imgheight = this.theImage.getSlice().height;
            double x = this.rs.getX();
            double y = this.rs.getY();
            this.dragPos.setLocation(this.dragPos.getX() + drag.x, this.dragPos.getY() + drag.y);
            double xx = this.dragPos.getX();
            double yy = this.dragPos.getY();
            if (xx > (double)HANDLE_LIMITS && xx < (double)(imgwidth - 1 - HANDLE_LIMITS) && yy > (double)HANDLE_LIMITS && yy < (double)(imgheight - 1 - HANDLE_LIMITS)) {
                double ww = this.dragPos.getX() - x;
                double hh = this.dragPos.getY() - y;
                if (ww >= (double)MIN_SIZE && hh >= (double)MIN_SIZE) {
                    this.setFrame(x, y, ww, hh);
                    this.firePropertyChange("ROI_MODEL", this);
                }
            }
        }
    }

    public static void setHandleLimits(int hlimits) {
        HANDLE_LIMITS = hlimits;
    }

    public static int getHandleLimits() {
        return HANDLE_LIMITS;
    }

    public static void setMinimumSize(int min_size) {
        MIN_SIZE = min_size;
    }

    public static int getMinimumSize() {
        return MIN_SIZE;
    }

    public void drag(CPoint drag) {
        if (this.theImage != null) {
            int imgwidth = this.theImage.getSlice().width;
            int imgheight = this.theImage.getSlice().height;
            double w = this.rs.getWidth();
            double h = this.rs.getHeight();
            this.dragPos.setLocation(this.dragPos.getX() + drag.x, this.dragPos.getY() + drag.y);
            double xx = this.dragPos.getX();
            double yy = this.dragPos.getY();
            if (xx > (double)HANDLE_LIMITS && xx < (double)(imgwidth - 1 - HANDLE_LIMITS) && yy > (double)HANDLE_LIMITS && yy < (double)(imgheight - 1 - HANDLE_LIMITS)) {
                this.setFrame(xx, yy, w, h);
                this.firePropertyChange("ROI_MODEL", this);
            }
        }
    }

    @Override
    public void anchorPressed(MouseEvent e, Object source) {
        XpHandle h = (XpHandle)source;
        this.dragPos.setLocation(h.getX(), h.getY());
        this.startPos.setLocation(h.getX(), h.getY());
    }

    @Override
    public void anchorReleased(MouseEvent e, Object source) {
    }

    private void setFrame(double x, double y, double w, double h) {
        if (this.debug) {
            System.out.println("XpImageMatte setFrame");
        }
        this.rs.setFrame(x, y, w, h);
        this.get(0).setLocation(x, y);
        this.get(1).setLocation(x + w, y + h);
    }

    public void setDisplayBorder(boolean displayborder_) {
        this.displayborder = displayborder_;
    }

    public boolean getDisplayBorder() {
        return this.displayborder;
    }

    public boolean isBorderDisplayed() {
        return this.displayborder;
    }

    @Override
    public final void setSelected(boolean selection) {
        String val;
        if (this.debug) {
            System.out.println("setSelected: " + selection);
        }
        this.selected = selection;
        String string = val = this.selected ? "COMPONENT_SELECTED" : "COMPONENT_UNSELECTED";
        if (this.selected) {
            this.firePropertyChange(val, this);
        }
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void paintShape(XpVisualComponent vc, Graphics2D g) {
        Graphics2D g2 = g;
        CTransform t2 = vc.getTransform((byte)0, (byte)1);
        PathIterator iterator = this.rs.getPathIterator(null);
        this.gp.reset();
        while (!iterator.isDone()) {
            int segmentType = iterator.currentSegment(this.segment);
            switch (segmentType) {
                case 0: {
                    this.img_pt.set(this.segment[0], this.segment[1], 0.0);
                    t2.transform(this.img_pt, this.display_pta);
                    this.gp.moveTo((float)this.display_pta.x, (float)this.display_pta.y);
                    break;
                }
                case 1: {
                    this.img_pt.set(this.segment[0], this.segment[1], 0.0);
                    t2.transform(this.img_pt, this.display_pta);
                    this.gp.lineTo((float)this.display_pta.x, (float)this.display_pta.y);
                    break;
                }
                case 2: {
                    this.img_pt.set(this.segment[0], this.segment[1], 0.0);
                    t2.transform(this.img_pt, this.display_pta);
                    this.img_pt.set(this.segment[2], this.segment[3], 0.0);
                    t2.transform(this.img_pt, this.display_ptb);
                    this.gp.quadTo((float)this.display_pta.x, (float)this.display_pta.y, (float)this.display_ptb.x, (float)this.display_ptb.y);
                    break;
                }
                case 3: {
                    this.img_pt.set(this.segment[0], this.segment[1], 0.0);
                    t2.transform(this.img_pt, this.display_pta);
                    this.img_pt.set(this.segment[2], this.segment[3], 0.0);
                    t2.transform(this.img_pt, this.display_ptb);
                    this.img_pt.set(this.segment[4], this.segment[5], 0.0);
                    t2.transform(this.img_pt, this.display_ptc);
                    this.gp.curveTo((float)this.display_pta.x, (float)this.display_pta.y, (float)this.display_ptb.x, (float)this.display_ptb.y, (float)this.display_ptc.x, (float)this.display_ptc.y);
                    break;
                }
                case 4: {
                    this.gp.closePath();
                }
            }
            iterator.next();
        }
        g2.setColor(this.matteColor);
        Shape cs = g2.getClip();
        Area area = new Area(cs);
        Area a2 = new Area(this.gp);
        area.subtract(a2);
        ((JComponent)vc.getParent()).getInsets(this.is);
        this.clipRectangle.setBounds(this.is.left, this.is.right, vc.getWidth() - this.is.left - this.is.right, vc.getHeight() - this.is.top - this.is.bottom);
        g2.clip(this.clipRectangle);
        g2.clip(area);
        g2.fillRect(0, 0, vc.getWidth(), vc.getHeight());
        g2.setClip(cs);
        if (this.selected) {
            if (this.isBorderDisplayed()) {
                g.setColor(XpAppContext.getSelectedColor());
            } else {
                g.setColor(null);
            }
        } else if (this.isBorderDisplayed()) {
            g.setColor(XpAppContext.getUnSelectedColor());
        } else {
            g.setColor(null);
        }
        g2.draw(this.gp);
    }

    public void createHandles() {
        XpHandle h1 = new XpHandle((XpAnchorable)this, 0, 16);
        this.add(h1);
        XpHandle h2 = new XpHandle((XpAnchorable)this, 1, 16);
        this.add(h2);
        h1.setFilled(true);
        h2.setFilled(false);
        h1.setLocation(this.rs.getX(), this.rs.getY());
        h2.setLocation(this.rs.getX() + this.rs.getWidth(), this.rs.getY() + this.rs.getHeight());
    }

    @Override
    public boolean containsROI(XpVisualComponent vc, int x, int y) {
        return !this.gp.contains(x, y);
    }

    @Override
    public final GSPSGraphic gspsDescription() {
        return null;
    }

    @Override
    public void setImage(XpImage image) {
        this.theImage = image;
    }

    @Override
    public XpImage getImage() {
        return this.theImage;
    }

    @Override
    public void roiClicked(MouseEvent e) {
        if (this.debug) {
            System.out.println(" -- XpImageMatte roiClicked -- ");
        }
        this.setSelected(true);
    }

    @Override
    public void addRoiEventListener(XpRoiEventListener rel) {
    }

    @Override
    public void removeRoiEventListener(XpRoiEventListener rel) {
    }

    public Color getMatteColor() {
        return this.matteColor;
    }

    public void setMatteColor(Color matteColor) {
        this.matteColor = matteColor;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        try {
            s.defaultWriteObject();
            if (this.rs instanceof Rectangle2D.Double) {
                s.writeObject(new String("Rectangle2D.Double"));
                s.writeDouble(this.rs.getX());
                s.writeDouble(this.rs.getY());
                s.writeDouble(this.rs.getWidth());
                s.writeDouble(this.rs.getHeight());
            } else if (this.rs instanceof Ellipse2D.Double) {
                s.writeObject(new String("Ellipse2D.Double"));
                s.writeDouble(this.rs.getX());
                s.writeDouble(this.rs.getY());
                s.writeDouble(this.rs.getWidth());
                s.writeDouble(this.rs.getHeight());
            } else if (this.rs instanceof RoundRectangle2D.Double) {
                s.writeObject(new String("RoundRectangle2D.Double"));
                RoundRectangle2D.Double rect = (RoundRectangle2D.Double)this.rs;
                s.writeDouble(rect.getX());
                s.writeDouble(rect.getY());
                s.writeDouble(rect.getWidth());
                s.writeDouble(rect.getHeight());
                s.writeDouble(rect.getArcHeight());
                s.writeDouble(rect.getArcWidth());
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException {
        try {
            s.defaultReadObject();
            String shape = (String)s.readObject();
            if (shape.compareTo("Rectangle2D.Double") == 0) {
                Rectangle2D.Double rect = null;
                rect = new Rectangle2D.Double(s.readDouble(), s.readDouble(), s.readDouble(), s.readDouble());
                this.rs = rect;
            } else if (shape.compareTo("Ellipse2D.Double") == 0) {
                Ellipse2D.Double ellipse = null;
                ellipse = new Ellipse2D.Double(s.readDouble(), s.readDouble(), s.readDouble(), s.readDouble());
                this.rs = ellipse;
            } else if (shape.compareTo("RoundRectangle2D.Double") == 0) {
                RoundRectangle2D.Double rrect = null;
                rrect = new RoundRectangle2D.Double(s.readDouble(), s.readDouble(), s.readDouble(), s.readDouble(), s.readDouble(), s.readDouble());
                this.rs = rrect;
            }
            this.gp = new GeneralPath();
            this.cp = new Point2D.Double();
            this.dragPos = new Point2D.Double();
            this.startPos = new Point2D.Double();
            this.createHandles();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

