/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.roi;

import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.GSPSGraphic;
import com.ge.med.terra.jami.XpAnchorable;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpHandle;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpMedicalImage2DVc;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.roi.XpRoiEventListener;
import com.ge.med.terra.jami.roi.XpRoiHandleContainer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class XpImageShutter
extends XpRoiHandleContainer
implements Cloneable,
Serializable {
    private CPoint display_pt = new CPoint(1);
    private CPoint img_pt = new CPoint(0);
    private transient GeneralPath polygon = null;
    private transient GeneralPath clipPolygon = null;
    private transient XpImage myImage = null;
    private boolean selected = true;
    private boolean burned = false;
    private transient XpMedicalImage2DVc mivc = null;
    private transient XpGeomUtils gu = new XpGeomUtils();
    private transient Point2D Pi = new Point2D.Double();
    private transient Point2D Pj = new Point2D.Double();
    private transient Point2D Ptmp = new Point2D.Double();
    private transient Point2D I0 = new Point2D.Double();
    private transient Point2D I1 = new Point2D.Double();
    private transient Line2D S1 = new Line2D.Double();
    private transient Line2D S2 = new Line2D.Double();
    private transient Point2D[] pts = null;

    public XpImageShutter(XpMedicalImage2DVc mivc, Point2D[] pts) {
        this.mivc = mivc;
        int npts = pts.length;
        this.pts = new Point2D[npts];
        for (int i = 0; i < npts; ++i) {
            XpHandle handle = new XpHandle((XpAnchorable)this, i, 16);
            handle.setFilled(false);
            this.add(handle);
            handle.setLocation(pts[i]);
            this.pts[i] = new Point2D.Double(pts[i].getX(), pts[i].getY());
        }
        this.polygon = new GeneralPath();
        this.clipPolygon = new GeneralPath();
    }

    public Object clone() {
        XpImageShutter ccr = new XpImageShutter(new XpMedicalImage2DVc(), new Point2D[0]);
        this.copyObject(ccr);
        return ccr;
    }

    @Override
    protected void copyObject(Object o) {
        XpImageShutter is = (XpImageShutter)o;
        is.display_pt = (CPoint)this.display_pt.clone();
        is.img_pt = (CPoint)this.img_pt.clone();
        is.polygon = (GeneralPath)this.polygon.clone();
        is.clipPolygon = (GeneralPath)this.clipPolygon.clone();
        is.myImage = this.myImage;
        is.selected = this.selected;
        this.burned = this.burned;
        is.gu = new XpGeomUtils();
        is.Pi = (Point2D)this.Pi.clone();
        is.Pj = (Point2D)this.Pj.clone();
        is.Ptmp = (Point2D)this.Ptmp.clone();
        is.I0 = (Point2D)this.I0.clone();
        is.I1 = (Point2D)this.I1.clone();
        is.S1 = (Line2D)this.S1.clone();
        is.S2 = (Line2D)this.S2.clone();
    }

    public void burn() {
        this.burned = true;
        this.mivc.setImageClip((Shape)this.clipPolygon.clone());
        this.clearHandles();
    }

    private void syncPts(XpVisualComponent vc) {
        int npts = this.getNumHandles();
        this.polygon.reset();
        this.clipPolygon.reset();
        CTransform t = vc.getTransform((byte)0, (byte)1);
        this.img_pt.setLocation(this.get(0).getX(), this.get(0).getY(), 0.0);
        t.transform(this.img_pt, this.display_pt);
        this.polygon.moveTo((float)this.display_pt.x, (float)this.display_pt.y);
        this.clipPolygon.moveTo((float)this.get(0).getX(), (float)this.get(0).getY());
        for (int i = 1; i < npts; ++i) {
            this.img_pt.setLocation(this.get(i).getX(), this.get(i).getY(), 0.0);
            t.transform(this.img_pt, this.display_pt);
            this.polygon.lineTo((float)this.display_pt.x, (float)this.display_pt.y);
            this.clipPolygon.lineTo((float)this.get(i).getX(), (float)this.get(i).getY());
        }
        this.polygon.closePath();
        this.clipPolygon.closePath();
    }

    @Override
    public void paintShape(XpVisualComponent vc, Graphics2D g) {
        if (!this.burned) {
            Graphics2D g2 = g;
            this.syncPts(vc);
            Color c = g2.getColor();
            g2.setColor(Color.orange);
            g2.draw(this.polygon);
            g2.setColor(c);
        }
    }

    @Override
    public boolean containsROI(XpVisualComponent vc, int x, int y) {
        return false;
    }

    @Override
    public void setImage(XpImage image) {
        this.myImage = image;
    }

    @Override
    public final XpImage getImage() {
        return this.myImage;
    }

    @Override
    public void setSelected(boolean selection) {
        this.selected = selection;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    private boolean legalMove() {
        int nSegs = this.getNumHandles();
        if (nSegs <= 2) {
            return true;
        }
        for (int i = 0; i < nSegs; ++i) {
            int cs = i;
            int ps = i;
            int ns = i;
            XpHandle h = this.get(i);
            this.Pi.setLocation(h.getX(), h.getY());
            ps = i == 0 ? nSegs - 1 : i - 1;
            if (i < nSegs - 1) {
                h = this.get(i + 1);
                this.S1.setLine(this.Pi.getX(), this.Pi.getY(), h.getX(), h.getY());
                ns = i + 1;
            } else {
                h = this.get(0);
                this.S1.setLine(this.Pi.getX(), this.Pi.getY(), h.getX(), h.getY());
                ns = 0;
            }
            for (int j = 0; j < nSegs; ++j) {
                if (j == cs || j == ns || j == ps) continue;
                h = this.get(j);
                this.Pj.setLocation(h.getX(), h.getY());
                if (j < nSegs - 1) {
                    h = this.get(j + 1);
                    this.S2.setLine(this.Pj.getX(), this.Pj.getY(), h.getX(), h.getY());
                } else {
                    h = this.get(0);
                    this.S2.setLine(this.Pj.getX(), this.Pj.getY(), h.getX(), h.getY());
                }
                int code = this.gu.intersect2DSegments(this.S1, this.S2, this.I0, this.I1);
                if (code == 0) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void anchorDragged(MouseEvent e, CPoint drag, Object source) {
        XpHandle xph = (XpHandle)source;
        double x = xph.getX() + drag.x;
        double y = xph.getY() + drag.y;
        double oldX = xph.getX();
        double oldY = xph.getY();
        xph.setLocation(x, y);
        if (this.legalMove()) {
            XpVisualComponent vc = (XpVisualComponent)e.getSource();
            this.syncPts(vc);
            vc.repaint();
        } else {
            xph.setLocation(oldX, oldY);
        }
    }

    @Override
    public void anchorPressed(MouseEvent e, Object source) {
    }

    @Override
    public void anchorReleased(MouseEvent e, Object source) {
    }

    @Override
    public final GSPSGraphic gspsDescription() {
        return null;
    }

    @Override
    public void addRoiEventListener(XpRoiEventListener rel) {
    }

    @Override
    public void removeRoiEventListener(XpRoiEventListener rel) {
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        try {
            s.defaultWriteObject();
            s.writeInt(this.pts.length);
            for (int i = 0; i < this.pts.length; ++i) {
                s.writeDouble(this.pts[i].getX());
                s.writeDouble(this.pts[i].getY());
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException {
        try {
            s.defaultReadObject();
            int npts = s.readInt();
            this.pts = new Point2D[npts];
            for (int i = 0; i < npts; ++i) {
                XpHandle handle = new XpHandle((XpAnchorable)this, i, 16);
                handle.setFilled(false);
                this.add(handle);
                this.pts[i] = new Point2D.Double(s.readDouble(), s.readDouble());
                handle.setLocation(this.pts[i]);
            }
            this.polygon = new GeneralPath();
            this.clipPolygon = new GeneralPath();
            this.gu = new XpGeomUtils();
            this.Pi = new Point2D.Double();
            this.Pj = new Point2D.Double();
            this.Ptmp = new Point2D.Double();
            this.I0 = new Point2D.Double();
            this.I1 = new Point2D.Double();
            this.S1 = new Line2D.Double();
            this.S2 = new Line2D.Double();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

