/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.roi;

import com.ge.med.idc.ComponentCapable;
import com.ge.med.idc.ComponentCreator;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.GSPSGraphic;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpAnchorable;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpHandle;
import com.ge.med.terra.jami.XpHandleVc;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpPixelStatistics;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpRoiComponentCreator;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.roi.RoiShapeModel;
import com.ge.med.terra.jami.roi.XpRoiHandleContainer;
import com.ge.med.terra.jami.roi.XpStatisticsRoi;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class XpPolygonRoi
extends XpStatisticsRoi
implements Cloneable,
Serializable {
    private static final String DEG_SYMBOL = new String(new char[]{'\u00b0'});
    private static int LINE_SENSITIVITY = 4;
    private transient GeneralPath polygon = null;
    private transient GeneralPath drawPolygon = new GeneralPath();
    private transient List points = new ArrayList();
    private transient List txpoints = new ArrayList();
    private transient Point2D tmpPoint1 = new Point2D.Double();
    private transient Point2D tmpPoint2 = new Point2D.Double();
    private transient Point2D containsTemp = new Point2D.Double();
    private transient Point2D clipPt = new Point2D.Double();
    private transient List approxPts = new ArrayList();
    private double minX = 0.0;
    private double maxX = 0.0;
    private double minY = 0.0;
    private double maxY = 0.0;
    private transient Point2D accumPoint = new Point2D.Double();
    private transient Point2D firstPtOffset = new Point2D.Double();
    private boolean closed = false;
    private boolean idealMetrics = true;
    private boolean doHandles = true;
    private static final double SCOOTCH = 2.5;

    public XpPolygonRoi(Point2D[] pts) {
        super(new GeneralPath());
        this.init(pts, false, true);
    }

    public XpPolygonRoi(Point2D[] pts, boolean calcPixelStatistics) {
        super(new GeneralPath());
        this.init(pts, calcPixelStatistics, true);
    }

    public XpPolygonRoi(RoiShapeModel shapeModel, Point2D[] pts) {
        super(shapeModel);
        this.init(pts, false, true);
    }

    public XpPolygonRoi(Point2D[] pts, boolean calcPixelStatistics, boolean doHandles) {
        super(new GeneralPath());
        this.init(pts, calcPixelStatistics, doHandles);
    }

    private void init(Point2D[] pts, boolean pixStats, boolean doHandles) {
        this.polygon = (GeneralPath)this.getModelShape();
        this.setCalcPixelStats(pixStats);
        this.doHandles = doHandles;
        if (pts != null && pts.length > 0) {
            for (int i = 0; i < pts.length; ++i) {
                this.points.add(pts[i]);
                this.txpoints.add(new Point2D.Double());
                XpHandle handle = new XpHandle((XpAnchorable)this, i, 16);
                handle.setFilled(false);
                this.add(handle);
            }
            this.generateModelPolygon();
        }
    }

    @Override
    public Object clone() {
        int len = this.points.size();
        Point2D[] ptarray = new Point2D[len];
        for (int i = 0; i < len; ++i) {
            Point2D thept = (Point2D)this.points.get(i);
            ptarray[i] = (Point2D)thept.clone();
        }
        XpPolygonRoi ccr = new XpPolygonRoi(ptarray);
        this.copyObject(ccr);
        return ccr;
    }

    @Override
    protected void copyObject(Object o) {
        XpPolygonRoi pr = (XpPolygonRoi)o;
        super.copyObject(pr);
        pr.closed = this.closed;
        pr.idealMetrics = this.idealMetrics;
        pr.doHandles = this.doHandles;
    }

    @Override
    public final Shape getDrawShape() {
        this.generateDrawPolygon();
        return this.drawPolygon;
    }

    public double getLineAngle() {
        return this.getLineAngle(0);
    }

    public double getLineAngle(int pairIdx) {
        int len = this.points.size();
        if (pairIdx + 2 < len) {
            Point2D p1 = (Point2D)this.points.get(pairIdx);
            Point2D c = (Point2D)this.points.get(pairIdx + 1);
            Point2D p2 = (Point2D)this.points.get(pairIdx + 2);
            XpGeomUtils.sub(p1, c, this.tmpPoint1);
            XpGeomUtils.sub(p2, c, this.tmpPoint2);
            return XpGeomUtils.angle(this.tmpPoint1, this.tmpPoint2);
        }
        if (len == 2) {
            Point2D p1 = (Point2D)this.points.get(0);
            Point2D p2 = (Point2D)this.points.get(1);
            double dy = Math.abs(p2.getY() - p1.getY());
            double dx = Math.abs(p2.getX() - p1.getX());
            return Math.atan2(dx, dy);
        }
        return 0.0;
    }

    @Override
    public String createRoiStatLabel(XpPixelStatistics ps) {
        double angle = Math.toDegrees(this.getLineAngle());
        double distance = this.getLength();
        int len = this.points.size();
        String roiStat = this.getRoiLabel() + ": ";
        if (len == 2) {
            roiStat = roiStat + "distance " + this.statFormat0(distance) + " mm";
            roiStat = roiStat + ", angle " + this.statFormat(angle) + DEG_SYMBOL;
        } else if (len == 3) {
            roiStat = roiStat + "angle " + this.statFormat(angle) + DEG_SYMBOL;
        } else if (len > 3) {
            roiStat = roiStat + "distance " + this.statFormat0(distance) + " mm";
        }
        return roiStat;
    }

    @Override
    public final void render(XpVisualComponent vc, Graphics2D g) {
        super.render(vc, g);
        g.setColor(XpHandleVc.getHandleColor());
        this.drawRoiId(g, this.firstPtOffset.getX(), this.firstPtOffset.getY());
    }

    public final void addPoint(Point2D p) {
        this.points.add(p);
        this.txpoints.add(new Point2D.Double());
        int new_id = this.getNumHandles();
        XpHandle handle = new XpHandle((XpAnchorable)this, new_id, 16);
        handle.setFilled(false);
        this.add(handle);
        this.generateModelPolygon();
        this.syncModel();
    }

    public Point2D getPoint(int i) {
        return (Point2D)this.points.get(i);
    }

    public void setPoint(int i, Point2D p) {
        Point2D target = (Point2D)this.points.get(i);
        target.setLocation(p);
        this.syncModel();
    }

    public List getPoints() {
        return this.points;
    }

    public void setPoints(Point2D[] pts) {
        this.points.clear();
        for (int i = 0; i < pts.length; ++i) {
            this.points.add(pts[i].clone());
        }
        this.syncModel();
    }

    public void setPoints(List pts) {
        this.points.clear();
        for (int i = 0; i < pts.size(); ++i) {
            this.points.add(((Point2D)pts.get(i)).clone());
        }
        this.syncModel();
    }

    public final int getNumPoints() {
        return this.points.size();
    }

    private final void generateModelPolygon() {
        this.polygon.reset();
        this.approxPts.clear();
        int nPts = this.points.size();
        if (nPts > 0) {
            Point2D p;
            Point2D prev = p = (Point2D)this.points.get(0);
            this.approxPts.add(p);
            float x = (float)p.getX();
            float y = (float)p.getY();
            this.polygon.moveTo(x, y);
            for (int i = 1; i < nPts; ++i) {
                p = (Point2D)this.points.get(i);
                x = (float)p.getX();
                y = (float)p.getY();
                this.polygon.lineTo(x, y);
                double distance = p.distanceSq(prev);
                if (!(distance > 6.0) && nPts >= 100) continue;
                this.approxPts.add(p);
                prev = p;
            }
            if (this.closed && nPts > 2) {
                p = (Point2D)this.points.get(0);
                this.polygon.lineTo((float)p.getX(), (float)p.getY());
                this.polygon.closePath();
            }
        }
    }

    private final void generateDrawPolygon() {
        this.polygon.reset();
        this.drawPolygon.reset();
        int nPts = this.points.size();
        if (nPts > 0) {
            Point2D p = (Point2D)this.points.get(0);
            float x = (float)p.getX();
            float y = (float)p.getY();
            this.getDisplayPoint(p, this.tmpPoint1);
            float t_x = (float)this.tmpPoint1.getX();
            float t_y = (float)this.tmpPoint1.getY();
            this.polygon.moveTo(x, y);
            this.drawPolygon.moveTo(t_x, t_y);
            this.firstPtOffset.setLocation(t_x + 4.0f, t_y - 2.0f);
            this.minX = this.maxX = (double)x;
            this.minY = this.maxY = (double)y;
            for (int i = 1; i < nPts; ++i) {
                p = (Point2D)this.points.get(i);
                x = (float)p.getX();
                y = (float)p.getY();
                this.getDisplayPoint(p, this.tmpPoint1);
                t_x = (float)this.tmpPoint1.getX();
                t_y = (float)this.tmpPoint1.getY();
                this.polygon.lineTo(x, y);
                this.drawPolygon.lineTo(t_x, t_y);
                if ((double)x < this.minX) {
                    this.minX = x;
                }
                if ((double)x > this.maxX) {
                    this.maxX = x;
                }
                if ((double)y < this.minY) {
                    this.minY = y;
                }
                if (!((double)y > this.maxY)) continue;
                this.maxY = y;
            }
            if (this.closed && nPts > 2) {
                p = (Point2D)this.points.get(0);
                this.polygon.lineTo((float)p.getX(), (float)p.getY());
                this.polygon.closePath();
                this.drawPolygon.closePath();
            }
        }
    }

    @Override
    public void anchorPressed(MouseEvent e, Object source) {
        XpHandle xph = (XpHandle)source;
        int i = xph.getAnchorPointIndex();
        Point2D p = (Point2D)this.points.get(i);
        this.accumPoint.setLocation(p);
        super.anchorPressed(e, source);
    }

    @Override
    public void anchorDragged(MouseEvent e, CPoint drag, Object source) {
        XpHandle xph = (XpHandle)source;
        int i = xph.getAnchorPointIndex();
        Point2D p = (Point2D)this.points.get(i);
        this.accumPoint.setLocation(this.accumPoint.getX() + drag.x, this.accumPoint.getY() + drag.y);
        double x = this.accumPoint.getX();
        double y = this.accumPoint.getY();
        this.clipPoint(x, y, this.clipPt);
        if (x == this.clipPt.getX() && y == this.clipPt.getY()) {
            p.setLocation(this.clipPt);
        }
        this.generateModelPolygon();
        this.syncModel();
        super.anchorDragged(e, drag, source);
    }

    private boolean isInBoundary(double xx, double yy) {
        Point2D first;
        Point2D prev = first = (Point2D)this.approxPts.get(0);
        int len = this.approxPts.size();
        for (int i = 1; i < len; ++i) {
            Point2D p = (Point2D)this.approxPts.get(i);
            if (XpGeomUtils.containsCoord((int)xx, (int)yy, prev, p, LINE_SENSITIVITY)) {
                return true;
            }
            prev = p;
        }
        return this.closed && XpGeomUtils.containsCoord((int)xx, (int)yy, prev, first, LINE_SENSITIVITY);
    }

    @Override
    public boolean containsROI(XpVisualComponent vc, int x, int y) {
        Rectangle2D bounds;
        if (this.isDragByRoiLabel() && (bounds = this.getRoiLabelBounds()) != null && bounds.contains(x, y)) {
            return true;
        }
        this.getImagePoint(x, y, this.containsTemp);
        double xx = this.containsTemp.getX();
        double yy = this.containsTemp.getY();
        boolean retval = false;
        if (this.getNumPoints() < 32) {
            retval = this.isInBoundary(xx, yy);
        } else if (xx > this.minX - 2.5 && xx < this.maxX + 2.5 && yy > this.minY - 2.5 && yy < this.maxY + 2.5) {
            retval = this.isInBoundary(xx, yy);
        }
        return retval;
    }

    public static ComponentCreator getLineComponentCreator(int ccid) {
        if (ccid == 0) {
            return new PolygonComponentCreator(1);
        }
        return null;
    }

    public static ComponentCreator getAngleComponentCreator(int ccid) {
        if (ccid == 0) {
            return new PolygonComponentCreator(2);
        }
        return null;
    }

    public static ComponentCreator getComponentCreator(int ccid) {
        if (ccid == 0) {
            return new PolygonComponentCreator();
        }
        return null;
    }

    private void translate(double tx, double ty) {
        Point2D txp;
        Point2D p;
        int i;
        int len = this.points.size();
        boolean dotranslate = true;
        for (i = 0; i < len; ++i) {
            p = (Point2D)this.points.get(i);
            txp = (Point2D)this.txpoints.get(i);
            double x = p.getX() + tx;
            double y = p.getY() + ty;
            this.clipPoint(x, y, this.clipPt);
            double cx = this.clipPt.getX();
            double cy = this.clipPt.getY();
            if ((x != cx || y != cy) && this.isClipRoi()) {
                dotranslate = false;
                break;
            }
            txp.setLocation(cx, cy);
        }
        if (dotranslate) {
            for (i = 0; i < len; ++i) {
                p = (Point2D)this.points.get(i);
                txp = (Point2D)this.txpoints.get(i);
                p.setLocation(txp);
            }
            this.generateDrawPolygon();
        }
    }

    @Override
    public final void dragMouse(CPoint drag) {
        this.translate(drag.x, drag.y);
        this.syncModel();
    }

    @Override
    protected void updateHandles() {
        int len = this.points.size();
        for (int i = 0; i < len; ++i) {
            XpHandle h = this.get(i);
            Point2D p = (Point2D)this.points.get(i);
            h.setLocation(p);
        }
    }

    public final boolean isClosed() {
        return this.closed;
    }

    public final void setClosed(boolean closed) {
        this.closed = closed;
        if (closed) {
            this.setCalcPixelStats(true);
        }
    }

    @Override
    public GSPSGraphic gspsDescription() {
        int len = this.points.size();
        Point2D[] pts = new Point2D[len];
        for (int i = 0; i < len; ++i) {
            Point2D p = (Point2D)this.points.get(i);
            pts[i] = new Point2D.Double(p.getX(), p.getY());
        }
        XpRoiHandleContainer.GraphicDescriptor description = new XpRoiHandleContainer.GraphicDescriptor("POLYLINE", pts);
        return description;
    }

    public void setIdealMetrics(boolean idealMetric) {
        this.idealMetrics = idealMetric;
    }

    public boolean isIdealMetrics() {
        return this.idealMetrics;
    }

    @Override
    public double getLength() {
        if (!this.idealMetrics) {
            return super.getLength();
        }
        XpImage img = this.getImage();
        int size = this.points.size();
        double len = 0.0;
        if (img != null) {
            double pdx = img.getPixelDimensionX();
            double pdy = img.getPixelDimensionY();
            for (int i = 1; i < size; ++i) {
                Point2D p1 = (Point2D)this.points.get(i);
                Point2D p0 = (Point2D)this.points.get(i - 1);
                double x1 = p1.getX() * pdx;
                double y1 = p1.getY() * pdy;
                double x0 = p0.getX() * pdx;
                double y0 = p0.getY() * pdy;
                double dx = x1 - x0;
                double dy = y1 - y0;
                double l = Math.sqrt(dx * dx + dy * dy);
                len += l;
            }
        }
        return len;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int i;
        s.defaultWriteObject();
        if (this.points != null && this.points.size() > 0) {
            s.writeInt(this.points.size());
            for (i = 0; i < this.points.size(); ++i) {
                s.writeDouble(((Point2D)this.points.get(i)).getX());
                s.writeDouble(((Point2D)this.points.get(i)).getY());
            }
        }
        s.writeInt(this.approxPts.size());
        for (i = 0; i < this.approxPts.size(); ++i) {
            s.writeDouble(((Point2D)this.approxPts.get(i)).getX());
            s.writeDouble(((Point2D)this.approxPts.get(i)).getY());
        }
        s.writeBoolean(this.isVisible());
        s.writeObject(this.getRoiLabel());
        s.writeObject(this.getColor());
    }

    private void readObject(ObjectInputStream s) throws IOException {
        try {
            int i;
            s.defaultReadObject();
            int size = s.readInt();
            ArrayList ds_points = new ArrayList();
            ArrayList ds_txpoints = new ArrayList();
            ArrayList<Point2D.Double> ds_approxPts = new ArrayList<Point2D.Double>();
            Point2D[] pts = new Point2D[size];
            for (i = 0; i < size; ++i) {
                double x = s.readDouble();
                double y = s.readDouble();
                pts[i] = new Point2D.Double(x, y);
            }
            size = s.readInt();
            for (i = 0; i < size; ++i) {
                ds_approxPts.add(new Point2D.Double(s.readDouble(), s.readDouble()));
            }
            this.points = ds_points;
            this.txpoints = ds_txpoints;
            this.approxPts = ds_approxPts;
            this.drawPolygon = new GeneralPath();
            this.tmpPoint1 = new Point2D.Double();
            this.tmpPoint2 = new Point2D.Double();
            this.containsTemp = new Point2D.Double();
            this.clipPt = new Point2D.Double();
            this.accumPoint = new Point2D.Double();
            this.firstPtOffset = new Point2D.Double();
            RoiShapeModel rsm = new RoiShapeModel(new GeneralPath());
            boolean visibility = s.readBoolean();
            String roiLabel = (String)s.readObject();
            Color color = (Color)s.readObject();
            rsm.setVisible(visibility);
            rsm.setRoiLabel(roiLabel);
            rsm.setColor(color);
            this.setRoiShapeModel(rsm);
            this.init(pts, true, true);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    static {
        String ls = XpPropertiesManager.getProperty("jami.roi.polygon.linesensitivity");
        int ils = 4;
        if (ls != null && (ils = Integer.parseInt(ls)) <= 0) {
            ils = 4;
        }
        LINE_SENSITIVITY = ils;
    }

    private static class PolygonComponentCreator
    extends XpRoiComponentCreator {
        private XpPolygonRoi pm = null;
        private int nSegments = -1;
        private int segments = 0;

        public PolygonComponentCreator(int nSegments) {
            this.nSegments = nSegments;
        }

        public PolygonComponentCreator() {
        }

        @Override
        public RoiActor getRoiActor(double x, double y) {
            Point2D[] pts = new Point2D[]{new Point2D.Double(x - 1.0, y), new Point2D.Double(x, y)};
            this.pm = new XpPolygonRoi(pts);
            this.segments = 1;
            return this.pm;
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            XpVisualComponent jc = (XpVisualComponent)me.getSource();
            int modifiers = me.getModifiers();
            int mbutton1 = modifiers & 0x10;
            int mbutton2 = modifiers & 8;
            int x = me.getX();
            int y = me.getY();
            if (mbutton1 != 0 && this.pm != null) {
                int nPts = this.pm.getNumPoints();
                Point2D p = this.pm.getPoint(nPts - 1);
                CPoint img_pt = this.getImgPt(jc, x, y);
                double xx = img_pt.x;
                double yy = img_pt.y;
                p.setLocation(xx, yy);
                this.pm.generateDrawPolygon();
                this.pm.syncModel();
                jc.repaint();
            }
        }

        @Override
        public void mouseClicked(MouseEvent me) {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            XpVisualComponent vc = (XpVisualComponent)me.getSource();
            int modifiers = me.getModifiers();
            int mbutton1 = modifiers & 0x10;
            int mbutton2 = modifiers & 8;
            int x = me.getX();
            int y = me.getY();
            if (mbutton1 != 0) {
                if (this.pm == null) {
                    this.dropRoi(me);
                } else if (this.nSegments == -1 || this.segments < this.nSegments) {
                    CPoint img_pt = this.getImgPt(vc, x, y);
                    int xx = (int)img_pt.x;
                    int yy = (int)img_pt.y;
                    this.pm.addPoint(new Point2D.Double(xx, yy));
                    ++this.segments;
                    this.pm.setSelected(true);
                }
                vc.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            XpVisualComponent jc = (XpVisualComponent)me.getSource();
            int modifiers = me.getModifiers();
            int mbutton1 = modifiers & 0x10;
            int mbutton2 = modifiers & 8;
            int x = me.getX();
            int y = me.getY();
            if (this.pm != null) {
                this.pm.generateDrawPolygon();
                jc.repaint();
                if (mbutton1 == 0 || mbutton1 != 0 && this.segments == this.nSegments) {
                    if (!this.isPerpetual()) {
                        ComponentCapable cc = this.getComponentCapable(jc);
                        this.shutdown(cc);
                    } else {
                        this.pm = null;
                        this.segments = 0;
                    }
                }
            }
        }
    }
}

