/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.roi;

import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.GSPSGraphic;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpAnchorable;
import com.ge.med.terra.jami.XpHandle;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.capable.TooltipCapable;
import com.ge.med.terra.jami.capable.Visible;
import com.ge.med.terra.jami.roi.XpRoiEventListener;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Vector;
import javax.swing.event.MouseInputListener;

public class XpRoiHandleContainer
implements RoiActor,
XpAnchorable,
Visible,
TooltipCapable {
    public static final int SHOW_HANDLES_ALLWAYS_POLICY = 0;
    public static final int SHOW_HANDLES_ONLYSELECTED_POLICY = 1;
    private boolean visible = true;
    private int handlePolicy = 1;
    private Vector handles = new Vector();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private String tip = "";
    MouseInputListener listener = new MouseInputListener(){
        XpHandle clickHandle;
        XpHandle enteredHandle;
        boolean clickROI = false;
        boolean enteredROI = false;

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.clickHandle != null) {
                this.clickHandle.handleClicked(e);
            } else if (this.clickROI) {
                XpRoiHandleContainer.this.roiClicked(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.clickHandle != null) {
                return;
            }
            this.clickHandle = XpRoiHandleContainer.this.whichHandle((XpVisualComponent)e.getSource(), e.getX(), e.getY());
            if (this.clickHandle != null && this.clickHandle.buttonTrigger(e)) {
                this.clickHandle.handlePressed(e);
            } else if (XpRoiHandleContainer.this.containsROI((XpVisualComponent)e.getSource(), e.getX(), e.getY())) {
                this.clickROI = true;
                XpRoiHandleContainer.this.roiPressed(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.clickHandle != null) {
                this.clickHandle.handleReleased(e);
            } else if (this.clickROI) {
                XpRoiHandleContainer.this.roiReleased(e);
            }
            this.clickHandle = null;
            this.clickROI = false;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (this.enteredHandle != null) {
                return;
            }
            this.enteredHandle = XpRoiHandleContainer.this.whichHandle((XpVisualComponent)e.getSource(), e.getX(), e.getY());
            if (this.enteredHandle != null) {
                this.enteredHandle.handleEntered(e);
                this.enteredROI = false;
            } else if (XpRoiHandleContainer.this.containsROI((XpVisualComponent)e.getSource(), e.getX(), e.getY())) {
                this.enteredROI = true;
                XpRoiHandleContainer.this.roiEntered(e);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (this.enteredHandle != null) {
                this.enteredHandle.handleExited(e);
                this.enteredHandle = null;
            } else if (this.enteredROI) {
                XpRoiHandleContainer.this.roiExited(e);
                this.enteredROI = false;
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.clickHandle != null) {
                this.clickHandle.handleDragged(e);
            } else if (this.clickROI) {
                XpRoiHandleContainer.this.roiDragged(e);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            XpHandle tmp = XpRoiHandleContainer.this.whichHandle((XpVisualComponent)e.getSource(), e.getX(), e.getY());
            if (tmp != this.enteredHandle) {
                this.mouseExited(e);
                this.mouseEntered(e);
            } else if (tmp != null) {
                tmp.handleMove(e);
            } else {
                XpRoiHandleContainer.this.roiMove(e);
            }
        }
    };

    public XpHandle get(int index) {
        return (XpHandle)this.handles.get(index);
    }

    public int getNumHandles() {
        return this.handles.size();
    }

    public void add(XpHandle h) {
        this.handles.add(h);
    }

    public void remove(XpHandle h) {
        this.handles.remove(h);
    }

    public void add(int idx, XpHandle h) {
        this.handles.add(idx, h);
    }

    public void clearHandles() {
        this.handles.clear();
    }

    @Override
    public void setToolTipText(String text) {
        this.tip = text;
    }

    @Override
    public String getToolTipText() {
        return this.tip;
    }

    public final int getHandlePolicy() {
        return this.handlePolicy;
    }

    public final void setHandlePolicy(int handlePolicy) {
        this.handlePolicy = handlePolicy;
    }

    protected void copyObject(Object o) {
        XpRoiHandleContainer rhc = (XpRoiHandleContainer)o;
        int len = this.handles.size();
        for (int i = 0; i < len; ++i) {
            XpHandle nh = rhc.get(i);
            XpHandle h = this.get(i);
            nh.setLocation(h.getX(), h.getY());
        }
    }

    @Override
    public MouseInputListener getMouseInputListener() {
        return this.listener;
    }

    @Override
    public void setSelected(boolean selection) {
    }

    @Override
    public boolean isSelected() {
        return false;
    }

    @Override
    public void anchorDragged(MouseEvent e, CPoint drag, Object source) {
    }

    @Override
    public void anchorPressed(MouseEvent e, Object source) {
    }

    @Override
    public void anchorReleased(MouseEvent e, Object source) {
    }

    @Override
    public void paintRoi(XpVisualComponent vc, Graphics2D g) {
        block2: {
            block3: {
                if (!this.visible) break block2;
                this.paintShape(vc, g);
                if (this.isSelected()) break block3;
                if (this.handlePolicy != 0) break block2;
            }
            this.paintHandles(vc, g);
        }
    }

    public void paintShape(XpVisualComponent vc, Graphics2D g) {
    }

    public void paintHandles(XpVisualComponent vc, Graphics2D g) {
        int n = this.handles.size();
        for (int i = 0; i < n; ++i) {
            XpHandle h = (XpHandle)this.handles.get(i);
            h.paintHandle(vc, g);
        }
    }

    @Override
    public boolean contains(XpVisualComponent vc, int x, int y) {
        if (this.visible) {
            if (this.containsHandles(vc, x, y)) {
                return true;
            }
            return this.containsROI(vc, x, y);
        }
        return false;
    }

    public boolean containsHandles(XpVisualComponent vc, int x, int y) {
        block4: {
            block3: {
                if (this.isSelected()) break block3;
                if (this.handlePolicy != 0) break block4;
            }
            int n = this.handles.size();
            for (int i = 0; i < n; ++i) {
                XpHandle h = (XpHandle)this.handles.get(i);
                if (!h.contains(vc, x, y)) continue;
                return true;
            }
        }
        return false;
    }

    private XpHandle whichHandle(XpVisualComponent vc, int x, int y) {
        block4: {
            block3: {
                if (this.isSelected()) break block3;
                if (this.handlePolicy != 0) break block4;
            }
            int n = this.handles.size();
            for (int i = 0; i < n; ++i) {
                XpHandle h = (XpHandle)this.handles.get(i);
                if (!h.contains(vc, x, y)) continue;
                return h;
            }
        }
        return null;
    }

    public boolean containsROI(XpVisualComponent vc, int x, int y) {
        return false;
    }

    @Override
    public void setImage(XpImage image) {
    }

    @Override
    public XpImage getImage() {
        return null;
    }

    @Override
    public void removePropertyChangeListener(String propName, PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(propName, pcl);
    }

    @Override
    public void addPropertyChangeListener(String propName, PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(propName, pcl);
    }

    protected final void firePropertyChange(String property, Object value) {
        PropertyChangeEvent e = new PropertyChangeEvent(this, property, null, value);
        this.pcs.firePropertyChange(e);
    }

    @Override
    public GSPSGraphic gspsDescription() {
        return null;
    }

    @Override
    public void addRoiEventListener(XpRoiEventListener rel) {
    }

    @Override
    public void removeRoiEventListener(XpRoiEventListener rel) {
    }

    public void roiDragged(MouseEvent e) {
    }

    public void roiMove(MouseEvent e) {
    }

    public void roiClicked(MouseEvent e) {
    }

    public void roiEntered(MouseEvent e) {
    }

    public void roiExited(MouseEvent e) {
    }

    public void roiPressed(MouseEvent e) {
    }

    public void roiReleased(MouseEvent e) {
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
        this.firePropertyChange("ROI_MODEL", this);
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    protected static class GraphicDescriptor
    implements GSPSGraphic {
        private String gtype = "POINT";
        private boolean filled = false;
        private Point2D[] pts = null;

        public GraphicDescriptor(String gtype, Point2D[] pts) {
            this.gtype = gtype;
            this.pts = pts;
        }

        public GraphicDescriptor(String gtype, Point2D[] pts, boolean filled) {
            this(gtype, pts);
            this.filled = filled;
        }

        @Override
        public final String getGraphicType() {
            return this.gtype;
        }

        @Override
        public final Point2D[] getPoints() {
            return this.pts;
        }

        @Override
        public boolean isGraphicFilled() {
            return this.filled;
        }
    }
}

