/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.roi.aw;

import com.ge.med.idc.ComponentCreator;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.GSPSGraphic;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpAnchorable;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpHandle;
import com.ge.med.terra.jami.XpHandleVc;
import com.ge.med.terra.jami.XpPixelStatistics;
import com.ge.med.terra.jami.XpPropertiesManager;
import com.ge.med.terra.jami.XpRoiComponentCreator;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.roi.RoiShapeModel;
import com.ge.med.terra.jami.roi.XpRoiHandleContainer;
import com.ge.med.terra.jami.roi.XpStatisticsRoi;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class XpANTEVRoi
extends XpStatisticsRoi
implements Cloneable,
Serializable {
    private static final String DEG_SYMBOL = new String(new char[]{'\u00b0'});
    private static int LINE_SENSITIVITY = 10;
    private transient GeneralPath polygon = null;
    private transient GeneralPath drawPolygon = new GeneralPath();
    private transient List points = new ArrayList();
    private transient List txpoints = new ArrayList();
    private transient Point2D tmpPoint1 = new Point2D.Double();
    private transient Point2D tmpPoint2 = new Point2D.Double();
    private transient Point2D containsTemp = new Point2D.Double();
    private transient Point2D clipPt = new Point2D.Double();
    private transient List approxPts = new ArrayList();
    private double minX = 0.0;
    private double maxX = 0.0;
    private double minY = 0.0;
    private double maxY = 0.0;
    private double minX1 = 0.0;
    private double maxX1 = 0.0;
    private double minY1 = 0.0;
    private double maxY1 = 0.0;
    private transient Point2D accumPoint = new Point2D.Double();
    private transient Point2D firstPtOffset = new Point2D.Double();
    private boolean closed = false;
    private boolean idealMetrics = true;
    private boolean doHandles = true;
    double _centerX = 0.0;
    double _centerY = 0.0;
    public static int ARROWLENGTH;
    public static int ARROWHALFWIDTH;

    public XpANTEVRoi(Point2D[] pts) {
        super(new GeneralPath());
        this.init(pts, false, true);
    }

    public XpANTEVRoi(Point2D[] pts, boolean calcPixelStatistics) {
        super(new GeneralPath());
        this.init(pts, calcPixelStatistics, true);
    }

    public XpANTEVRoi(Point2D[] pts, boolean calcPixelStatistics, boolean doHandles) {
        super(new GeneralPath());
        this.init(pts, calcPixelStatistics, doHandles);
    }

    private void init(Point2D[] pts, boolean pixStats, boolean doHandles) {
        this.polygon = (GeneralPath)this.getModelShape();
        this.setCalcPixelStats(pixStats);
        this.doHandles = doHandles;
        if (pts != null && pts.length > 0 && pts.length == 4) {
            for (int i = 0; i < pts.length; ++i) {
                this.points.add(pts[i]);
                this.txpoints.add(new Point2D.Double());
                XpHandle handle = new XpHandle((XpAnchorable)this, i, 16);
                handle.setFilled(false);
                this.add(handle);
            }
        } else {
            System.out.println("Need four Points for creation ====>");
            return;
        }
        XpHandle handle = new XpHandle((XpAnchorable)this, 4, 16);
        handle.setFilled(false);
        handle.setShape(XpHandle.HANDLE_CROSSHAIR, XpHandle.HANDLE_BOX);
        this.points.add(new Point2D.Double(this._centerX, this._centerY));
        this.txpoints.add(new Point2D.Double());
        this.add(handle);
        this.calculateCenter();
        this.generateModelPolygon();
    }

    @Override
    public Object clone() {
        int len = this.points.size();
        Point2D[] ptarray = new Point2D[len];
        for (int i = 0; i < len; ++i) {
            Point2D thept = (Point2D)this.points.get(i);
            ptarray[i] = (Point2D)thept.clone();
        }
        XpANTEVRoi ccr = new XpANTEVRoi(ptarray);
        this.copyObject(ccr);
        return ccr;
    }

    @Override
    protected void copyObject(Object o) {
        XpANTEVRoi pr = (XpANTEVRoi)o;
        super.copyObject(pr);
        pr.closed = this.closed;
        pr.idealMetrics = this.idealMetrics;
        pr.doHandles = this.doHandles;
    }

    @Override
    public final Shape getDrawShape() {
        this.generateDrawPolygon();
        return this.drawPolygon;
    }

    @Override
    public final String createRoiStatLabel(XpPixelStatistics ps) {
        double angle;
        String roiStat = this.getRoiLabel() + ": ";
        double pixelSizeX = this.getImage().getPixelDimensionX();
        double pixelSizeY = this.getImage().getPixelDimensionY();
        Point2D p1 = (Point2D)this.points.get(0);
        Point2D p2 = (Point2D)this.points.get(1);
        Point2D p3 = (Point2D)this.points.get(2);
        Point2D p4 = (Point2D)this.points.get(3);
        double dx = (p1.getX() - p2.getX()) * pixelSizeX;
        double dy = (p1.getY() - p2.getY()) * pixelSizeY;
        double dx1 = (p4.getX() - p3.getX()) * pixelSizeX;
        double dy1 = (p4.getY() - p3.getY()) * pixelSizeY;
        double angle1 = Math.atan2(dy, dx) * 180.0 / Math.PI;
        double angle2 = Math.atan2(dy1, dx1) * 180.0 / Math.PI;
        if (angle1 > 180.0) {
            angle1 = 360.0 - angle1;
        }
        if (angle2 > 180.0) {
            angle2 = 360.0 - angle2;
        }
        if ((angle = angle1 - angle2) < 0.0) {
            angle = -angle;
        }
        if (angle > 180.0) {
            angle = 360.0 - angle;
        }
        if (angle > 90.0) {
            angle = 180.0 - angle;
        }
        if (angle < 0.0) {
            angle = -angle;
        }
        roiStat = roiStat + "angle " + this.statFormat(angle) + DEG_SYMBOL;
        return roiStat;
    }

    public double getStats() {
        double angle;
        double pixelSizeX = this.getImage().getPixelDimensionX();
        double pixelSizeY = this.getImage().getPixelDimensionY();
        Point2D p1 = (Point2D)this.points.get(0);
        Point2D p2 = (Point2D)this.points.get(1);
        Point2D p3 = (Point2D)this.points.get(2);
        Point2D p4 = (Point2D)this.points.get(3);
        double dx = (p1.getX() - p2.getX()) * pixelSizeX;
        double dy = (p1.getY() - p2.getY()) * pixelSizeY;
        double dx1 = (p4.getX() - p3.getX()) * pixelSizeX;
        double dy1 = (p4.getY() - p3.getY()) * pixelSizeY;
        double angle1 = Math.atan2(dy, dx) * 180.0 / Math.PI;
        double angle2 = Math.atan2(dy1, dx1) * 180.0 / Math.PI;
        if (angle1 > 180.0) {
            angle1 = 360.0 - angle1;
        }
        if (angle2 > 180.0) {
            angle2 = 360.0 - angle2;
        }
        if ((angle = angle1 - angle2) < 0.0) {
            angle = -angle;
        }
        if (angle > 180.0) {
            angle = 360.0 - angle;
        }
        if (angle > 90.0) {
            angle = 180.0 - angle;
        }
        if (angle < 0.0) {
            angle = -angle;
        }
        return angle;
    }

    @Override
    public final void render(XpVisualComponent vc, Graphics2D g) {
        super.render(vc, g);
        g.setColor(XpHandleVc.getHandleColor());
        this.drawRoiId(g, this.firstPtOffset.getX(), this.firstPtOffset.getY());
    }

    public final Point2D getPoint(int i) {
        return (Point2D)this.points.get(i);
    }

    public final int getNumPoints() {
        return this.points.size();
    }

    private final void generateModelPolygon() {
        this.polygon.reset();
        this.approxPts.clear();
        int nPts = this.points.size();
        if (nPts > 0) {
            Point2D p;
            Point2D prev = p = (Point2D)this.points.get(0);
            this.approxPts.add(p);
            float x = (float)p.getX();
            float y = (float)p.getY();
            this.polygon.moveTo(x, y);
            for (int i = 1; i < nPts; ++i) {
                p = (Point2D)this.points.get(i);
                x = (float)p.getX();
                y = (float)p.getY();
                this.polygon.lineTo(x, y);
                double distance = p.distanceSq(prev);
                if (!(distance > 6.0) && nPts >= 100) continue;
                this.approxPts.add(p);
                prev = p;
            }
            if (this.closed && nPts > 2) {
                this.polygon.closePath();
            }
        }
    }

    @Override
    public void roiDragged(MouseEvent e) {
        super.roiDragged(e);
        this.calculateCenter();
    }

    public void calculateCenter() {
        Point2D c1 = new Point2D.Double(0.0, 0.0);
        Point2D c2 = new Point2D.Double(0.0, 0.0);
        Point2D c3 = new Point2D.Double(0.0, 0.0);
        Point2D c4 = new Point2D.Double(0.0, 0.0);
        c1 = (Point2D)this.points.get(0);
        c2 = (Point2D)this.points.get(1);
        c3 = (Point2D)this.points.get(2);
        c4 = (Point2D)this.points.get(3);
        double _centerX1 = (c1.getX() + c2.getX()) / 2.0;
        double _centerY1 = (c1.getY() + c2.getY()) / 2.0;
        double _centerX2 = (c3.getX() + c4.getX()) / 2.0;
        double _centerY2 = (c3.getY() + c4.getY()) / 2.0;
        this._centerX = (_centerX1 + _centerX2) / 2.0;
        this._centerY = (_centerY1 + _centerY2) / 2.0;
        ((Point2D)this.points.get(4)).setLocation(this._centerX, this._centerY);
    }

    private final void generateDrawPolygon() {
        this.polygon.reset();
        this.drawPolygon.reset();
        int nPts = this.points.size();
        if (nPts > 0) {
            Point2D p = (Point2D)this.points.get(0);
            float x = (float)p.getX();
            float y = (float)p.getY();
            this.getDisplayPoint(p, this.tmpPoint1);
            float t_x = (float)this.tmpPoint1.getX();
            float t_y = (float)this.tmpPoint1.getY();
            this.polygon.moveTo(x, y);
            this.drawPolygon.moveTo(t_x, t_y);
            this.firstPtOffset.setLocation(t_x + 4.0f, t_y - 2.0f);
            this.minX = this.maxX = (double)x;
            this.minY = this.maxY = (double)y;
            p = (Point2D)this.points.get(1);
            x = (float)p.getX();
            y = (float)p.getY();
            this.getDisplayPoint(p, this.tmpPoint1);
            t_x = (float)this.tmpPoint1.getX();
            t_y = (float)this.tmpPoint1.getY();
            this.polygon.lineTo(x, y);
            this.drawPolygon.lineTo(t_x, t_y);
            if ((double)x < this.minX) {
                this.minX = x;
            }
            if ((double)x > this.maxX) {
                this.maxX = x;
            }
            if ((double)y < this.minY) {
                this.minY = y;
            }
            if ((double)y > this.maxY) {
                this.maxY = y;
            }
            p = (Point2D)this.points.get(2);
            x = (float)p.getX();
            y = (float)p.getY();
            this.getDisplayPoint(p, this.tmpPoint1);
            t_x = (float)this.tmpPoint1.getX();
            t_y = (float)this.tmpPoint1.getY();
            this.polygon.moveTo(x, y);
            this.drawPolygon.moveTo(t_x, t_y);
            this.minX1 = this.maxX1 = (double)x;
            this.minY1 = this.maxY1 = (double)y;
            p = (Point2D)this.points.get(3);
            x = (float)p.getX();
            y = (float)p.getY();
            this.getDisplayPoint(p, this.tmpPoint1);
            t_x = (float)this.tmpPoint1.getX();
            t_y = (float)this.tmpPoint1.getY();
            this.polygon.lineTo(x, y);
            this.drawPolygon.lineTo(t_x, t_y);
            if ((double)x < this.minX1) {
                this.minX1 = x;
            }
            if ((double)x > this.maxX1) {
                this.maxX1 = x;
            }
            if ((double)y < this.minY1) {
                this.minY1 = y;
            }
            if ((double)y > this.maxY1) {
                this.maxY1 = y;
            }
            if (this.closed && nPts > 2) {
                this.polygon.closePath();
                this.drawPolygon.closePath();
            }
        }
    }

    @Override
    public void anchorPressed(MouseEvent e, Object source) {
        super.anchorPressed(e, source);
        XpHandle xph = (XpHandle)source;
        int i = xph.getAnchorPointIndex();
        Point2D p = (Point2D)this.points.get(i);
        this.accumPoint.setLocation(p);
    }

    @Override
    public void anchorDragged(MouseEvent e, CPoint drag, Object source) {
        super.anchorDragged(e, drag, source);
        XpHandle xph = (XpHandle)source;
        int i = xph.getAnchorPointIndex();
        Point2D p = (Point2D)this.points.get(i);
        this.accumPoint.setLocation(this.accumPoint.getX() + drag.x, this.accumPoint.getY() + drag.y);
        double x = this.accumPoint.getX();
        double y = this.accumPoint.getY();
        this.clipPoint(x, y, this.clipPt);
        if (x == this.clipPt.getX() && y == this.clipPt.getY()) {
            p.setLocation(this.clipPt);
            if (i == 4) {
                Point2D p1 = (Point2D)this.points.get(0);
                Point2D p2 = (Point2D)this.points.get(1);
                Point2D p3 = (Point2D)this.points.get(2);
                Point2D p4 = (Point2D)this.points.get(3);
                p1.setLocation(p1.getX() + drag.x, p1.getY() + drag.y);
                p2.setLocation(p2.getX() + drag.x, p2.getY() + drag.y);
                p3.setLocation(p3.getX() + drag.x, p3.getY() + drag.y);
                p4.setLocation(p4.getX() + drag.x, p4.getY() + drag.y);
            }
        }
        if (i != 4) {
            this.calculateCenter();
        }
        this.syncModel();
    }

    @Override
    public boolean containsROI(XpVisualComponent vc, int x, int y) {
        this.getImagePoint(x, y, this.containsTemp);
        double xx = this.containsTemp.getX();
        double yy = this.containsTemp.getY();
        if (xx > this.minX && xx < this.maxX && yy > this.minY && yy < this.maxY) {
            Point2D first;
            Point2D prev = first = (Point2D)this.approxPts.get(0);
            int len = this.approxPts.size();
            for (int i = 1; i < len - 2; ++i) {
                Point2D p = (Point2D)this.approxPts.get(i);
                if (XpGeomUtils.containsCoord((int)xx, (int)yy, prev, p, LINE_SENSITIVITY)) {
                    return true;
                }
                prev = p;
            }
            if (this.closed && XpGeomUtils.containsCoord((int)xx, (int)yy, prev, first, LINE_SENSITIVITY)) {
                return true;
            }
        } else if (xx > this.minX1 && xx < this.maxX1 && yy > this.minY1 && yy < this.maxY1) {
            Point2D first;
            Point2D prev = first = (Point2D)this.approxPts.get(2);
            int len = this.approxPts.size();
            for (int i = 2; i < len; ++i) {
                Point2D p = (Point2D)this.approxPts.get(i);
                if (XpGeomUtils.containsCoord((int)xx, (int)yy, prev, p, LINE_SENSITIVITY)) {
                    return true;
                }
                prev = p;
            }
            if (this.closed && XpGeomUtils.containsCoord((int)xx, (int)yy, prev, first, LINE_SENSITIVITY)) {
                return true;
            }
        }
        return false;
    }

    public static ComponentCreator getComponentCreator(int ccid) {
        if (ccid == 0) {
            return new XpANTEVComponentCreator();
        }
        return null;
    }

    private void translate(double tx, double ty) {
        Point2D txp;
        Point2D p;
        int i;
        int len = this.points.size();
        boolean dotranslate = true;
        for (i = 0; i < len; ++i) {
            p = (Point2D)this.points.get(i);
            txp = (Point2D)this.txpoints.get(i);
            double x = p.getX() + tx;
            double y = p.getY() + ty;
            this.clipPoint(x, y, this.clipPt);
            double cx = this.clipPt.getX();
            double cy = this.clipPt.getY();
            if ((x != cx || y != cy) && this.isClipRoi()) {
                dotranslate = false;
                break;
            }
            txp.setLocation(cx, cy);
        }
        if (dotranslate) {
            for (i = 0; i < len; ++i) {
                p = (Point2D)this.points.get(i);
                txp = (Point2D)this.txpoints.get(i);
                p.setLocation(txp);
            }
            this.generateDrawPolygon();
        }
    }

    @Override
    protected final void dragMouse(CPoint drag) {
        this.translate(drag.x, drag.y);
        this.syncModel();
    }

    @Override
    protected void updateHandles() {
        int len = this.points.size();
        for (int i = 0; i < len; ++i) {
            XpHandle h = this.get(i);
            Point2D p = (Point2D)this.points.get(i);
            h.setLocation(p);
        }
    }

    public final boolean isClosed() {
        return this.closed;
    }

    public final void setClosed(boolean closed) {
        this.closed = closed;
    }

    @Override
    public GSPSGraphic gspsDescription() {
        int len = this.points.size();
        Point2D[] pts = new Point2D[len];
        for (int i = 0; i < len; ++i) {
            Point2D p = (Point2D)this.points.get(i);
            pts[i] = new Point2D.Double(p.getX(), p.getY());
        }
        XpRoiHandleContainer.GraphicDescriptor description = new XpRoiHandleContainer.GraphicDescriptor("POLYLINE", pts);
        return description;
    }

    public void setIdealMetrics(boolean idealMetric) {
        this.idealMetrics = idealMetric;
    }

    public boolean isIdealMetrics() {
        return this.idealMetrics;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int i;
        s.defaultWriteObject();
        if (this.points != null && this.points.size() > 0) {
            s.writeInt(this.points.size());
            for (i = 0; i < this.points.size(); ++i) {
                s.writeDouble(((Point2D)this.points.get(i)).getX());
                s.writeDouble(((Point2D)this.points.get(i)).getY());
            }
        }
        s.writeInt(this.approxPts.size());
        for (i = 0; i < this.approxPts.size(); ++i) {
            s.writeDouble(((Point2D)this.approxPts.get(i)).getX());
            s.writeDouble(((Point2D)this.approxPts.get(i)).getY());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException {
        try {
            int i;
            s.defaultReadObject();
            int size = s.readInt();
            ArrayList ds_points = new ArrayList();
            ArrayList ds_txpoints = new ArrayList();
            ArrayList<Point2D.Double> ds_approxPts = new ArrayList<Point2D.Double>();
            Point2D[] pts = new Point2D[size];
            for (i = 0; i < size; ++i) {
                double x = s.readDouble();
                double y = s.readDouble();
                pts[i] = new Point2D.Double(x, y);
            }
            size = s.readInt();
            for (i = 0; i < size; ++i) {
                ds_approxPts.add(new Point2D.Double(s.readDouble(), s.readDouble()));
            }
            this.points = ds_points;
            this.txpoints = ds_txpoints;
            this.approxPts = ds_approxPts;
            this.drawPolygon = new GeneralPath();
            this.tmpPoint1 = new Point2D.Double();
            this.tmpPoint2 = new Point2D.Double();
            this.containsTemp = new Point2D.Double();
            this.clipPt = new Point2D.Double();
            this.accumPoint = new Point2D.Double();
            this.firstPtOffset = new Point2D.Double();
            this.setRoiShapeModel(new RoiShapeModel(new GeneralPath()));
            this.init(pts, true, true);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    static {
        String ls = XpPropertiesManager.getProperty("jami.roi.polygon.linesensitivity");
        int ils = 4;
        if (ls != null && (ils = Integer.parseInt(ls)) <= 0) {
            ils = 4;
        }
        LINE_SENSITIVITY = ils;
        ARROWLENGTH = 8;
        ARROWHALFWIDTH = 4;
    }

    private static class XpANTEVComponentCreator
    extends XpRoiComponentCreator {
        private XpANTEVComponentCreator() {
        }

        @Override
        public RoiActor getRoiActor(double x, double y) {
            Point2D[] pts2 = new Point2D[]{new Point2D.Double(x, y), new Point2D.Double(x + 30.0, y), new Point2D.Double(x, y + 30.0), new Point2D.Double(x + 30.0, y + 32.0)};
            XpANTEVRoi antev = new XpANTEVRoi(pts2);
            return antev;
        }
    }
}

