/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.roi.aw;

import com.ge.med.idc.ComponentCreator;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpAnchorable;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpHandle;
import com.ge.med.terra.jami.roi.XpRectangularRoi;
import com.ge.med.terra.jami.roi.aw.XpAwRectangle;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;

public class XpAwEllipse
extends XpRectangularRoi.Ellipse {
    private int centerHandleId = this.getNumHandles();
    private XpHandle centerHandle = new XpHandle((XpAnchorable)this, this.centerHandleId, 16);
    private static final double EPSILON = 1.0E-4;

    public XpAwEllipse(Ellipse2D e) {
        super(e);
        XpHandle.setHandleColor(Color.CYAN);
        this.add(this.centerHandle);
        double hx = e.getX() + e.getWidth() * 0.5;
        double hy = e.getY() + e.getHeight() * 0.5;
        this.centerHandle.setLocation(hx, hy);
    }

    @Override
    public void anchorPressed(MouseEvent e, Object jc) {
        int noHandles = this.getNumHandles();
        for (int i = 0; i < noHandles - 1; ++i) {
            this.getHandle(i).setVisible(false);
        }
        this.centerHandle.setVisible(false);
        super.anchorPressed(e, jc);
        XpHandle xph = (XpHandle)jc;
        int handleIdx = xph.getAnchorPointIndex();
        if (handleIdx == this.centerHandleId) {
            super.roiPressed(e);
        }
    }

    @Override
    public void anchorReleased(MouseEvent e, Object jc) {
        int noHandles = this.getNumHandles();
        for (int i = 0; i < noHandles - 1; ++i) {
            this.getHandle(i).setVisible(true);
        }
        this.centerHandle.setVisible(true);
        this.sync();
        super.anchorReleased(e, jc);
    }

    @Override
    public void anchorDragged(MouseEvent e, CPoint drag, Object jc) {
        XpHandle xph = (XpHandle)jc;
        int handleIdx = xph.getAnchorPointIndex();
        if (handleIdx == this.centerHandleId) {
            super.roiDragged(e);
            RectangularShape r = (RectangularShape)this.getModelShape();
            double hx = r.getX() + r.getWidth() * 0.5;
            double hy = r.getY() + r.getHeight() * 0.5;
            this.centerHandle.setLocation(hx, hy);
            this.syncModel();
        } else {
            super.anchorDragged(e, drag, jc);
        }
    }

    @Override
    public void roiDragged(MouseEvent e) {
        super.roiDragged(e);
        RectangularShape r = (RectangularShape)this.getModelShape();
        double hx = r.getX() + r.getWidth() * 0.5;
        double hy = r.getY() + r.getHeight() * 0.5;
        this.centerHandle.setLocation(hx, hy);
        this.syncModel();
    }

    public static ComponentCreator getComponentCreator(int ccid) {
        if (ccid == 0) {
            return new AwEllipseCreator();
        }
        return null;
    }

    private static List<Point2D> dupPointList(List<Point2D> data) {
        ArrayList<Point2D> dupdata = new ArrayList<Point2D>();
        for (int i = 0; i < data.size(); ++i) {
            Point2D p = data.get(i);
            Point2D.Double np = new Point2D.Double();
            np.setLocation(p);
            dupdata.add(np);
        }
        return dupdata;
    }

    public static final XpAwEllipse createRoiActor(List<Point2D> gdata, boolean filled, byte csystem) {
        List<Point2D> rgdata = XpAwEllipse.dupPointList(gdata);
        double ulX = Double.MAX_VALUE;
        double ulY = Double.MAX_VALUE;
        double brX = Double.MIN_VALUE;
        double brY = Double.MIN_VALUE;
        Point2D p1 = rgdata.get(0);
        Point2D p2 = rgdata.get(1);
        Point2D p3 = rgdata.get(2);
        Point2D p4 = rgdata.get(3);
        double cx = (p1.getX() + p2.getX() + p3.getX() + p4.getX()) / 4.0;
        double cy = (p1.getY() + p2.getY() + p3.getY() + p4.getY()) / 4.0;
        double num = p1.getY() - p2.getY();
        double denom = p2.getX() - p1.getX();
        if (Math.abs(denom) > 1.0E-4 || Math.abs(num) > 1.0E-4) {
            double angle = 0.0;
            if (Math.abs(denom) > 1.0E-4) {
                angle = Math.atan(num / denom);
            }
            XpGeomUtils gu = new XpGeomUtils();
            gu.getRotatedPoint(p1.getX(), p1.getY(), angle, cx, cy, p1);
            gu.getRotatedPoint(p2.getX(), p2.getY(), angle, cx, cy, p2);
            gu.getRotatedPoint(p3.getX(), p3.getY(), angle, cx, cy, p3);
            gu.getRotatedPoint(p4.getX(), p4.getY(), angle, cx, cy, p4);
            for (int i = 0; i < rgdata.size(); ++i) {
                Point2D p = rgdata.get(i);
                double x = p.getX();
                double y = p.getY();
                if (x < ulX) {
                    ulX = x;
                }
                if (x > brX) {
                    brX = x;
                }
                if (y < ulY) {
                    ulY = y;
                }
                if (!(y > brY)) continue;
                brY = y;
            }
            double w = Math.abs(ulX - brX);
            double h = Math.abs(ulY - brY);
            Ellipse2D.Double e = new Ellipse2D.Double(ulX, ulY, w, h);
            XpAwEllipse rr = new XpAwEllipse(e);
            rr.setAngle(angle);
            return rr;
        }
        return null;
    }

    private static class AwEllipseCreator
    extends XpAwRectangle.RectComponentCreator {
        private AwEllipseCreator() {
        }

        @Override
        public RoiActor getRoiActor(double x, double y) {
            return new XpAwEllipse(new Ellipse2D.Double(x - 5.0, y - 3.0, 5.0, 3.0));
        }
    }
}

