/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.roi.j3d;

import com.ge.med.idc.T3DRenderEngine;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.jami.roi.j3d.Roi3DStatImage;
import java.awt.image.RenderedImage;

public class T3DStatImage
implements Roi3DStatImage {
    private T3DViewport vp = null;
    private XpSlice refSlice;
    private RoiActor roi = null;

    public T3DStatImage(T3DViewport vp, RoiActor ra) {
        this.vp = vp;
        this.roi = ra;
    }

    public T3DStatImage(T3DViewport vp, RoiActor ra, XpSlice rslice) {
        this.vp = vp;
        this.roi = ra;
        this.refSlice = new XpSlice(rslice.ul, rslice.ur, rslice.br, rslice.width, rslice.height);
    }

    @Override
    public void syncReferenceSlice() {
        XpImage img = this.vp.getFrame();
        if (img != null) {
            XpSlice slice = img.getSlice();
            this.refSlice = new XpSlice(slice.ul, slice.ur, slice.br, slice.width, slice.height);
        }
    }

    @Override
    public RoiActor getRoiActor() {
        return this.roi;
    }

    public XjVolumeModel getVolumeModel() {
        return this.vp.getVolumeModel();
    }

    public XpImage getImage() {
        return this.vp.getFrame();
    }

    public String getRenderStyle() {
        return this.vp.getT3DComponent().getT3DRenderEngine().getRenderStyle();
    }

    @Override
    public XpSlice getReferenceSlice() {
        return this.refSlice;
    }

    @Override
    public T3DRenderEngine getT3DRenderEngine() {
        return this.vp.getT3DComponent().getT3DRenderEngine();
    }

    @Override
    public double getAzimuth() {
        XpImage img = this.vp.getFrame();
        if (img != null) {
            return img.getAzimuth();
        }
        return 0.0;
    }

    @Override
    public double getDefaultWindowWidth() {
        XpImage img = this.vp.getFrame();
        if (img != null) {
            return img.getDefaultWindowWidth();
        }
        return 600.0;
    }

    @Override
    public double getDefaultWindowLevel() {
        XpImage img = this.vp.getFrame();
        if (img != null) {
            return img.getDefaultWindowLevel();
        }
        return 300.0;
    }

    @Override
    public RenderedImage getPixelData() {
        XpImage img = this.vp.getFrame();
        if (img != null) {
            return img.getPixelData();
        }
        return null;
    }

    @Override
    public double getPixelDimensionX() {
        XpImage img = this.vp.getFrame();
        if (img != null) {
            return img.getPixelDimensionX();
        }
        return 1.0;
    }

    @Override
    public double getPixelDimensionY() {
        XpImage img = this.vp.getFrame();
        if (img != null) {
            return img.getPixelDimensionY();
        }
        return 1.0;
    }

    @Override
    public XpSlice getSlice() {
        XpImage img = this.vp.getFrame();
        if (img != null) {
            return img.getSlice();
        }
        return null;
    }

    @Override
    public double getRescaleIntercept() {
        XpImage img = this.vp.getFrame();
        if (img != null) {
            return img.getRescaleIntercept();
        }
        return 0.0;
    }

    @Override
    public double getRescaleSlope() {
        XpImage img = this.vp.getFrame();
        if (img != null) {
            return img.getRescaleSlope();
        }
        return 1.0;
    }

    public T3DViewport getViewport() {
        return this.vp;
    }
}

