/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm;

import com.ge.med.idc.XjTagValue;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class DMElement
extends tagValue
implements Externalizable {
    public DMElement() {
    }

    public DMElement(XjTagValue value) {
        super(value.group, value.element);
        this.vrep = value.vr;
        this.setLittleEndian(value.littleEndian);
        this.setFillValue(!value.noValue);
        this.setOffset(value.offset);
        this.value = value.value;
    }

    public DMElement(int group, int element) {
        super(group, element);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(new Integer(this.group));
        out.writeObject(new Integer(this.element));
        out.writeObject(new Integer(this.vrep));
        out.writeObject(new Integer(this.len));
        out.writeObject(this.value);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.group = (Integer)in.readObject();
        this.element = (Integer)in.readObject();
        this.vrep = (Integer)in.readObject();
        this.len = (Integer)in.readObject();
        this.value = in.readObject();
    }

    public static DMElement[] genDMelements(XjTagValue[] xjtagvalue) {
        DMElement[] ret = new DMElement[xjtagvalue.length];
        for (int i = 0; i < xjtagvalue.length; ++i) {
            ret[i] = new DMElement(xjtagvalue[i]);
        }
        return ret;
    }

    public static XjTagValue[] genXjTagValue(DMElement[] dmelements) {
        XjTagValue[] ret = new XjTagValue[dmelements.length];
        for (int i = 0; i < dmelements.length; ++i) {
            ret[i] = dmelements[i].getXjTagValue(null);
        }
        return ret;
    }

    public static int getXjTagValue(DMElement[] dmelements, XjTagValue[] xjtagvalue) {
        int count = 0;
        for (int i = 0; i < dmelements.length; ++i) {
            if (dmelements[i].getOffset() > 0L) {
                ++count;
            }
            xjtagvalue[i] = dmelements[i].getXjTagValue(xjtagvalue[i]);
        }
        return count;
    }

    public XjTagValue getXjTagValue(XjTagValue fill) {
        if (fill == null) {
            fill = new XjTagValue();
        }
        fill.vr = this.vrep;
        fill.element = this.element;
        fill.group = this.group;
        fill.littleEndian = this.isLittleEndian();
        fill.noValue = !this.isFillValue();
        fill.value = this.value;
        fill.offset = this.getOffset();
        return fill;
    }
}

