/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm;

import java.util.EventObject;
import java.util.Properties;

public class DMEvent
extends EventObject {
    int id;
    String msg;
    Object source;
    Properties props;
    public static final int COMPOSITE_ADDED = 1;
    public static final int GENERAL_EVENT = 2;
    public static final int JOB_COMPLETED = 3;
    public static final int SELECTION_CHANGED = 4;
    public static final int REQUEST_NEXT = 5;
    public static final int REQUEST_PREVIOUS = 6;
    public static final int REQUEST_RESEND = 7;
    public static final int SYSTEM_ERROR = 8;

    public DMEvent(int id, String msg) {
        super(msg);
        this.id = id;
        this.msg = msg;
    }

    public DMEvent(int id, String msg, Object source) {
        this(id, msg);
        this.source = source;
    }

    public DMEvent(int id, String msg, Object source, Properties props) {
        this(id, msg, source);
        this.props = props;
    }

    @Override
    public String toString() {
        switch (this.id) {
            case 1: {
                return "COMPOSITE_ADDED: " + this.msg;
            }
            case 2: {
                return "GENERAL_EVENT: " + this.msg;
            }
            case 3: {
                return "JOB_COMPLETED: " + this.msg;
            }
            case 4: {
                return "SELECTION_CHANGED: " + this.msg;
            }
            case 5: {
                return "REQUEST_NEXT: " + this.msg;
            }
            case 6: {
                return "REQUEST_PREVIOUS: " + this.msg;
            }
            case 7: {
                return "REQUEST_RESEND: " + this.msg;
            }
            case 8: {
                return "SYSTEM_ERROR: " + this.msg;
            }
        }
        return "UNKNOWN_EVENT(" + this.id + "): " + this.msg;
    }

    public int getID() {
        return this.id;
    }

    public String getMessage() {
        return this.msg;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public void setProperties(Properties props) {
        this.props = props;
    }

    public Properties getProperties() {
        return this.props;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public String getProperty(String name) {
        if (this.props == null) {
            return null;
        }
        return this.props.getProperty(name);
    }
}

