/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMObjectReceiver;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.peer.DMAuxObject;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.util.tport.XPort;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import javax.imageio.ImageIO;

public abstract class DMObjectBase {
    protected DMiObject peer;

    public BufferedImage[] getPixelData() {
        if (DMSession.TAP_TRACE_FLAG) {
            Tap.log.finest("getPixelData()");
        }
        return this.peer.getPixelData(null);
    }

    public BufferedImage[] getPixelData(DMTag[] tags) {
        if (DMSession.TAP_TRACE_FLAG) {
            Tap.log.finest("getPixelData(tags)");
        }
        return this.peer.getPixelData(tags);
    }

    public abstract void getRelated(String var1, DMQuery var2, DMObjectReceiver var3);

    protected static class IconConverter
    implements DMAuxObject.Converter {
        protected IconConverter() {
        }

        @Override
        public Object getObjectFromStream(InputStream str) {
            try {
                return ImageIO.read(str);
            }
            catch (IOException e) {
                throw new DMException(e);
            }
        }

        @Override
        public InputStream getStreamFromObject(Object obj) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)((BufferedImage)obj), "jpeg", bos);
            }
            catch (IOException e) {
                throw new DMException(e);
            }
            return new ByteArrayInputStream(bos.toByteArray());
        }

        @Override
        public void writeFileFromObject(Object obj, String path) {
            try {
                ImageIO.write((RenderedImage)((BufferedImage)obj), "jpeg", new File(path));
            }
            catch (IOException e) {
                throw new DMException(e);
            }
        }

        @Override
        public void writeFileFromStream(InputStream str, String path) {
            Object o = this.getObjectFromStream(str);
            this.writeFileFromObject(o, path);
        }
    }

    protected class IconAuxObjectBase {
        XPort port = new XPort();

        public IconAuxObjectBase(String type, Properties info) {
            this.port.setAnnot(null);
        }

        protected BufferedImage computeIconImage(int dimx, int dimy, Properties prop) {
            BufferedImage icon = new BufferedImage(dimx, dimy, 1);
            try {
                final DMObject[] dmo = new DMObject[1];
                DMObjectBase.this.getRelated("image", null, new DMObjectReceiver(){

                    @Override
                    public boolean gotOne(DMObject o) {
                        dmo[0] = o;
                        return false;
                    }
                });
                this.port.setSize(dimx, dimy);
                DMImage[] dmi = dmo[0].getImages(null);
                this.port.setImages(new DMImage[]{dmi[0]});
                this.port.paint(icon.createGraphics());
            }
            catch (Exception ex) {
                Tap.log.log(Level.WARNING, "Caught exception in computeIconImage: ", ex);
            }
            return icon;
        }
    }
}

