/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm;

import com.ge.med.idc.XjMultiChannelVolume;
import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.volume.VolumeInfo;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;

public abstract class DMVolume
implements XjMultiChannelVolume {
    private boolean readOnly = true;
    protected static HashMap map = new HashMap();
    protected RandomAccessFile raf;
    protected FileChannel chan;

    @Override
    public abstract String getRelatedComposite();

    @Override
    public int getNumChannels() {
        return 1;
    }

    @Override
    public String getMultiChannelType() {
        return "Single Channel";
    }

    @Override
    public String getChannelName(int channel) {
        if (0 == channel) {
            return "Pixel Data";
        }
        throw new IllegalArgumentException("Channel can only be 0 for single-channel data");
    }

    @Override
    public long getVSliceOffset(int channel, int slice) {
        if (0 == channel) {
            return this.getVSliceOffset(slice);
        }
        throw new IllegalArgumentException("Channel can only be 0 for single-channel data");
    }

    @Override
    public String getVSlicePath(int channel, int slice) {
        if (0 == channel) {
            return this.getVSlicePath(slice);
        }
        throw new IllegalArgumentException("Channel can only be 0 for single-channel data");
    }

    @Override
    public Object getVSliceValue(int channel, int slice, int group, int element) {
        if (0 == channel) {
            return this.getVSliceValue(slice, group, element);
        }
        throw new IllegalArgumentException("Channel can only be 0 for single-channel data");
    }

    public void getVSliceValues(int slice, DMElement[] dme) {
        for (int i = 0; i < dme.length; ++i) {
            dme[i].value = this.getVSliceValue(slice, dme[i].group, dme[i].element);
        }
    }

    public abstract VolumeInfo getInfoFileName();

    public static DMVolume buildVolume(String type, Object[] data) {
        String className = null;
        try {
            className = (String)map.get(type);
            if (className == null) {
                className = type;
            }
            Class<?> c = Class.forName(className);
            Constructor<?> cons = c.getConstructor(Object[].class);
            return (DMVolume)cons.newInstance(new Object[]{data});
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
            throw new RuntimeException("InvocationTarget =" + type, ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException("IllegalArgument =" + type + className, ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("IllegalAccess=" + type, ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException("loading=" + type, ex);
        }
        catch (SecurityException ex) {
            throw new RuntimeException("loading=" + type, ex);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("no method=" + type, ex);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("no class=" + type, ex);
        }
    }

    public ByteBuffer getSliceBuffer(int slice) throws IOException {
        String fileName = this.getVSlicePath(slice);
        this.raf = new RandomAccessFile(fileName, this.readOnly ? "r" : "rw");
        int[] dim = this.getVolumeDimensions(null);
        long off = this.getVSliceOffset(slice);
        int size = dim[0] * dim[1] * this.getBitsPerVoxel() / 8;
        this.chan = this.raf.getChannel();
        FileChannel.MapMode mode = this.readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
        MappedByteBuffer bb = this.chan.map(mode, off, size);
        ByteOrder b = this.isVolumeLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        bb.order(b);
        return bb;
    }

    public void closeLastBuffer() {
        try {
            this.raf.close();
            this.chan.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        map.put("DMObjectVolume", "com.ge.med.terra.tap.dm.volume.DMObjectVolume");
    }
}

