/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.dicomdir;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.dicomdir.Dicomdir;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.sessionFile.dicomImageGen;
import com.ge.med.terra.tap.dm.sessionFile.fileImage;
import com.ge.med.terra.tap.dm.sessionFile.fileImageManager;
import com.ge.med.terra.tap.dm.sessionFile.fileSequence;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;

public class DicomdirComposite
implements DMiComposite {
    private File path;
    private Dicomdir dicomdir;
    private static dicomParser parser = new dicomParser();
    protected HashMap<DMTag, tagValue> elemCache = new HashMap();

    public DicomdirComposite(File path, Dicomdir dicomdir) {
        this.path = path;
        this.dicomdir = dicomdir;
    }

    @Override
    public String getID() {
        return this.path.getAbsolutePath();
    }

    @Override
    public String getType() {
        return "composite";
    }

    @Override
    public String getFilePath() {
        return this.path.toString();
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new FileInputStream(this.path);
        }
        catch (IOException e) {
            throw new DMException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(DMTag tag2) {
        if (this.elemCache.containsKey(tag2)) {
            return this.elemCache.get((Object)tag2).value;
        }
        try {
            parser.setFile(this.getFilePath());
            tagValue tv = new tagValue(tag2.getGroup(), tag2.getElement());
            parser.fill(new tagValue[]{tv});
            if (tv.vrep == 21329) {
                tv.value = new fileSequence(tv);
            }
            if (tag2.getGroup() < 200) {
                this.elemCache.put(new DMTag(tag2.getGroup(), tag2.getElement()), tv);
            }
            Object object = tv.value;
            return object;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        finally {
            parser.clearFile();
        }
        return null;
    }

    @Override
    public void getValues(DMElement[] elements) {
        int size = elements.length;
        boolean[] isFilled = new boolean[size];
        ArrayList<DMElement> tagsToFill = new ArrayList<DMElement>();
        for (int i = 0; i < elements.length; ++i) {
            DMTag tag2 = new DMTag(elements[i].group, elements[i].element);
            if (this.elemCache.containsKey(tag2)) {
                tagValue tv = this.elemCache.get(tag2);
                tagValue.copyFillData(tv, elements[i]);
                isFilled[i] = true;
                continue;
            }
            isFilled[i] = false;
            tagsToFill.add(elements[i]);
        }
        if (!tagsToFill.isEmpty()) {
            try {
                parser.setFile(this.getFilePath());
                Object[] tgs = tagsToFill.toArray(new DMElement[tagsToFill.size()]);
                Arrays.sort(tgs);
                parser.fill((tagValue[])tgs);
                int oldg = -1;
                int olde = -1;
                for (int i = 0; i < tgs.length; ++i) {
                    if (((DMElement)tgs[i]).vrep == 21329) {
                        ((DMElement)tgs[i]).value = new fileSequence((tagValue)tgs[i]);
                    }
                    if (oldg != ((DMElement)tgs[i]).group || olde != ((DMElement)tgs[i]).element) {
                        DMTag tag3 = new DMTag(((DMElement)tgs[i]).group, ((DMElement)tgs[i]).element);
                        this.elemCache.put(tag3, new tagValue((tagValue)tgs[i]));
                    }
                    oldg = ((DMElement)tgs[i]).group;
                    olde = ((DMElement)tgs[i]).element;
                }
            }
            catch (FileNotFoundException ex) {
                throw new DMException(ex);
            }
            finally {
                parser.clearFile();
            }
        }
    }

    @Override
    public void setValues(DMElement[] elements) {
        if (this.dicomdir.isReadOnly()) {
            throw new RuntimeException("Can't update: READ-ONLY MEDIA");
        }
        throw new UnsupportedOperationException("Method setValues() is not supported.");
    }

    @Override
    public DMTag[] getTags() {
        try {
            parser.setFile(this.getFilePath());
        }
        catch (Exception ex) {
            throw new DMException(ex);
        }
        tagValue[] tv = parser.getTags();
        parser.clearFile();
        DMTag[] dt = new DMTag[tv.length];
        for (int i = 0; i < tv.length; ++i) {
            dt[i] = new DMTag(tv[i].group, tv[i].element, tv[i].vrString());
        }
        return dt;
    }

    @Override
    public void delete() {
        this.path.delete();
    }

    @Override
    public BufferedImage[] getPixelData(DMTag[] tags) {
        BufferedImage[] pixelData;
        try {
            pixelData = dicomImageGen.getImages(this.getFilePath(), tags);
            if (null == pixelData) {
                pixelData = new BufferedImage[]{};
            }
        }
        catch (Exception ex) {
            Tap.log.log(Level.WARNING, this + ": Unable to get pixel data: ", ex);
            pixelData = new BufferedImage[]{};
        }
        return pixelData;
    }

    @Override
    public DMiImage[] getImages(DMTag[] tags) {
        try {
            fileImageManager.getInstance().setPause(true);
            DMiImage[] imgs = fileImage.getImages(this, tags);
            fileImageManager.getInstance().setPause(false);
            if (null == imgs) {
                return new DMiImage[0];
            }
            return imgs;
        }
        catch (Exception ex) {
            Tap.log.log(Level.WARNING, this + ": Unable to get images: ", ex);
            return new DMiImage[0];
        }
    }

    public String toString() {
        String str = "[type=" + this.getType() + ", path=" + this.getFilePath() + "]";
        return str;
    }
}

