/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.dicomdir;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.dicomdir.Dicomdir;
import com.ge.med.terra.tap.dm.dicomdir.DicomdirTagValue;
import com.ge.med.terra.tap.dm.dicomdir.DirectoryEntityLevel;
import com.ge.med.terra.tap.dm.dicomdir.DirectoryRecord;
import com.ge.med.terra.tap.dm.dicomdir.DirectoryRecordType;
import com.ge.med.terra.tap.util.dicom.DicomCharSet;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;

public class DicomdirCompositeWriter {
    private static final char MULTI_DELIM_CHAR = '\\';
    private static final String[] PARENT_TYPES = new String[]{"PATIENT", "STUDY", "SERIES"};
    private static final String TOP_LEVEL_DIR = "DICOM";
    private static final DicomdirTagValue NEW_OFFSET_OF_SIBLING = new DicomdirTagValue(4, 5120, "UL", 0L);
    private static final DicomdirTagValue NEW_RECORD_INUSE_FLAG = new DicomdirTagValue(4, 5136, "US", 65535);
    private static final DicomdirTagValue NEW_OFFSET_OF_CHILD = new DicomdirTagValue(4, 5152, "UL", 0L);
    private static dicomParser parser = new dicomParser();
    private final tagValue patientNameTag = new tagValue(16, 16);
    private final tagValue patientIDTag = new tagValue(16, 32);
    private final tagValue dobTag = new tagValue(16, 48);
    private final tagValue studyIDTag = new tagValue(32, 13);
    private final tagValue seriesIDTag = new tagValue(32, 14);
    private final tagValue compIDTag = new tagValue(8, 24);
    private final Set<tagValue> patientTagsForID = new TreeSet<tagValue>(){
        {
            this.add(DicomdirCompositeWriter.this.patientIDTag);
            this.add(DicomdirCompositeWriter.this.patientNameTag);
            this.add(DicomdirCompositeWriter.this.dobTag);
        }
    };
    private final Set<tagValue> studyTagsForID = new TreeSet<tagValue>(){
        {
            this.add(DicomdirCompositeWriter.this.studyIDTag);
        }
    };
    private final Set<tagValue> seriesTagsForID = new TreeSet<tagValue>(){
        {
            this.add(DicomdirCompositeWriter.this.seriesIDTag);
        }
    };
    private final Set<tagValue> imageTagsForID = new TreeSet<tagValue>(){
        {
            this.add(DicomdirCompositeWriter.this.compIDTag);
        }
    };
    private final tagValue sopTag = new tagValue(8, 22);
    private final tagValue txUID = new tagValue(2, 16);
    private final String[] levelID = new String[Dicomdir.LEVEL_NAMES.length];
    private boolean alreadyExists = false;
    private String drPath;
    private String compType;
    private String compLevel;
    private int compLevelIndex;
    private String compID;
    private String refFileIDPath;
    private int mbPos;
    private boolean newWrite = true;
    private static int offsetRootFirstDR = 0;
    private static int offsetRootLastDR = 0;
    private Dicomdir dicomdir;
    private final boolean littleEndian;
    private final boolean explicitVR;
    private DicomCharSet[] dicomCharsets = DicomCharSet.getDefaultCharSet();

    public DicomdirCompositeWriter(Dicomdir dicomdir) {
        this.dicomdir = dicomdir;
        this.littleEndian = dicomdir.isLittleEndian();
        this.explicitVR = dicomdir.isExplicitVR();
        this.mbPos = dicomdir.getBufferPosition();
    }

    public void updateDicomdir(File file) throws IOException {
        this.newWrite = true;
        this.drPath = file.getAbsolutePath();
        this.fillKeyTags(this.drPath);
        this.compType = DirectoryRecordType.getDirectoryRecordTypeName((String)this.sopTag.value);
        this.compLevel = DirectoryRecordType.getLevel(this.compType);
        this.compLevelIndex = DirectoryRecordType.getLevelIndex(this.compType);
        this.levelID[0] = DirectoryRecord.makeDirectoryRecordID(PARENT_TYPES[0], this.patientTagsForID);
        this.levelID[1] = DirectoryRecord.makeDirectoryRecordID(PARENT_TYPES[1], this.studyTagsForID);
        this.levelID[2] = DirectoryRecord.makeDirectoryRecordID(PARENT_TYPES[2], this.seriesTagsForID);
        this.levelID[3] = DirectoryRecord.makeDirectoryRecordID(this.compType, this.imageTagsForID);
        this.compID = this.levelID[3];
        if (this.dicomdir.getNumberOfPatients() == 0) {
            this.writeNewDirectoryRecord(0, null, WriteMode.NEW);
            Tap.log.log(Level.INFO, "Succesfully wrote Directory Record in DICOMDIR for [" + this.drPath + "]");
        } else {
            boolean exists = this.checkDirectoryRecordAlreadyExists();
            if (exists) {
                Tap.log.log(Level.INFO, "Directory Record already exists in DICOMDIR for [" + this.drPath + "]");
            } else {
                this.addDirectoryRecord();
                Tap.log.log(Level.INFO, "Succesfully wrote Directory Record in DICOMDIR for [" + this.drPath + "]");
            }
        }
        this.dicomdir.setActualFileLength(this.dicomdir.getBufferPosition());
    }

    private void fillKeyTags(String filePath) throws IOException {
        Object[] tags = new tagValue[]{this.patientIDTag, this.patientNameTag, this.dobTag, this.studyIDTag, this.seriesIDTag, this.compIDTag, this.sopTag, this.txUID};
        Arrays.sort(tags);
        parser.setFile(filePath);
        parser.fill((tagValue[])tags);
        this.dicomCharsets = parser.getDicomCharsets();
        parser.clearFile();
        if (null == this.txUID.value) {
            this.txUID.value = "1.2.840.10008.1.2.1";
            Tap.log.log(Level.SEVERE, "[" + filePath + "] Missing Transfer Syntax UID " + tagValue.atToString(this.txUID.group, this.txUID.element) + ". Defaulting to " + this.txUID.value);
        }
    }

    private boolean checkDirectoryRecordAlreadyExists() {
        DirectoryRecord dr = this.dicomdir.getDirectoryRecordFromMap(this.compLevelIndex, this.compID);
        if (null != dr) {
            this.alreadyExists = true;
            this.refFileIDPath = dr.getRefFileIDPath();
            return true;
        }
        return false;
    }

    public boolean isAlreadyExists() {
        return this.alreadyExists;
    }

    private void addDirectoryRecord() throws IOException {
        int numParentLevels = DirectoryEntityLevel.getParentLevels(this.compLevel).size();
        for (int level = numParentLevels - 1; level > -1; --level) {
            DirectoryRecord dr = this.dicomdir.getDirectoryRecordFromMap(level, this.levelID[level]);
            if (dr == null) continue;
            DirectoryRecord lastChildDR = this.getLastChildDirectoryRecord(dr);
            this.writeNewDirectoryRecord(level + 1, lastChildDR, WriteMode.SIBLING);
            return;
        }
        DirectoryRecord lastPatientDR = this.getLastPatientDR();
        this.writeNewDirectoryRecord(0, lastPatientDR, WriteMode.SIBLING);
    }

    private void writeNewDirectoryRecord(int level, DirectoryRecord dr, WriteMode mode) throws IOException {
        DicomdirTagValue[] tags;
        int i = level;
        ByteBuffer mbStream = this.dicomdir.getBuffer();
        long offset = this.setStreamPosition(mbStream);
        DirectoryRecord newDR = new DirectoryRecord(offset, mbStream, this.dicomdir.getMountFilePath());
        if (mode == WriteMode.SIBLING) {
            newDR.index = dr.index + 1;
            newDR.parentDR = dr.parentDR;
        } else if (mode == WriteMode.CHILD) {
            newDR.index = 1;
            newDR.parentDR = dr;
        } else if (mode == WriteMode.NEW) {
            newDR.index = 1;
            offsetRootFirstDR = (int)newDR.myOffset;
            this.dicomdir.reWriteFirstPatientDROffset(offsetRootFirstDR);
        }
        String drType = i != this.compLevelIndex ? PARENT_TYPES[i] : this.compType;
        newDR.type = drType;
        newDR.level = DirectoryRecordType.getLevel(drType);
        Set<tagValue> tagsToWrite = this.dicomdir.getDirectoryEntityLevels()[i].getDirectoryRecordType(newDR.type).getValues(this.drPath);
        DicomdirTagValue.writeItemBegin(mbStream);
        int start = mbStream.position();
        NEW_OFFSET_OF_SIBLING.write(mbStream, this.explicitVR, this.littleEndian, this.dicomCharsets);
        NEW_RECORD_INUSE_FLAG.write(mbStream, this.explicitVR, this.littleEndian, this.dicomCharsets);
        NEW_OFFSET_OF_CHILD.write(mbStream, this.explicitVR, this.littleEndian, this.dicomCharsets);
        new DicomdirTagValue(4, 5168, "CS", drType, this.dicomCharsets).write(mbStream, this.explicitVR, this.littleEndian, this.dicomCharsets);
        if (i == this.compLevelIndex) {
            String refFileID = DicomdirCompositeWriter.createReferencedFileID(newDR);
            Tap.log.log(Level.INFO, "Directory Record Referenced File ID [" + refFileID + "]");
            new DicomdirTagValue(4, 5376, "CS", refFileID, this.dicomCharsets).write(mbStream, this.explicitVR, this.littleEndian, this.dicomCharsets);
            new DicomdirTagValue(4, 5392, "UI", (String)this.sopTag.value, this.dicomCharsets).write(mbStream, this.explicitVR, this.littleEndian, this.dicomCharsets);
            new DicomdirTagValue(4, 5393, "UI", this.compID, this.dicomCharsets).write(mbStream, this.explicitVR, this.littleEndian, this.dicomCharsets);
            new DicomdirTagValue(4, 5394, "UI", (String)this.txUID.value, this.dicomCharsets).write(mbStream, this.explicitVR, this.littleEndian, this.dicomCharsets);
        }
        for (DicomdirTagValue tag2 : tags = tagsToWrite.toArray(new DicomdirTagValue[0])) {
            tag2.write(mbStream, this.explicitVR, this.littleEndian, this.dicomCharsets);
        }
        int end = mbStream.position();
        DicomdirTagValue.writeItemEnd(mbStream);
        if (i == this.compLevelIndex) {
            DicomdirTagValue.writeSeqEnd(mbStream);
        }
        newDR.tvs = DicomdirCompositeWriter.readDirectoryRecordTags(start, end, mbStream, this.dicomCharsets);
        newDR.id = this.levelID[i];
        if (i == 0) {
            offsetRootLastDR = (int)newDR.myOffset;
        }
        this.updateDirectoryEntity(i, dr, newDR, mode, mbStream);
        this.refFileIDPath = newDR.getRefFileIDPath();
        if (++i > this.compLevelIndex) {
            this.mbPos = mbStream.position();
            this.dicomdir.reWriteLastPatientDROffset(offsetRootLastDR);
            return;
        }
        this.mbPos = mbStream.position();
        this.writeNewDirectoryRecord(i, newDR, WriteMode.CHILD);
    }

    private static String createReferencedFileID(DirectoryRecord dr) {
        StringBuilder fileID = new StringBuilder(TOP_LEVEL_DIR);
        fileID.append('\\');
        int offset = fileID.length();
        fileID.append((CharSequence)DicomdirCompositeWriter.createFileIDComponent(dr.type.replace(" ", "").substring(0, 3), dr.index));
        DirectoryRecord parentDR = dr.parentDR;
        while (null != parentDR) {
            fileID.insert(offset, DicomdirCompositeWriter.createFileIDComponent(parentDR.level.substring(0, 2), parentDR.index).append('\\'));
            parentDR = parentDR.parentDR;
        }
        return fileID.toString();
    }

    private static StringBuilder createFileIDComponent(String prefix, int index) {
        int maxlength = 8;
        StringBuilder fileIDComponent = new StringBuilder(prefix);
        fileIDComponent.append(index);
        if (fileIDComponent.length() > maxlength) {
            Tap.log.log(Level.WARNING, "Only " + maxlength + " characters are allowed for each File ID Component: \"" + fileIDComponent + "\"");
        }
        return fileIDComponent;
    }

    public String getRefFileIDPath() {
        return this.refFileIDPath;
    }

    private static Set<tagValue> readDirectoryRecordTags(int start, int end, ByteBuffer mbStream, DicomCharSet[] dicomCharsets) {
        TreeSet<tagValue> tags = new TreeSet<tagValue>();
        int currPos = mbStream.position();
        mbStream.position(start);
        int group = mbStream.getShort() & 0xFFFF;
        int element = mbStream.getShort() & 0xFFFF;
        while (mbStream.position() < end) {
            tags.add(new DicomdirTagValue(group, element, mbStream, dicomCharsets));
            group = mbStream.getShort() & 0xFFFF;
            element = mbStream.getShort() & 0xFFFF;
        }
        mbStream.getInt();
        mbStream.position(currPos);
        return tags;
    }

    private void updateDirectoryEntity(int level, DirectoryRecord dr, DirectoryRecord newDR, WriteMode mode, ByteBuffer mbStream) {
        long offPos = 0L;
        newDR.nextSibling = 0L;
        if (mode == WriteMode.NEW) {
            this.dicomdir.insertDirectoryRecord(level, newDR);
            return;
        }
        if (mode == WriteMode.SIBLING) {
            dr.nextSibling = newDR.myOffset;
            for (tagValue t : dr.tvs) {
                if (t.group != 4 || t.element != 5120) continue;
                offPos = t.fileOffset;
                break;
            }
        } else if (mode == WriteMode.CHILD) {
            dr.firstChild = newDR.myOffset;
            for (tagValue t : dr.tvs) {
                if (t.group != 4 || t.element != 5152) continue;
                offPos = t.fileOffset;
                break;
            }
        }
        int currPos = mbStream.position();
        mbStream.position((int)offPos + 8);
        mbStream.putInt((int)newDR.myOffset);
        mbStream.position(currPos);
        this.dicomdir.insertDirectoryRecord(level, newDR);
    }

    private int setStreamPosition(ByteBuffer mbStream) {
        if (this.newWrite) {
            mbStream.position(this.mbPos - 8);
            int g = mbStream.getShort() & 0xFFFF;
            int e = mbStream.getShort() & 0xFFFF;
            if (g == 65534 && e == 57565) {
                mbStream.position(mbStream.position() - 4);
            } else {
                mbStream.position(mbStream.position() + 4);
            }
            this.newWrite = false;
        }
        return mbStream.position();
    }

    private DirectoryRecord getLastChildDirectoryRecord(DirectoryRecord parent) {
        int parentLevel = DirectoryEntityLevel.getIndex(parent.level);
        int childLevel = parentLevel + 1;
        Map<String, DirectoryRecord> map = this.dicomdir.getDirectoryEntities().get(childLevel);
        Set<String> keys = map.keySet();
        ArrayList<DirectoryRecord> listChild = new ArrayList<DirectoryRecord>();
        for (String key : keys) {
            if (!map.get((Object)key).parentDR.id.equalsIgnoreCase(parent.id)) continue;
            listChild.add(map.get(key));
        }
        for (DirectoryRecord drChild : listChild) {
            if (drChild.nextSibling != 0L) continue;
            return drChild;
        }
        return null;
    }

    private DirectoryRecord getLastPatientDR() {
        int patientLevel = 0;
        Map<String, DirectoryRecord> map = this.dicomdir.getDirectoryEntities().get(patientLevel);
        Set<String> keys = map.keySet();
        for (String key : keys) {
            DirectoryRecord dr = map.get(key);
            if (0L != dr.nextSibling) continue;
            return dr;
        }
        return null;
    }

    private static enum WriteMode {
        NEW,
        SIBLING,
        CHILD;

    }
}

