/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.dicomdir;

import com.ge.med.terra.tap.dm.dicomdir.DicomdirTagValue;
import com.ge.med.terra.tap.dm.dicomdir.DirectoryRecordType;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.util.Set;
import java.util.TreeSet;

public class SRDocumentDirectoryRecordType
extends DirectoryRecordType {
    private static final DicomdirTagValue charSetTag = new DicomdirTagValue(8, 5, 1, true);
    private static final DicomdirTagValue instanceNumberTag = new DicomdirTagValue(32, 19, 1, false);
    private static final DicomdirTagValue completionFlagTag = new DicomdirTagValue(64, 42129, 1, false);
    private static final DicomdirTagValue verifFlagTag = new DicomdirTagValue(64, 42131, 1, false);
    private static final DicomdirTagValue contentDateTag = new DicomdirTagValue(8, 35, 1, false);
    private static final DicomdirTagValue contentTimeTag = new DicomdirTagValue(8, 51, 1, false);
    private static final DicomdirTagValue verifDateTimeTag = new DicomdirTagValue(64, 41008, 1, true);
    private static final DicomdirTagValue conceptCodeTag = new DicomdirTagValue(64, 41027, 1, false);
    private static final DicomdirTagValue contentSQTag = new DicomdirTagValue(64, 42800, 1, true);
    private static int dummyInstNumber = 9998;

    public SRDocumentDirectoryRecordType() {
        super("SR DOCUMENT");
    }

    @Override
    protected Set<tagValue> createDefaultTagList() {
        TreeSet<tagValue> tagSet = new TreeSet<tagValue>();
        tagSet.add(charSetTag);
        tagSet.add(instanceNumberTag);
        tagSet.add(contentDateTag);
        tagSet.add(contentTimeTag);
        tagSet.add(completionFlagTag);
        tagSet.add(verifFlagTag);
        tagSet.add(verifDateTimeTag);
        tagSet.add(conceptCodeTag);
        tagSet.add(contentSQTag);
        return tagSet;
    }

    @Override
    protected Object getDefaultValue(DicomdirTagValue atv) {
        if (atv.getType() == 2) {
            return null;
        }
        if (atv.compareTo(instanceNumberTag) == 0) {
            return Integer.toString(++dummyInstNumber);
        }
        if (atv.compareTo(completionFlagTag) == 0 || atv.compareTo(verifFlagTag) == 0) {
            return "UNDEFINED";
        }
        if (atv.compareTo(contentDateTag) == 0) {
            return "18880808";
        }
        if (atv.compareTo(contentTimeTag) == 0) {
            return "000000.000";
        }
        if (atv.compareTo(conceptCodeTag) == 0) {
            return "";
        }
        throw new IllegalArgumentException("Unable to provide default value for " + atv);
    }
}

