/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.dicomdir;

import com.ge.med.terra.tap.dm.dicomdir.DicomdirTagValue;
import com.ge.med.terra.tap.dm.dicomdir.DirectoryRecordType;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.util.Set;
import java.util.TreeSet;

public class SpectroscopyDirectoryRecordType
extends DirectoryRecordType {
    private static final DicomdirTagValue charSetTag = new DicomdirTagValue(8, 5, 1, true);
    private static final DicomdirTagValue instanceNumberTag = new DicomdirTagValue(32, 19, 1, false);
    private static final DicomdirTagValue contentDateTag = new DicomdirTagValue(8, 35, 1, false);
    private static final DicomdirTagValue contentTimeTag = new DicomdirTagValue(8, 51, 1, false);
    private static final DicomdirTagValue imageTypeTag = new DicomdirTagValue(8, 8, 1, false);
    private static final DicomdirTagValue refImageSQTag = new DicomdirTagValue(8, 37010, 1, true);
    private static final DicomdirTagValue nFramesTag = new DicomdirTagValue(40, 8, 1, false);
    private static final DicomdirTagValue nRowsTag = new DicomdirTagValue(40, 16, 1, false);
    private static final DicomdirTagValue nColsTag = new DicomdirTagValue(40, 17, 1, false);
    private static final DicomdirTagValue dataPointRowsTag = new DicomdirTagValue(40, 36865, 1, false);
    private static final DicomdirTagValue dataPointColsTag = new DicomdirTagValue(40, 36866, 1, false);
    private static int dummyInstNumber = 9998;

    public SpectroscopyDirectoryRecordType() {
        super("SPECTROSCOPY");
    }

    @Override
    protected Set<tagValue> createDefaultTagList() {
        TreeSet<tagValue> tagSet = new TreeSet<tagValue>();
        tagSet.add(charSetTag);
        tagSet.add(instanceNumberTag);
        tagSet.add(contentDateTag);
        tagSet.add(contentTimeTag);
        tagSet.add(imageTypeTag);
        tagSet.add(refImageSQTag);
        tagSet.add(nFramesTag);
        tagSet.add(nRowsTag);
        tagSet.add(nColsTag);
        tagSet.add(dataPointRowsTag);
        tagSet.add(dataPointColsTag);
        return tagSet;
    }

    @Override
    protected Object getDefaultValue(DicomdirTagValue atv) {
        if (atv.getType() == 2) {
            return null;
        }
        if (atv.compareTo(instanceNumberTag) == 0) {
            return Integer.toString(++dummyInstNumber);
        }
        if (atv.compareTo(contentDateTag) == 0) {
            return "18880808";
        }
        if (atv.compareTo(contentTimeTag) == 0) {
            return "000000.000";
        }
        if (atv.compareTo(nFramesTag) == 0 || atv.compareTo(nRowsTag) == 0 || atv.compareTo(nColsTag) == 0) {
            return 0;
        }
        if (atv.compareTo(dataPointRowsTag) == 0 || atv.compareTo(dataPointColsTag) == 0) {
            return new Long(0L);
        }
        if (atv.compareTo(refImageSQTag) == 0) {
            return "";
        }
        throw new IllegalArgumentException("Unable to provide default value for " + atv);
    }
}

