/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.dmtest;

import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import java.util.Vector;

public class FindDuplicateId {
    DMSession ses = null;
    DMObject[] comps = null;

    public FindDuplicateId(String[] args) {
        this.ses = new DMSession(args);
        this.comps = this.ses.getRelated("image");
    }

    private String getCompName(int i) {
        return this.ses.send("GetFilePath" + this.comps[i / 3].getID())[1];
    }

    public void printChildren(DMObject obj, int indent) {
        if (obj.getType().equalsIgnoreCase("patient")) {
            DMObject[] kids = obj.getRelated("study");
            System.out.println("");
            System.out.println("+Patient" + indent + ": " + obj.getValue(16, 16));
            for (int i = 0; i < kids.length; ++i) {
                this.printChildren(kids[i], i);
            }
        } else if (obj.getType().equalsIgnoreCase("study")) {
            DMObject[] kids = obj.getRelated("series");
            System.out.println("\t+Study" + indent + ": " + obj.getValue(32, 13));
            for (int i = 0; i < kids.length; ++i) {
                this.printChildren(kids[i], i);
            }
        } else if (obj.getType().equalsIgnoreCase("series")) {
            DMObject[] kids = obj.getRelated("image");
            System.out.println("\t\t+Series" + indent + ": " + obj.getValue(32, 14));
            for (int i = 0; i < kids.length; ++i) {
                this.printChildren(kids[i], i);
            }
        } else if (obj.getType().equalsIgnoreCase("image")) {
            System.out.println("\t\t\t+Image" + indent + ": " + obj.getValue(8, 24));
        }
    }

    public void reportContent() {
        DMObject[] pats = this.ses.getChildren();
        System.out.println("# patients= " + pats.length);
        for (int i = 0; i < pats.length; ++i) {
            this.printChildren(pats[i], i);
        }
    }

    private String getTagName(int i) {
        String tagName = "UNKNOWN";
        switch (i % 3) {
            case 0: {
                tagName = "SOP UID";
                break;
            }
            case 1: {
                tagName = "Series UID";
                break;
            }
            case 2: {
                tagName = "Study UID";
            }
        }
        return tagName;
    }

    public void reportDuplicateIds() {
        int i;
        String[] ids = new String[this.comps.length * 3];
        for (i = 0; i < this.comps.length; ++i) {
            ids[3 * i] = (String)this.comps[i].getValue(8, 24);
            ids[3 * i + 1] = (String)this.comps[i].getValue(32, 14);
            ids[3 * i + 2] = (String)this.comps[i].getValue(32, 13);
        }
        for (i = 0; i < ids.length; ++i) {
            if (ids[i] != null) continue;
            System.out.println(this.getCompName(i) + " missing " + this.getTagName(i));
            ids[i] = "";
        }
        Vector dups = FindDuplicateId.findDuplicates(ids);
        for (int i2 = 0; i2 < dups.size(); ++i2) {
            Vector v = (Vector)dups.get(i2);
            System.out.println("\n" + this.getCompName((Integer)v.get(0)) + " " + this.getTagName((Integer)v.get(0)) + " same as ");
            for (int j = 1; j < v.size(); ++j) {
                System.out.println("" + this.getCompName((Integer)v.get(j)) + " " + this.getTagName((Integer)v.get(j)));
            }
        }
    }

    public static Vector findDuplicates(String[] str) {
        Vector v = new Vector();
        for (int i = 0; i < str.length - 1; ++i) {
            for (int j = i + 1; j < str.length; ++j) {
                Vector<Integer> dups = new Vector<Integer>();
                dups.add(new Integer(i));
                boolean foundOne = false;
                if (str[i].trim().equalsIgnoreCase(str[j].trim())) {
                    dups.add(new Integer(j));
                    foundOne = true;
                }
                if (!foundOne) continue;
                v.add(dups);
            }
        }
        return v;
    }

    public static void usage() {
        System.out.println("Usage: com.ge.med.terra.tap.dm.dmtest.FindDuplicateId [-showContent] <session args>");
    }

    public static void main(String[] args) {
        if (args.length > 0 && args[0].equals("-showContent")) {
            String[] _args = new String[args.length - 1];
            for (int i = 1; i < args.length; ++i) {
                _args[i - 1] = args[i];
            }
            FindDuplicateId fd = new FindDuplicateId(_args);
            fd.reportContent();
        } else if (args.length > 2) {
            FindDuplicateId fd = new FindDuplicateId(args);
            fd.reportDuplicateIds();
        } else {
            FindDuplicateId.usage();
        }
    }
}

