/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.hyperpesi;

import com.ge.med.terra.tap.util.SimpleUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashSet;

public class DeleteList {
    private String filename = "ToDeleteList";
    private File topdir;
    private File delFileList;
    private HashSet<String> fileSet = new HashSet();
    private long modTime;
    Thread delThread;

    public DeleteList(String delFileLocation) {
        this.topdir = new File(delFileLocation);
        if (!this.topdir.exists()) {
            throw new IllegalArgumentException(delFileLocation + " does not exist");
        }
        this.delFileList = new File(this.topdir, this.filename);
        if (this.delFileList.exists()) {
            this.loadFileSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFileSet() {
        this.modTime = this.delFileList.lastModified();
        FileReader fr = null;
        BufferedReader br = null;
        try {
            String s;
            fr = new FileReader(this.delFileList);
            br = new BufferedReader(fr);
            while ((s = br.readLine()) != null) {
                this.fileSet.add(s);
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != fr) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != br) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] args) {
        try {
            boolean exists;
            int i;
            String dir = "C:\\Tmp\\pesitest\\p3\\e3\\s8";
            File[] listFiles = SimpleUtilities.getFilesRecursively(new File(dir));
            DeleteList df = new DeleteList("C\\tmp");
            System.out.println("=========================================");
            System.out.println("Adding the tobeDeleted Files in the to-be-deleted list...");
            for (i = 0; i < listFiles.length; ++i) {
                df.addFileToDeleteList(listFiles[i].getPath());
            }
            System.out.println("=====DONE======");
            System.out.println();
            System.out.println("The following entries should exist in the deleted file");
            for (i = 0; i < listFiles.length; ++i) {
                exists = df.isExists(listFiles[i].getPath());
                System.out.println("Found entry : " + listFiles[i].getPath() + " in the deleted file? " + exists);
            }
            System.out.println();
            System.out.println("===========================================");
            System.out.println("Removing the already deleted Files from the to-be-deleted list...");
            for (i = 0; i < listFiles.length; ++i) {
                df.removeFileFromDeleteList(listFiles[i].getPath());
            }
            System.out.println("=====DONE======");
            System.out.println();
            System.out.println("The following entries should NOT exist in the deleted file");
            for (i = 0; i < listFiles.length; ++i) {
                exists = df.isExists(listFiles[i].getPath());
                System.out.println("Found entry : " + listFiles[i].getPath() + " in the deleted file? " + exists);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileToDeleteList(String fileToDelete) {
        OutputStreamWriter fw = null;
        try {
            this.delFileList.createNewFile();
            if (this.isExists(fileToDelete)) {
                return;
            }
            fw = new FileWriter(this.delFileList, true);
            String toWrite = fileToDelete;
            fw.write(toWrite + "\n");
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        finally {
            if (null != fw) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.fileSet.add(fileToDelete);
        this.modTime = this.delFileList.lastModified();
        this.startBackgroundReconcile();
    }

    public void deleteFile(File f) {
        boolean ret = f.delete();
        if (!ret) {
            this.addFileToDeleteList(f.getAbsolutePath());
        }
    }

    public boolean unDeleteFile(String f) {
        if (this.isExists(f)) {
            this.removeFileFromDeleteList(f);
            return true;
        }
        return false;
    }

    private void startBackgroundReconcile() {
        if (this.delThread != null && this.delThread.isAlive()) {
            return;
        }
        this.delThread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        do {
                            String[] fileArr;
                            Thread.sleep(60000L);
                            for (String f : fileArr = DeleteList.this.fileSet.toArray(new String[DeleteList.this.fileSet.size()])) {
                                boolean ret = new File(f).delete();
                                if (!ret) continue;
                                DeleteList.this.removeFileFromDeleteList(f);
                            }
                        } while (!DeleteList.this.fileSet.isEmpty());
                        return;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
        this.delThread.setDaemon(true);
        this.delThread.start();
    }

    public void removeFileFromDeleteList(String deletedFile) {
        File tempFile = new File(this.delFileList.getAbsolutePath() + ".tmp");
        try {
            this.delFileList.createNewFile();
            if (!this.isExists(deletedFile)) {
                return;
            }
            BufferedReader br = new BufferedReader(new FileReader(this.delFileList));
            PrintWriter pw = new PrintWriter(new FileWriter(tempFile));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.trim().equals(deletedFile)) continue;
                pw.println(line);
                pw.flush();
            }
            pw.close();
            br.close();
            if (!this.delFileList.delete()) {
                System.out.println("Could not delete file");
                return;
            }
            if (!tempFile.renameTo(this.delFileList)) {
                System.out.println("Could not rename file");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.fileSet.remove(deletedFile);
        this.modTime = this.delFileList.lastModified();
    }

    public boolean isExists(String filename) {
        try {
            if (!this.delFileList.exists()) {
                return false;
            }
            if (this.modTime < this.delFileList.lastModified()) {
                this.loadFileSet();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.fileSet.contains(filename);
    }
}

