/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.hyperpesi;

import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.hyperpesi.HyperPesiObjectStore;
import com.ge.med.terra.tap.dm.hyperpesi.HyperPesiSession;
import com.ge.med.terra.tap.dm.pesi.PesiObject;
import com.ge.med.terra.tap.dm.pesi.PesiSession;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.io.File;
import java.io.FileFilter;
import java.util.HashSet;

public class HyperPesiObject
extends PesiObject {
    private HashSet cache = new HashSet();
    private String name;
    private File path;
    private HyperPesiObjectStore store;
    private HyperPesiSession session = null;

    public HyperPesiObject(String type, File path, HyperPesiSession ses) {
        super(type, path, ses);
        this.path = path;
        this.name = path.getName().replace('.', '_');
        this.session = ses;
        this.store = ses.makeObjectStore(path.getParent());
    }

    public void setCacheValue(tagValue tv) {
        Object o = this.store.getValue(this.name, tv.group, tv.element);
        if (!(tv.value == o || tv.value != null && tv.value.equals(o))) {
            this.store.setValue(this.name, tv.group, tv.element, tv.value);
        }
    }

    public Object getCacheValue(DMTag tv) {
        return this.store.getValue(this.name, tv.getGroup(), tv.getElement());
    }

    @Override
    protected PesiObject makePesiObject(String type, File path, PesiSession session) {
        return ((HyperPesiSession)session).makePesiObject(type, path);
    }

    void cache(String c) {
        if (c == null) {
            return;
        }
        String[] tags = c.split("\\|");
        for (int i = 0; i < tags.length; ++i) {
            this.cache.add(DMTag.parseTagString(tags[i]));
        }
    }

    @Override
    public Object getValue(DMTag t) {
        Object v = this.store.getValue(this.name, t.getGroup(), t.getElement());
        if (v != null) {
            return v;
        }
        return super.getValue(t);
    }

    @Override
    public void getValues(DMElement[] elements) {
        super.getValues(elements);
    }

    @Override
    public void setValues(DMElement[] elements) {
        super.setValues(elements);
    }

    @Override
    public void delete() {
        File f = this.path.getParentFile();
        int index = HyperPesiObject.getLevelNumber(this.getType());
        int parentIndex = index + 1;
        SimpleUtilities.deleteFilesRecursively(this.path);
        this.store.delete(this.name);
        this.cleanup(f, parentIndex);
    }

    @Override
    public void setLock(int lockType) {
    }

    private void cleanup(File f, int index) {
        if (null == f) {
            return;
        }
        File fileToDelete = f;
        while (null != fileToDelete && !fileToDelete.equals(this.session.rootDir)) {
            File[] subDirs = fileToDelete.listFiles(new FileFilter(){

                @Override
                public boolean accept(File dir) {
                    return dir.isDirectory();
                }
            });
            if (subDirs.length > 0) {
                System.out.println("Other subdirectories found under the parent node.. returning..");
                break;
            }
            File p = fileToDelete.getParentFile();
            HyperPesiObject delObj = new HyperPesiObject(levels[index], fileToDelete, this.session);
            for (File toDel : fileToDelete.listFiles()) {
                toDel.delete();
            }
            delObj.store.delete(delObj.name);
            fileToDelete.delete();
            fileToDelete = p;
        }
    }

    private static int getLevelNumber(String levelString) {
        for (int i = 0; i < levels.length; ++i) {
            if (!levels[i].equalsIgnoreCase(levelString)) continue;
            return i;
        }
        return -1;
    }
}

