/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.list;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.list.ListObjectInfo;
import com.ge.med.terra.tap.util.SimpleUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;

public class ListDB {
    protected File dbFile;
    protected Map dbMap;
    public static String DIR_PROPERTY = "tap.dm.list.basedir";

    public ListDB(String filename) {
        if (filename == null || filename.length() == 0) {
            throw new IllegalArgumentException("filename cannot be empty");
        }
        String baseDir = System.getProperty(DIR_PROPERTY);
        if (baseDir == null) {
            baseDir = SimpleUtilities.getTempDir();
        }
        this.dbFile = new File(baseDir + File.separator + filename + ".txt");
        this.loadDB();
    }

    public String[] getIds() {
        return this.dbMap.keySet().toArray(new String[this.dbMap.size()]);
    }

    public DMSession[] getSessions() {
        HashSet<String[]> set = new HashSet<String[]>();
        ListObjectInfo[] info = this.getAll();
        for (int i = 0; i < info.length; ++i) {
            set.add(info[i].getSessionArgs());
        }
        DMSession[] sessions = new DMSession[set.size()];
        int index = 0;
        for (String[] args : set) {
            sessions[index++] = DMSession.getSession(args);
        }
        return sessions;
    }

    public ListObjectInfo[] getAll() {
        return this.dbMap.values().toArray(new ListObjectInfo[this.dbMap.size()]);
    }

    public ListObjectInfo get(String id) {
        return (ListObjectInfo)this.dbMap.get(id);
    }

    public boolean contains(String id) {
        return this.dbMap.containsKey(id);
    }

    private boolean containsInfo(ListObjectInfo info) {
        boolean found = false;
        ListObjectInfo[] infoArray = this.getAll();
        for (int i = 0; !found && i < infoArray.length; ++i) {
            found = infoArray[i].equals(info);
        }
        return found;
    }

    public void add(ListObjectInfo info) {
        if (!this.containsInfo(info)) {
            Tap.log.log(Level.INFO, "Adding List Object Info: [{0}]", info);
            this.dbMap.put(info.getId(), info);
            this.saveDB();
        } else {
            Tap.log.log(Level.INFO, "Not Adding List Object Info [{0}]", info);
        }
    }

    public void remove(String id) {
        if (this.dbMap.containsKey(id)) {
            this.dbMap.remove(id);
            this.saveDB();
        }
    }

    public int size() {
        return this.dbMap.size();
    }

    private void loadDB() {
        this.dbMap = new TreeMap();
        if (this.dbFile.exists()) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(this.dbFile));
                while ((line = reader.readLine()) != null) {
                    ListObjectInfo info = this.parseInfo(line);
                    if (info == null) continue;
                    this.dbMap.put(info.getId(), info);
                }
                reader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void saveDB() {
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(this.dbFile, false));
            ListObjectInfo[] info = this.getAll();
            for (int i = 0; i < info.length; ++i) {
                writer.println(info[i].toString());
            }
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ListObjectInfo parseInfo(String str) {
        ListObjectInfo info = null;
        String[] chunks = str.split(";");
        if (chunks != null && chunks.length == 4) {
            info = new ListObjectInfo(chunks[0], chunks[1], chunks[2], chunks[3].split(","));
        }
        return info;
    }
}

