/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.mem;

import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.mem.MemImage;
import com.ge.med.terra.tap.dm.mem.MemSession;
import com.ge.med.terra.tap.dm.mem.memBuffer;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.sessionFile.dicomImageGen;
import com.ge.med.terra.tap.dm.sessionFile.fileSequence;
import com.ge.med.terra.tap.util.dicom.DicomComposite;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;

public class MemComposite
implements DMiComposite,
DMTagValueInterface {
    memBuffer data;
    MemSession ses;
    public static DMTag sopInstance = new DMTag(8, 24);
    HashMap cache = new HashMap();
    static tagValue tv = new tagValue();
    static tagValue[] tva = new tagValue[]{tv};

    public MemComposite(MemSession ses, memBuffer data) {
        this.data = data;
        this.ses = ses;
    }

    @Override
    public Object getValue(DMTag t) {
        if (this.cache.containsKey(t)) {
            return this.cache.get(t);
        }
        MemComposite.tv.group = t.getGroup();
        MemComposite.tv.element = t.getElement();
        try {
            this.ses.oparser.setFile(this.data.getInputStream());
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.ses.oparser.fill(tva);
        this.ses.oparser.clearFile();
        Object o = MemComposite.tv.vrep == 21329 ? new fileSequence(tv) : MemComposite.tv.value;
        this.cache.put(t, o);
        return o;
    }

    @Override
    public void getValues(DMElement[] elements) {
        this.getValues((tagValue[])elements);
    }

    public void getValues(tagValue[] elements) {
        Arrays.sort(elements);
        try {
            this.ses.oparser.setFile(this.data.getInputStream());
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.ses.oparser.fill(elements);
        this.ses.oparser.clearFile();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i].vrep == 21329) {
                elements[i].value = new fileSequence(elements[i]);
            }
            this.cache.put(new DMTag(elements[i].group, elements[i].element), elements[i].value);
        }
    }

    @Override
    public void setValues(DMElement[] elements) {
        DicomComposite obj = new DicomComposite();
        try {
            InputStream fis = this.data.getInputStream();
            obj.read(fis);
            fis.close();
            for (int j = 0; j < elements.length; ++j) {
                System.out.println("Updating: \n" + elements[j]);
                obj.setValue(elements[j].group, elements[j].element, elements[j].value);
            }
            OutputStream fos = this.data.getOutputStream();
            obj.write(fos, true);
            fos.close();
            for (int i = 0; i < elements.length; ++i) {
                DMTag t = new DMTag(elements[i].group, elements[i].element);
                if (!this.cache.containsKey(t)) continue;
                this.cache.put(t, elements[i].value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getType() {
        return "composite";
    }

    @Override
    public DMTag[] getTags() {
        try {
            this.ses.oparser.setFile(this.data.getInputStream());
        }
        catch (Exception exception) {
            // empty catch block
        }
        tagValue[] tv = this.ses.oparser.getTags();
        this.ses.oparser.clearFile();
        DMTag[] dt = new DMTag[tv.length];
        for (int i = 0; i < tv.length; ++i) {
            dt[i] = new DMTag(tv[i].group, tv[i].element, tv[i].vrString());
        }
        return dt;
    }

    @Override
    public void delete() {
        this.ses.compHash.remove(this.getID());
        this.data = null;
    }

    private void debugComposite() {
        try {
            this.ses.oparser.setFile(this.data.getInputStream());
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        while (this.ses.oparser.hasMoreTags()) {
            tagValue tv = this.ses.oparser.readNext();
            System.out.println(tv.fileOffset + ">" + tv);
        }
        this.ses.oparser.clearFile();
        System.out.flush();
    }

    @Override
    public BufferedImage[] getPixelData(DMTag[] tags) {
        this.debugComposite();
        System.err.println(">" + this.getID());
        try {
            this.ses.oparser.setFile(this.data.getInputStream());
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        BufferedImage[] bi = dicomImageGen.getImages(this.ses.oparser, tags);
        this.ses.oparser.clearFile();
        System.err.println(">" + this.getID());
        return bi;
    }

    @Override
    public String getID() {
        return (String)this.getValue(sopInstance);
    }

    @Override
    public InputStream getInputStream() {
        return this.data.getInputStream();
    }

    @Override
    public DMiImage[] getImages(DMTag[] tags) {
        return MemImage.wrap(this, this.getPixelData(tags));
    }

    @Override
    public String getFilePath() {
        throw new UnsupportedOperationException("Method getFilePath() not yet implemented.");
    }
}

