/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.mem;

import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.mem.MemComposite;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class MemImage
implements DMiImage {
    BufferedImage img;
    MemComposite comp;
    int frameNumber;

    public MemImage(MemComposite comp, BufferedImage img, int frameNumber) {
        this.comp = comp;
        this.img = img;
        this.frameNumber = frameNumber;
    }

    public static MemImage[] wrap(MemComposite comp, BufferedImage[] imgs) {
        MemImage[] mi = new MemImage[imgs.length];
        for (int i = 0; i < imgs.length; ++i) {
            mi[i] = new MemImage(comp, imgs[i], i);
        }
        return mi;
    }

    @Override
    public BufferedImage getPixelData() {
        return this.img;
    }

    @Override
    public Object getProperty(Object key) {
        return this.img.getProperty(key.toString());
    }

    @Override
    public void preLoad() {
    }

    @Override
    public void preUnload() {
    }

    @Override
    public void refresh() {
    }

    @Override
    public Object getValue(DMTag tag2) {
        return this.comp.getValue(tag2);
    }

    @Override
    public DMiComposite getComposite() {
        return this.comp;
    }

    @Override
    public void setState(int state) {
    }

    @Override
    public int getState() {
        return 0;
    }

    @Override
    public void setAccess(int access) {
    }

    @Override
    public int getAccess() {
        return 0;
    }

    @Override
    public int memorySize() {
        return this.img.getRaster().getDataBuffer().getSize();
    }

    @Override
    public void unloadImage() {
    }

    @Override
    public void loadImage() {
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.drawImage(this.img, x, y, c.getWidth(), c.getHeight(), null);
    }

    @Override
    public int getIconWidth() {
        return this.img.getWidth();
    }

    @Override
    public int getIconHeight() {
        return this.img.getHeight();
    }

    @Override
    public int getFrameNumber() {
        return this.frameNumber;
    }
}

