/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.network;

import com.archimed.dicom.DicomObject;
import com.archimed.dicom.UID;
import com.archimed.dicom.network.Acknowledge;
import com.archimed.dicom.network.Association;
import com.archimed.dicom.network.Request;
import com.archimed.dicom.network.Response;
import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.network.ScpService;
import com.ge.med.terra.tap.dm.network.scp;
import java.io.FileOutputStream;
import java.util.Properties;

public class ScpCreate
implements ScpService {
    boolean init = false;
    scp scp;
    Properties props = null;
    boolean debug = false;
    int[] cmds = new int[]{320};
    int[] sops = new int[]{4142};

    @Override
    public void init(scp scp2, Properties props) {
        this.debug = Tap.getProperty("tap.dm.scp.debug", "false").equalsIgnoreCase("true");
        this.scp = scp2;
        this.props = props;
        this.init = true;
    }

    @Override
    public int[] getSupportedSOPClass() {
        return this.sops;
    }

    @Override
    public int[] getSupportedCommands() {
        return this.cmds;
    }

    @Override
    public boolean doCommand(int command2, Association as, DicomObject dcm, Request request, Response response) {
        if (command2 == 320) {
            return this.doCreate(as, dcm, response);
        }
        return false;
    }

    public boolean doCreate(Association as, DicomObject dcm, Response response) {
        try {
            String pps_sopclass = UID.getUIDEntry(4142).getValue();
            String sopclass = dcm.getS(2);
            if (!sopclass.equals(pps_sopclass)) {
                System.out.println("wrong sop class in N-CREATE REQUEST: " + sopclass + " , aborting");
                as.sendAbort(0, 0);
                return false;
            }
            Integer messageid = (Integer)dcm.get(272);
            if (messageid == null) {
                System.out.println("message ID missing from N-CREATE REQUEST, aborting");
                as.sendAbort(0, 0);
                return false;
            }
            int dataSetType = dcm.getI(2048);
            if (dataSetType == 257) {
                System.out.println("No Data Set present as per Data Set Type tag, Aborting C-Store");
                as.sendAbort(0, 6);
                return false;
            }
            DicomObject data = as.receiveData();
            int associationTS = -1;
            if (response instanceof Acknowledge) {
                associationTS = ((Acknowledge)response).getTransferSyntax(0).getConstant();
            }
            DicomObject meta = new DicomObject();
            meta.set(131073, new byte[]{0, 1});
            meta.set(131074, pps_sopclass);
            meta.set(131075, dcm.get(4096));
            meta.set(131088, UID.getUIDEntry(associationTS).getValue());
            meta.set(131091, "GSP_TAP");
            data.setFileMetaInformation(meta);
            FileOutputStream fout = new FileOutputStream(com.ge.med.terra.tap.dm.network.scp.cstoreDir + "/" + dcm.get(4096));
            data.write(fout, true);
            fout.close();
            DicomObject responsedcm = new DicomObject();
            responsedcm.set(256, new Integer(33088));
            responsedcm.set(288, messageid);
            responsedcm.set(2048, new Integer(257));
            responsedcm.set(2304, new Integer(0));
            as.send(4142, responsedcm, null);
            System.out.println("sent N-CREATE RESPONSE");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }
}

