/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.network;

import com.archimed.dicom.DicomObject;
import com.archimed.dicom.UID;
import com.archimed.dicom.network.Association;
import com.archimed.dicom.network.Request;
import com.archimed.dicom.network.Response;
import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.network.ScpService;
import com.ge.med.terra.tap.dm.network.scp;
import java.util.Properties;

public class ScpEcho
implements ScpService {
    boolean init = false;
    scp scp;
    Properties props = null;
    boolean debug = false;
    int[] cmds = new int[]{48};
    int[] sops = new int[]{4097};

    @Override
    public void init(scp scp2, Properties props) {
        this.debug = Tap.getProperty("tap.dm.scp.debug", "false").equalsIgnoreCase("true");
        this.scp = scp2;
        this.props = props;
        this.init = true;
    }

    @Override
    public int[] getSupportedSOPClass() {
        return this.sops;
    }

    @Override
    public int[] getSupportedCommands() {
        return this.cmds;
    }

    @Override
    public boolean doCommand(int command2, Association as, DicomObject dcm, Request request, Response response) {
        if (command2 == 48) {
            return this.doEcho(as, dcm);
        }
        return false;
    }

    public boolean doEcho(Association as, DicomObject dcm) {
        try {
            String ve_sopclass = UID.getUIDEntry(4097).getValue();
            String sopclass = dcm.getS(2);
            if (!sopclass.equals(ve_sopclass)) {
                if (Tap.logLevel >= Tap.LEVEL_WARNING) {
                    Tap.log.warning("wrong sop class in C-ECHO REQUEST: " + sopclass + " , aborting");
                }
                as.sendAbort(0, 0);
                return false;
            }
            Integer messageid = (Integer)dcm.get(272);
            if (messageid == null) {
                if (Tap.logLevel >= Tap.LEVEL_WARNING) {
                    Tap.log.warning("message ID missing from C-ECHO REQUEST, aborting");
                }
                as.sendAbort(0, 0);
                return false;
            }
            if (Tap.logLevel >= Tap.LEVEL_FINE) {
                Tap.log.fine("receive C-ECHO REQUEST");
            }
            DicomObject responsedcm = new DicomObject();
            responsedcm.set(256, new Integer(32816));
            responsedcm.set(288, messageid);
            responsedcm.set(2048, new Integer(257));
            responsedcm.set(2304, new Integer(0));
            as.send(4097, responsedcm, null);
            if (Tap.logLevel >= Tap.LEVEL_FINE) {
                Tap.log.fine("sent C-ECHO RESPONSE");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

