/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.pesi;

import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.pesi.Vindex;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;

public class Vheaders {
    protected Vindex index;
    protected String vheadersPath;
    protected dicomParser parser = new dicomParser();
    protected HashMap[] cache;
    boolean useCache = true;

    public Vheaders(String vheadersPath, Vindex vheaderIndex) throws FileNotFoundException {
        this.vheadersPath = vheadersPath;
        this.index = vheaderIndex;
        if (this.useCache) {
            this.cache = new HashMap[this.index.count];
            for (int i = 0; i < this.cache.length; ++i) {
                this.cache[i] = new HashMap();
            }
        }
    }

    public void getImageTags(int imageNumber, DMElement[] fill) throws IOException {
        if (this.useCache) {
            int i;
            int count = 0;
            HashMap c = this.cache[imageNumber];
            DMTag[] tags = new DMTag[fill.length];
            for (int i2 = 0; i2 < fill.length; ++i2) {
                tags[i2] = new DMTag(fill[i2].group, fill[i2].element);
                if (c.containsKey(tags[i2])) {
                    fill[i2].value = c.get(tags[i2]);
                    continue;
                }
                ++count;
            }
            if (count == 0) {
                return;
            }
            DMElement[] rfill = new DMElement[count];
            int j = 0;
            for (i = 0; i < fill.length; ++i) {
                if (c.containsKey(tags[i])) continue;
                rfill[j] = fill[i];
                ++j;
            }
            this.getImageTags2(imageNumber, rfill);
            for (i = 0; i < fill.length; ++i) {
                if (c.containsKey(tags[i])) continue;
                c.put(tags[i], fill[i].value);
            }
        } else {
            this.getImageTags2(imageNumber, fill);
        }
    }

    public void getImageTags2(int imageNumber, DMElement[] fill) throws IOException {
        if (fill == null || fill.length == 0) {
            return;
        }
        tagValue[] get = fill;
        if (fill[fill.length - 1].is(32736, 16)) {
            get = new DMElement[fill.length - 1];
            System.arraycopy(fill, 0, get, 0, get.length);
        }
        FileInputStream fis = new FileInputStream(this.vheadersPath);
        fis.skip(this.index.headeroffset[imageNumber]);
        this.parser.setFile(fis);
        this.parser.fill(get);
        this.parser.clearFile();
        if (get != fill) {
            int last = fill.length - 1;
            fill[last].setFillValue(false);
            fill[last].fileOffset = this.index.pxloffset[imageNumber];
        }
    }
}

