/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.rm;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.util.logging.Level;

public final class BigHeaderFix {
    private static final int MIN_SIZE = 0x100000;
    private static final int LAST_GROUP = 40;
    private static final int END_GROUP = 32736;
    private static final int END_ELEMENT = 16;
    private tagValue beginTag = null;
    private tagValue endTag = null;
    private String src;

    public BigHeaderFix(String src) {
        this.src = src;
    }

    public boolean isBigHeader() {
        boolean isBig = false;
        dicomParser parser = new dicomParser();
        try {
            parser.setFile(this.src);
            this.beginTag = new tagValue(0, 0);
            while (parser.hasMoreTags() && 40 != this.beginTag.group) {
                this.beginTag = parser.skipNext();
            }
            if (40 != this.beginTag.group) {
                Tap.log.log(Level.WARNING, "Unable to find last group");
                return false;
            }
            while (parser.hasMoreTags() && 40 == this.beginTag.group) {
                this.beginTag = parser.skipNext();
            }
            if (40 == this.beginTag.group) {
                Tap.log.log(Level.WARNING, "Unable to find begin tag");
                return false;
            }
            Tap.log.log(Level.FINER, "The begin tag is {0} [{1}]", new Object[]{this.beginTag.toString(), this.src});
            this.endTag = this.beginTag;
            while (parser.hasMoreTags() && 32736 != this.endTag.group) {
                this.endTag = parser.skipNext();
            }
            if (32736 != this.endTag.group) {
                Tap.log.log(Level.WARNING, "Unable to find end group");
                return false;
            }
            while (parser.hasMoreTags() && 32736 == this.endTag.group && 16 != this.endTag.element) {
                this.endTag = parser.skipNext();
            }
            if (32736 != this.endTag.group || 16 != this.endTag.element) {
                Tap.log.log(Level.WARNING, "Unable to find end tag");
                return false;
            }
            Tap.log.log(Level.FINER, "The end tag is {0} [{1}]", new Object[]{this.endTag.toString(), this.src});
            long beginOffset = this.beginTag.fileOffset;
            long endOffset = this.endTag.fileOffset;
            Tap.log.log(Level.FINE, "Begin Offset={0}, End Offset={1} [{2}]", new Object[]{Long.toString(beginOffset), Long.toString(endOffset), this.src});
            if (endOffset - beginOffset > 0x100000L) {
                isBig = true;
            }
        }
        catch (Exception ex) {
            Tap.log.log(Level.WARNING, "Error when looking for begin/end tags: ", ex);
        }
        return isBig;
    }

    public void removeBigHeader(String dest) {
        try {
            Tap.log.log(Level.FINER, "The begin tag is {0} [{1}]", new Object[]{this.beginTag.toString(), this.src});
            Tap.log.log(Level.FINER, "The end tag is {0} [{1}]", new Object[]{this.endTag.toString(), this.src});
            int beginOffset = (int)this.beginTag.fileOffset;
            int endOffset = (int)this.endTag.fileOffset;
            Tap.log.log(Level.FINE, "Begin Offset={0}, End Offset={1} [{2}]", new Object[]{Long.toString(beginOffset), Long.toString(endOffset), this.src});
            FileOutputStream fos = new FileOutputStream(dest);
            RandomAccessFile raf = new RandomAccessFile(this.src, "r");
            BigHeaderFix.copysubFile(raf, fos, beginOffset);
            raf.seek(endOffset);
            BigHeaderFix.copysubFile(raf, fos, (int)raf.length() - endOffset);
            raf.close();
            fos.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void copysubFile(RandomAccessFile src, FileOutputStream fos, int nbytes) {
        int maxlen = nbytes;
        try {
            byte[] bbuff = new byte[32768];
            int len = 1;
            while (len != -1) {
                len = Math.min(bbuff.length, maxlen);
                if ((len = src.read(bbuff, 0, len)) > 0) {
                    maxlen -= len;
                    fos.write(bbuff, 0, len);
                }
                if (maxlen != 0) continue;
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

