/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.sessionFile;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMEvent;
import com.ge.med.terra.tap.dm.DMEventListener;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiJob;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.dm.peer.DMiObjectReceiver;
import com.ge.med.terra.tap.dm.peer.DMiSession;
import com.ge.med.terra.tap.dm.sessionFile.fileComposite;
import com.ge.med.terra.tap.dm.sessionFile.fileJob;
import com.ge.med.terra.tap.dm.sessionFile.fileObject;
import com.ge.med.terra.tap.dm.sessionFile.peerToPeerComm;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.URLReader;
import com.ge.med.terra.tap.util.dicom.TagValueList;
import com.ge.med.terra.tap.util.dicom.jdbCIOD;
import com.ge.med.terra.tap.util.dicom.jdbCIODs;
import com.ge.med.terra.tap.util.dicom.jdbIE;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;

public class fileSession
implements DMiSession {
    public static final String GET_FILE_PATH_CMD = "GetFilePath";
    public static final String PRINT_COMP_CACHE_CMD = "PrintCompCache";
    public static final String REMOVE_TAG_FROM_COMP_CACHE_CMD = "RemoveTagFromCompCache";
    public static final String CLEAR_COMP_CACHE_CMD = "ClearCompCache";
    protected File dir;
    public static String newFiles = "new";
    public static String stageFiles = "stage";
    public static String updateFiles = "update";
    public static String modifiedFiles = "modified";
    public static int updateFlagSocket = 8917;
    protected fileComposite[] comp;
    protected HashMap pat = new HashMap(20);
    protected Vector objectList = new Vector();
    protected static jdbCIODs iods = new jdbCIODs();
    protected HashMap allFileObjects = new HashMap(200);
    protected String session;
    protected String[] args;
    protected ArrayList jobs = new ArrayList();
    protected static DMTag classID = new DMTag(8, 22);
    protected TagValueList olist = null;
    private byte[] bbuff = new byte[32768];
    Vector[] listenerList = new Vector[10];
    protected peerToPeerComm p2pcomm;
    Thread th = null;
    boolean closeCalled = false;

    void addFileObject(TagValueList tvl, fileObject o) {
        this.allFileObjects.put(tvl, o);
    }

    fileObject getFileObject(TagValueList tvl) {
        return (fileObject)this.allFileObjects.get(tvl);
    }

    Iterator getListOfFileObjects() {
        return this.allFileObjects.values().iterator();
    }

    private void mapComposites() {
        for (int i = 0; i < this.comp.length; ++i) {
            this.addComposites(this.comp[i]);
        }
    }

    void addFileObject(fileObject fo) {
        this.objectList.add(fo);
    }

    protected void addComposites(fileComposite c) {
        jdbCIOD ciod;
        int count;
        Object o = c.getValue(classID);
        String str = null;
        str = o != null ? ((String)o).trim() : "0.0.0.0";
        jdbCIOD found = null;
        for (count = 0; count != fileSession.iods.ciodList.size(); ++count) {
            ciod = (jdbCIOD)fileSession.iods.ciodList.elementAt(count);
            if (!ciod.getUid().equals(str)) continue;
            found = ciod;
            break;
        }
        if (found == null) {
            str = "0.0.0.0";
        }
        for (count = 0; count != fileSession.iods.ciodList.size(); ++count) {
            ciod = (jdbCIOD)fileSession.iods.ciodList.elementAt(count);
            if (!ciod.getUid().equals(str)) continue;
            c.setCIOD(ciod);
            jdbIE ie = null;
            for (int i = 0; i < ciod.ieList.size() && !(ie = (jdbIE)ciod.ieList.get(i)).getIEName().equalsIgnoreCase("Patient"); ++i) {
            }
            TagValueList tlist = new TagValueList(ie.getUniqueTags());
            c.getValues(tlist);
            fileObject pobj = (fileObject)this.pat.get(tlist);
            if (pobj == null) {
                if (this.olist != null) {
                    this.olist = tlist;
                }
                pobj = new fileObject(this, c, ie);
                this.pat.put(tlist, pobj);
                break;
            }
            pobj.addComposite(c);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retryUpdates() {
        if (this.session != null && this.session.equals("URL")) {
            return;
        }
        File updateDir = new File(this.dir + File.separator + stageFiles, updateFiles);
        File modifiedDir = new File(updateDir, modifiedFiles);
        File[] updatedFiles = modifiedDir.listFiles();
        for (int i = 0; updatedFiles != null && i < updatedFiles.length; ++i) {
            final String fileName = updatedFiles[i].getName();
            File[] orig = this.dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.equals(fileName);
                }
            });
            if (orig.length == 0) {
                orig = new File(this.dir + File.separator + newFiles).listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.equals(fileName);
                    }
                });
            }
            orig[0].delete();
            if (updatedFiles[i].renameTo(orig[0])) continue;
            throw new DMException("Unable to update " + updatedFiles[i].getName());
        }
        modifiedDir.delete();
        File[] list = updateDir.listFiles();
        for (int i = 0; list != null && i < list.length; ++i) {
            if (!list[i].getName().endsWith(".elems")) continue;
            FileInputStream fis = null;
            ObjectInputStream in = null;
            try {
                String prefix = list[i].getName().substring(0, list[i].getName().indexOf("."));
                fis = new FileInputStream(updateDir + File.separator + prefix + ".elems");
                in = new ObjectInputStream(fis);
                DMElement[] elems = (DMElement[])in.readObject();
                in.close();
                fis = null;
                in = null;
                fis = new FileInputStream(updateDir + File.separator + prefix + ".rid");
                in = new ObjectInputStream(fis);
                String[] rid = (String[])in.readObject();
                in.close();
                DMiObject obj = this.getDMiObject(rid[0], rid[1]);
                if (obj != null) {
                    ((fileObject)obj).setValues(elems);
                }
                File f = new File(updateDir + File.separator + prefix + ".elems");
                f.delete();
                f = new File(updateDir + File.separator + prefix + ".rid");
                f.delete();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            finally {
                if (null != in) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        updateDir.delete();
    }

    @Override
    public void init(String session_, String[] args_) {
        int i;
        this.session = session_;
        if (args_ != null) {
            this.args = new String[args_.length];
            System.arraycopy(args_, 0, this.args, 0, args_.length);
        }
        ArrayList<Serializable> a = new ArrayList<Serializable>();
        if (this.session != null && !this.session.equals("URL")) {
            this.dir = new File(this.session);
            this.buildCompositeList(a, this.dir);
        } else if (this.session != null) {
            URLReader urlr = new URLReader();
            for (i = 0; i < this.args.length; ++i) {
                try {
                    if (this.args[i].endsWith("/")) {
                        String[] children = urlr.getFilesAsUrl(this.args[i]);
                        for (int j = 0; children != null && j < children.length; ++j) {
                            a.add(new URL(children[j]));
                        }
                        continue;
                    }
                    a.add(new URL(this.args[i]));
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            for (int i2 = 0; i2 < this.args.length; ++i2) {
                if (new File(this.args[i2]).isDirectory()) {
                    File[] files = SimpleUtilities.getFilesRecursively(new File(this.args[i2]));
                    for (int j = 0; j < files.length; ++j) {
                        a.add(files[j]);
                    }
                    continue;
                }
                a.add(new File(this.args[i2]));
            }
        }
        ArrayList<fileComposite> complist = new ArrayList<fileComposite>(a.size());
        for (i = 0; i < a.size(); ++i) {
            try {
                fileComposite c = this.session != null && this.session.equals("URL") ? new fileComposite(this, (URL)a.get(i)) : new fileComposite(this, (File)a.get(i));
                complist.add(c);
                this.addComposites(c);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.comp = complist.toArray(new fileComposite[complist.size()]);
        if (this.p2pcomm == null) {
            this.p2pcomm = new peerToPeerComm(this.session, this);
        }
        this.addDMEventListener(1, 0, new DMEventListener(){

            @Override
            public void actionPerformed(DMEvent e) {
                fileSession.this.newdata();
            }
        });
        this.setupJobManager();
        this.retryUpdates();
    }

    private void reInit() {
        int i;
        ArrayList<Serializable> a = new ArrayList<Serializable>();
        if (this.session != null && !this.session.equals("URL")) {
            this.dir = new File(this.session);
            this.buildCompositeList(a, this.dir);
        } else if (this.session != null) {
            for (i = 0; i < this.args.length; ++i) {
                try {
                    a.add(new URL(this.args[i]));
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            for (i = 0; i < this.args.length; ++i) {
                a.add(new File(this.args[i]));
            }
        }
        ArrayList<fileComposite> complist = new ArrayList<fileComposite>(a.size());
        for (int i2 = 0; i2 < a.size(); ++i2) {
            try {
                fileComposite c = this.session != null && this.session.equals("URL") ? new fileComposite(this, (URL)a.get(i2)) : new fileComposite(this, (File)a.get(i2));
                complist.add(c);
                this.addComposites(c);
                continue;
            }
            catch (Exception ex) {
                System.err.println("File = " + ((File)a.get(i2)).getAbsolutePath());
                ex.printStackTrace();
            }
        }
        this.comp = complist.toArray(new fileComposite[complist.size()]);
    }

    private void buildCompositeList(AbstractCollection a, File dir) {
        if (dir.isDirectory()) {
            File[] fd;
            if (!dir.getName().equals(stageFiles) && (fd = dir.listFiles()) != null) {
                for (int i = 0; i < fd.length; ++i) {
                    this.buildCompositeList(a, fd[i]);
                }
            }
        } else {
            a.add(dir);
        }
    }

    public fileComposite addComposite(String filename) {
        fileComposite c = null;
        try {
            c = new fileComposite(this, filename);
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
        fileComposite[] newcomplist = new fileComposite[this.comp.length + 1];
        System.arraycopy(this.comp, 0, newcomplist, 0, this.comp.length);
        newcomplist[this.comp.length] = c;
        this.comp = newcomplist;
        this.addComposites(c);
        for (fileObject fo : this.objectList) {
            fo.addCompositeIfValid(c);
        }
        return c;
    }

    @Override
    public DMiComposite getComposite(String id) {
        fileComposite fileComp = null;
        DMiComposite[] fc = this.getComposites();
        for (int i = 0; i < fc.length; ++i) {
            if (!((fileComposite)fc[i]).getID().equals(id)) continue;
            fileComp = (fileComposite)fc[i];
            return fileComp;
        }
        return fileComp;
    }

    @Override
    public DMiComposite[] getComposites() {
        return this.comp;
    }

    @Override
    public int getNumberOfComposites() {
        return this.comp.length;
    }

    @Override
    public DMiObject[] getRelated(String ieType, DMQuery query) {
        if (ieType.equalsIgnoreCase("patient")) {
            return this.getChildren(query);
        }
        HashMap<TagValueList, fileObject> childList = new HashMap<TagValueList, fileObject>();
        for (int i = 0; i < this.comp.length; ++i) {
            TagValueList tl;
            try {
                tl = this.comp[i].getUniqueValues(ieType);
            }
            catch (NullPointerException ex) {
                System.out.println("for the " + i + " file =" + this.comp[i].fileName);
                throw ex;
            }
            if (childList.containsKey(tl)) {
                ((fileObject)childList.get(tl)).addComposite(this.comp[i]);
                continue;
            }
            fileObject fo = this.getFileObject(tl);
            if (fo != null) {
                fo.addComposite(this.comp[i]);
                childList.put(tl, fo);
                continue;
            }
            if (tl == null || tl.value[0] == null) continue;
            childList.put(tl, new fileObject(this, this.comp[i], this.comp[i].getCIOD().getIE(ieType)));
        }
        fileObject[] fileObjs = new fileObject[childList.size()];
        int count = 0;
        for (Object obj : childList.values()) {
            fileObject o = (fileObject)obj;
            if (query != null && !query.valid(o)) continue;
            fileObjs[count++] = o;
        }
        DMiObject[] out = new fileObject[count];
        System.arraycopy(fileObjs, 0, out, 0, count);
        return out;
    }

    @Override
    public void getRelated(String type, DMQuery q, DMiObjectReceiver cb) {
        DMiObject[] io = this.getRelated(type, q);
        for (int i = 0; i < io.length && cb.gotOne(io[i]); ++i) {
        }
    }

    @Override
    public void getChildren(DMQuery q, DMiObjectReceiver cb) {
        DMiObject[] io = this.getChildren(q);
        for (int i = 0; i < io.length && cb.gotOne(io[0]); ++i) {
        }
    }

    @Override
    public DMiObject[] getChildren(DMQuery q) {
        DMiObject[] out;
        if (this.pat.size() == 0) {
            this.init(this.session, this.args);
        }
        Iterator i = this.pat.keySet().iterator();
        DMiObject[] fileArray = new DMiObject[this.pat.size()];
        int count = 0;
        while (i.hasNext()) {
            fileObject f = (fileObject)this.pat.get(i.next());
            if (q != null && !q.valid(f)) continue;
            fileArray[count++] = f;
        }
        if (this.pat.size() != count) {
            out = new DMiObject[count];
            System.arraycopy(fileArray, 0, out, 0, count);
        } else {
            out = fileArray;
        }
        for (int x = 0; x < out.length; ++x) {
        }
        return out;
    }

    public int getNumberOfChildren() {
        return this.pat.size();
    }

    @Override
    public void install(InputStream is) throws IOException {
        File newdir = new File(this.dir, newFiles);
        File stagedir = new File(this.dir, stageFiles);
        if (!newdir.exists()) {
            newdir.mkdir();
        }
        if (!stagedir.exists()) {
            stagedir.mkdir();
        }
        File newFile = File.createTempFile("comp", ".dcm", stagedir);
        File finalFile = null;
        FileOutputStream fos = new FileOutputStream(newFile);
        int len = 1;
        while (len != -1) {
            len = is.read(this.bbuff);
            if (len <= 0) continue;
            fos.write(this.bbuff, 0, len);
        }
        fos.close();
        is.close();
        finalFile = new File(newdir, newFile.getName());
        newFile.renameTo(finalFile);
        fileComposite c = this.addComposite(finalFile.getAbsolutePath());
        String msg = finalFile.getAbsolutePath().replace('\\', '/');
        this.sendEvent(1, msg, c.getID());
    }

    @Override
    public void installFiles(File[] files, boolean destroy) throws FileNotFoundException, IOException {
        File finalFile = null;
        File newdir = null;
        File stagedir = null;
        if (this.dir != null) {
            newdir = new File(this.dir, newFiles);
            stagedir = new File(this.dir, stageFiles);
            newdir.mkdir();
            stagedir.mkdir();
        }
        for (int i = 0; i < files.length; ++i) {
            if (this.dir != null) {
                File inputFile = files[i];
                File newFile = new File(stagedir, inputFile.getName());
                if (destroy) {
                    if (!inputFile.renameTo(newFile)) {
                        System.err.println("failed to move. file will be copied: " + inputFile.getAbsolutePath());
                        SimpleUtilities.copyFile(inputFile.getAbsolutePath(), newFile.getAbsolutePath());
                        inputFile.delete();
                    }
                } else {
                    FileOutputStream fos = new FileOutputStream(newFile);
                    FileInputStream fis = new FileInputStream(inputFile);
                    int len = 1;
                    while (len != -1) {
                        len = fis.read(this.bbuff);
                        if (len <= 0) continue;
                        fos.write(this.bbuff, 0, len);
                    }
                    fos.close();
                    fis.close();
                }
                finalFile = new File(newdir, newFile.getName());
                newFile.renameTo(finalFile);
            } else {
                finalFile = files[i];
            }
            fileComposite c = this.addComposite(finalFile.getAbsolutePath());
            String msg = finalFile.getAbsolutePath().replace('\\', '/');
            this.sendEvent(1, msg, c.getID());
        }
    }

    @Override
    public DMiObject getDMiObject(String type, String id) {
        fileObject obj = null;
        Iterator it = this.getListOfFileObjects();
        while (it.hasNext()) {
            obj = (fileObject)it.next();
            if (!obj.getType().equalsIgnoreCase(type) || !obj.getID().equals(id)) continue;
            return obj;
        }
        return null;
    }

    protected void newdata() {
        int i;
        ArrayList newList = new ArrayList();
        HashSet<String> oldList = new HashSet<String>();
        this.buildCompositeList(newList, this.dir);
        for (i = 0; i < this.comp.length; ++i) {
            oldList.add(this.comp[i].getFileName());
        }
        for (i = 0; i < newList.size(); ++i) {
            if (oldList.contains(((File)newList.get(i)).getAbsolutePath())) continue;
            this.addComposite(((File)newList.get(i)).getAbsolutePath());
        }
    }

    public DMiObject getDmObject(String idString) {
        StringTokenizer tok = new StringTokenizer(idString, "|");
        String level = tok.nextToken();
        String id = tok.nextToken();
        if (level.equalsIgnoreCase("P")) {
            String query = "(0x10, 0x10) = " + id + " && (0x10, 0x20) = " + tok.nextToken() + " && (0x10, 0x30) = " + tok.nextToken();
            return this.getRelated("patient", new DMQuery(query))[0];
        }
        if (level.equalsIgnoreCase("E")) {
            return this.getRelated("study", new DMQuery("(0x20, 0x0D) = " + id))[0];
        }
        if (level.equalsIgnoreCase("S")) {
            return this.getRelated("series", new DMQuery("(0x20, 0x0E) = " + id))[0];
        }
        if (level.equalsIgnoreCase("I")) {
            return this.getRelated("image", new DMQuery("(0x08, 0x18) = " + id))[0];
        }
        return null;
    }

    @Override
    public void addDMEventListener(int eventType, int freq, DMEventListener listener) {
        if (this.listenerList[eventType] == null) {
            this.listenerList[eventType] = new Vector();
            if (this.p2pcomm == null) {
                this.p2pcomm = new peerToPeerComm(this.dir.getAbsolutePath(), this);
            }
        }
        this.listenerList[eventType].add(listener);
    }

    @Override
    public void removeDMEventListener(DMEventListener l) {
        if (this.listenerList != null) {
            for (int i = 0; i < this.listenerList.length; ++i) {
                if (this.listenerList[i] == null) continue;
                this.listenerList[i].remove(l);
            }
        }
    }

    private void clearDMEventListener() {
        if (null != this.listenerList) {
            for (int i = 0; i < this.listenerList.length; ++i) {
                if (null == this.listenerList[i]) continue;
                this.listenerList[i].clear();
            }
        }
    }

    public void fireEvent(DMEvent event) {
        try {
            if (this.listenerList[event.getID()] == null) {
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return;
        }
        Iterator i = this.listenerList[event.getID()].iterator();
        while (i.hasNext()) {
            ((DMEventListener)i.next()).actionPerformed(event);
        }
    }

    public void sendEvent(int eventType, String msg, Object source) {
        this.fireEvent(new DMEvent(eventType, msg, source));
        this.p2pcomm.sendMessage("" + eventType + "|" + source.toString() + "|" + msg);
    }

    public void recivedEvent(String str) {
        StringTokenizer st = new StringTokenizer(str, "|");
        String code = st.nextToken();
        String source = st.nextToken() + "|" + st.nextToken();
        int type = Integer.parseInt(code);
        String rstr = st.nextToken();
        if (rstr.equals("Update")) {
            this.ClearCache();
        }
        this.fireEvent(new DMEvent(type, rstr, source));
    }

    public void removeCach(fileObject patient2) {
        Object[] keys = new Object[this.pat.size()];
        int count = 0;
        if (this.pat.containsValue(patient2)) {
            for (Object key : this.pat.keySet()) {
                if (!this.pat.get(key).equals(patient2)) continue;
                keys[count++] = key;
            }
        }
        for (int i = 0; i < count; ++i) {
            this.pat.remove(keys[i]);
        }
    }

    private fileComposite findComposite(String id) {
        fileObject obj;
        fileComposite comp = (fileComposite)this.getComposite(id);
        if (comp == null && null != (obj = (fileObject)this.getDmObject(id))) {
            fileComposite[] comps = (fileComposite[])obj.getComposites(null);
            comp = comps != null && comps.length > 0 ? comps[0] : null;
        }
        return comp;
    }

    @Override
    public String[] send(String str) {
        String[] ret = null;
        try {
            if ("OLD_GETRELATED".equals(str)) {
                fileObject.OLD_GETRELATED = true;
            } else if (str.startsWith(GET_FILE_PATH_CMD)) {
                String rid = str.substring(GET_FILE_PATH_CMD.length(), str.length());
                fileComposite comp = this.findComposite(rid);
                ret = null == comp ? new String[]{"-1"} : new String[]{"0", comp.getFileName()};
            } else if (str.startsWith(PRINT_COMP_CACHE_CMD)) {
                String rid = str.substring(PRINT_COMP_CACHE_CMD.length(), str.length());
                fileComposite comp = this.findComposite(rid);
                ret = new String[1];
                if (null == comp) {
                    ret[0] = "-1";
                } else {
                    ret[0] = "0";
                    comp.printCacheForDebugging();
                }
            } else if (str.startsWith(REMOVE_TAG_FROM_COMP_CACHE_CMD)) {
                String idAndTag = str.substring(REMOVE_TAG_FROM_COMP_CACHE_CMD.length(), str.length());
                String[] tokens = idAndTag.split(",");
                fileComposite comp = null;
                if (tokens.length == 3) {
                    comp = this.findComposite(tokens[0]);
                }
                ret = new String[1];
                if (null == comp) {
                    ret[0] = "-1";
                } else {
                    ret[0] = "0";
                    int group = Integer.decode(tokens[1]);
                    int element = Integer.decode(tokens[2]);
                    comp.removeTagFromCache(new DMTag(group, element));
                }
            } else if (str.startsWith(CLEAR_COMP_CACHE_CMD)) {
                String rid = str.substring(CLEAR_COMP_CACHE_CMD.length(), str.length());
                fileComposite comp = this.findComposite(rid);
                ret = new String[1];
                if (null == comp) {
                    ret[0] = "-1";
                } else {
                    ret[0] = "0";
                    comp.clearCache();
                }
            }
        }
        catch (Exception ex) {
            Tap.log.log(Level.WARNING, "Error during command execution: ", ex);
        }
        return ret;
    }

    @Override
    public DMiJob asynSend(String str) {
        return null;
    }

    @Override
    public void ClearCache() {
        this.objectList.clear();
        this.olist = null;
        Set keys = this.pat.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            fileComposite[] comps = (fileComposite[])((fileObject)this.pat.get(it.next())).getComposites(null);
            if (comps == null || comps.length <= 0) continue;
            for (int i = 0; i < comps.length; ++i) {
                comps[i].clearCache();
            }
        }
        this.pat.clear();
        keys = this.allFileObjects.keySet();
        it = keys.iterator();
        while (it.hasNext()) {
            fileObject fo = (fileObject)this.allFileObjects.get(it.next());
            fo.allChildObjects.clear();
            fileComposite[] comps = (fileComposite[])fo.getComposites(null);
            if (comps == null || comps.length <= 0) continue;
            for (int i = 0; i < comps.length; ++i) {
                comps[i].clearCache();
            }
        }
        this.allFileObjects.clear();
        this.reInit();
    }

    @Override
    public DMiJob[] getJobs() {
        DMiJob[] jbs = new DMiJob[this.jobs.size()];
        for (int i = 0; i < this.jobs.size(); ++i) {
            jbs[i] = (DMiJob)this.jobs.get(i);
        }
        return jbs;
    }

    public String getRootDir() {
        return this.dir.getAbsolutePath();
    }

    @Override
    public void save(DMiObject o, Hashtable prop) {
        fileJob j = new fileJob(this, 0, o);
        Enumeration v = prop.keys();
        String key = null;
        while (v.hasMoreElements()) {
            key = (String)v.nextElement();
            j.setProperty(key, prop.get(key));
        }
        j.setJobHandle(j.hashCode());
        this.addJob(j);
        j.waitForCompletion();
    }

    @Override
    public void save(DMiObject[] o, Hashtable prop) {
        for (int i = 0; i < o.length; ++i) {
            this.save(o[i], prop);
        }
    }

    @Override
    public void save(DMiComposite o, Hashtable prop) {
        fileJob j = new fileJob(this, 1, o);
        Enumeration en = prop.keys();
        String key = null;
        while (en.hasMoreElements()) {
            key = (String)en.nextElement();
            j.setProperty(key, prop.get(key));
        }
        j.setJobHandle(j.hashCode());
        this.addJob(j);
        j.waitForCompletion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(fileJob j) {
        ArrayList arrayList = this.jobs;
        synchronized (arrayList) {
            this.jobs.add(j);
            this.jobs.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJob(fileJob j) {
        ArrayList arrayList = this.jobs;
        synchronized (arrayList) {
            this.jobs.remove(j);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearJobs() {
        ArrayList arrayList = this.jobs;
        synchronized (arrayList) {
            this.jobs.clear();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private void setupJobManager() {
        this.th = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!fileSession.this.closeCalled) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(200L);
                        ArrayList arrayList = fileSession.this.jobs;
                        synchronized (arrayList) {
                            if (fileSession.this.jobs.isEmpty()) {
                                fileSession.this.jobs.wait();
                            } else {
                                for (int i = 0; i < fileSession.this.jobs.size(); ++i) {
                                    if (((fileJob)fileSession.this.jobs.get(i)).getState() != 2) continue;
                                    ((fileJob)fileSession.this.jobs.get(i)).start();
                                    break;
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof InterruptedException) continue;
                        e.printStackTrace();
                    }
                }
            }
        }, "fileSession.JobMgr");
        this.th.setDaemon(true);
        this.th.start();
    }

    @Override
    public void close() {
        if (!this.closeCalled) {
            this.closeCalled = true;
            this.p2pcomm.killThread();
            this.clearDMEventListener();
            try {
                this.th.interrupt();
            }
            catch (Exception e) {
                System.out.println("Handled Exception: " + e.getMessage());
            }
            this.clearJobs();
        }
    }
}

