/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.tools;

import com.ge.med.terra.tap.dm.DMComposite;
import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMObjectReceiver;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.tools.ChangeDicom;
import com.ge.med.terra.tap.dm.tools.TagPanel;
import com.ge.med.terra.tap.util.SimpleUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class PesiEditor
extends JPanel {
    JTree tree = new JTree();
    TagPanel tab = new TagPanel();
    SetTabModel stm = new SetTabModel();
    JTable setTab = new JTable(this.stm);
    JScrollPane setPane = new JScrollPane(this.setTab);
    String pesiPath = null;
    DMSession dms;
    DmTreeModel tmodel;
    JTextField group = new JTextField("");
    JTextField element = new JTextField("");
    JTextField value = new JTextField("");

    public PesiEditor() {
        this.tab.setPreferredSize(new Dimension(512, 512));
        this.setPane.setPreferredSize(new Dimension(200, 200));
        this.setLayout(new BorderLayout());
        JMenuBar bar = new JMenuBar();
        this.add((Component)bar, "North");
        JMenu fileMenu = new JMenu("File");
        bar.add(fileMenu);
        JMenuItem fileItem = new JMenuItem("Open");
        fileMenu.add(fileItem);
        this.tab.addChangeListener(new TagPanel.TagChangeListener(){

            @Override
            public void tvChanged(int group, int element, Object value) {
                PesiEditor.this.addTagToChange(group, element, value);
            }
        });
        fileItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PesiEditor.this.open();
            }
        });
        JPanel left = new JPanel(new BorderLayout());
        JPanel right = new JPanel(new BorderLayout());
        JPanel leftBottom = new JPanel();
        JPanel rightBottom = new JPanel(new BorderLayout());
        JPanel rightBB = new JPanel();
        left.add((Component)leftBottom, "South");
        this.add((Component)left, "West");
        this.add((Component)right, "Center");
        JButton dup = new JButton("Dup");
        JButton del = new JButton("Delete");
        left.add((Component)this.tree, "Center");
        right.add((Component)this.tab, "Center");
        right.add((Component)rightBottom, "South");
        rightBottom.add((Component)new JLabel("----------------setValues----------------", 0), "North");
        rightBottom.add((Component)this.setPane, "Center");
        rightBottom.add((Component)rightBB, "South");
        JLabel groupL = new JLabel("group:");
        rightBB.add(groupL);
        this.group.setColumns(3);
        rightBB.add(this.group);
        JLabel elemL = new JLabel("elem:");
        rightBB.add(elemL);
        this.element.setColumns(3);
        rightBB.add(this.element);
        JLabel valueL = new JLabel("val:");
        rightBB.add(valueL);
        this.value.setColumns(10);
        rightBB.add(this.value);
        JButton add = new JButton("Add");
        rightBB.add(add);
        add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PesiEditor.this.addTagToChange(Integer.decode(PesiEditor.this.group.getText()), Integer.decode(PesiEditor.this.element.getText()), PesiEditor.this.value.getText());
            }
        });
        JButton clear = new JButton("Clear");
        rightBB.add(clear);
        clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PesiEditor.this.clear();
            }
        });
        JButton apply = new JButton("Apply");
        rightBB.add(apply);
        apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PesiEditor.this.applyChanges();
            }
        });
        leftBottom.add(dup);
        leftBottom.add(del);
        dup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PesiEditor.this.dup();
            }
        });
        del.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PesiEditor.this.delete();
            }
        });
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent se) {
                TreePath path = se.getNewLeadSelectionPath();
                if (path == null) {
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                System.out.println(node.getUserObject().getClass());
                DMObject dmo = (DMObject)node.getUserObject();
                DMComposite[] dmc = dmo.getComposites();
                if (dmc.length < 1) {
                    System.out.println(dmo.getID() + " contains no composites!");
                    return;
                }
                PesiEditor.this.tab.setComposites(dmc);
                PesiEditor.this.tab.setTagVieweingMode(path.getPathCount());
                System.out.println(path.getPathCount());
            }
        });
    }

    public void addTagToChange(int group, int element, Object value) {
        this.stm.add(group, element, value);
        this.stm.fireTableDataChanged();
    }

    private void open() {
        Preferences p = Preferences.userNodeForPackage(this.getClass());
        String last = p.get("lastdir", null);
        JFileChooser fc = new JFileChooser(last);
        fc.setFileSelectionMode(1);
        fc.setMultiSelectionEnabled(false);
        int ret = fc.showDialog(this, "Load");
        if (ret == 0) {
            this.setPesiPath(fc.getSelectedFile().getAbsolutePath());
            p.put("lastdir", fc.getSelectedFile().getAbsolutePath());
        }
    }

    public void setPesiPath(String path) {
        this.pesiPath = path;
        this.dms = new DMSession("pesi", path, null);
        this.dms.send("RestrictImages=false");
        this.tmodel = new DmTreeModel(new DefaultMutableTreeNode());
        this.tree.setRootVisible(false);
        this.tree.setModel(this.tmodel);
        this.tmodel.setSession(this.dms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dup() {
        this.setCursor(new Cursor(3));
        try {
            TreePath path = this.tree.getLeadSelectionPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            DMObject dmo = (DMObject)node.getUserObject();
            System.out.println("dmo id = " + dmo.getID());
            String fpath = dmo.getID();
            int end = fpath.length() - 1;
            while (Character.isDigit(fpath.charAt(end))) {
                --end;
            }
            String s = fpath.substring(0, end + 1);
            System.out.println(s);
            System.out.println(" === " + fpath.substring(end + 1));
            int c = Integer.parseInt(fpath.substring(end + 1)) + 1;
            String npath = s + c;
            while (new File(npath).exists()) {
                npath = s + ++c;
            }
            System.out.println("copying to new path " + npath);
            PesiEditor.copyRec(fpath, npath);
            ChangeDicom fz = new ChangeDicom();
            fz.randShift += npath.hashCode();
            int level = 0;
            if ("patient".equalsIgnoreCase(dmo.getType())) {
                level = 0;
            } else if ("study".equalsIgnoreCase(dmo.getType())) {
                level = 1;
            } else if ("series".equalsIgnoreCase(dmo.getType())) {
                level = 2;
            } else if ("image".equalsIgnoreCase(dmo.getType())) {
                level = 3;
            }
            System.out.println("level=" + level);
            fz.setLevel((byte)level);
            String[] list = ChangeDicom.listAllFiles(npath);
            for (int j = 0; j < list.length; ++j) {
                fz.processFile(list[j]);
            }
            this.setPesiPath(this.pesiPath);
        }
        finally {
            this.setCursor(null);
        }
    }

    private void delete() {
        TreePath path = this.tree.getLeadSelectionPath();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        DMObject dmo = (DMObject)node.getUserObject();
        System.out.println("dmo id = " + dmo.getID());
        String fpath = dmo.getID();
        int ret = JOptionPane.showConfirmDialog(this, "You are about to delete " + fpath, "Deleting files", 2);
        if (ret == 2) {
            return;
        }
        SimpleUtilities.deleteFilesRecursively(new File(fpath));
        this.setPesiPath(this.pesiPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyChanges() {
        this.setCursor(new Cursor(3));
        try {
            TreePath path = this.tree.getLeadSelectionPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            DMObject dmo = (DMObject)node.getUserObject();
            dmo.setValues(this.stm.tv);
            this.setPesiPath(this.pesiPath);
        }
        finally {
            this.setCursor(null);
        }
    }

    private void clear() {
        this.stm.tv = new DMElement[0];
        this.stm.fireTableDataChanged();
    }

    private static void copyRec(String src, String dest) {
        File srcd = new File(src);
        if (!srcd.isDirectory()) {
            PesiEditor.copyFile(src, dest);
            return;
        }
        System.out.println("copying " + srcd.getAbsolutePath());
        File destd = new File(dest);
        destd.mkdir();
        File[] src_f = srcd.listFiles();
        for (int i = 0; i < src_f.length; ++i) {
            PesiEditor.copyRec(src_f[i].getAbsolutePath(), new File(destd, src_f[i].getName()).getAbsolutePath());
        }
    }

    private static void copyFile(String src, String dest) {
        try {
            FileInputStream fis = new FileInputStream(src);
            PesiEditor.copyFile(fis, dest);
            fis.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void copyFile(InputStream src, String dest) {
        FileOutputStream fos = null;
        try {
            byte[] bbuff = new byte[32768];
            File newfile = new File(dest);
            if (!newfile.exists()) {
                newfile.getParentFile().mkdirs();
            }
            fos = new FileOutputStream(dest);
            int len = 1;
            while (len != -1) {
                len = src.read(bbuff);
                if (len <= 0) continue;
                fos.write(bbuff, 0, len);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (null != fos) {
                try {
                    fos.close();
                }
                catch (IOException ioex) {
                    throw new RuntimeException(ioex);
                }
            }
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("PesiEditor 2.0");
        PesiEditor p = new PesiEditor();
        f.setContentPane(p);
        f.setBounds(100, 100, 700, 512);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }

    class DmTreeModel
    extends DefaultTreeModel {
        DMSession ses;
        private String[] level;
        private boolean cancelFlag;
        DMObjectReceiver rec;

        public DmTreeModel(DefaultMutableTreeNode root) {
            super(root);
            this.level = new String[]{"patient", "study", "series", "image"};
            this.cancelFlag = false;
            this.rec = new DMObjectReceiver(){

                @Override
                public boolean gotOne(DMObject obj) {
                    DmTreeModel.this.adddata((DefaultMutableTreeNode)DmTreeModel.this.root, obj, 1);
                    DmTreeModel.this.nodeStructureChanged(DmTreeModel.this.root);
                    if (DmTreeModel.this.cancelFlag) {
                        DmTreeModel.this.cancelFlag = false;
                        return DmTreeModel.this.cancelFlag;
                    }
                    return true;
                }
            };
        }

        public void refresh() {
            ((DefaultMutableTreeNode)this.root).removeAllChildren();
            this.nodeStructureChanged(this.root);
            this.ses.getRelated(this.level[0], null, this.rec);
        }

        public void setSession(DMSession ses) {
            this.ses = ses;
            this.refresh();
        }

        public void adddata(DefaultMutableTreeNode node, DMObject dmo, int n) {
            DefaultMutableTreeNode mtn = new DefaultMutableTreeNode(dmo);
            node.add(mtn);
            if (n == this.level.length) {
                return;
            }
            DMObject[] c = dmo.getRelated(this.level[n]);
            for (int i = 0; c != null && i < c.length; ++i) {
                this.adddata(mtn, c[i], n + 1);
            }
        }

        public void cancel() {
            this.cancelFlag = true;
        }
    }

    class SetTabModel
    extends AbstractTableModel {
        DMElement[] tv = new DMElement[0];
        String[] name = new String[]{"group", "element", "value"};

        SetTabModel() {
        }

        public void add(int group, int element, Object value) {
            System.out.println("add " + group + " " + element + " " + value);
            DMElement[] ntv = new DMElement[this.tv.length + 1];
            System.arraycopy(this.tv, 0, ntv, 0, this.tv.length);
            ntv[this.tv.length] = new DMElement(group, element);
            ntv[this.tv.length].value = value;
            this.tv = ntv;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex != 2) {
                return;
            }
            this.tv[rowIndex].value = aValue;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.name[columnIndex];
        }

        @Override
        public int getRowCount() {
            return this.tv.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            DMElement e = this.tv[rowIndex];
            switch (columnIndex) {
                case 0: {
                    return "0x" + Integer.toHexString(e.group);
                }
                case 1: {
                    return "0x" + Integer.toHexString(e.element);
                }
                case 2: {
                    return e.value;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 2;
        }
    }
}

