/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.volume;

import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMVolume;
import com.ge.med.terra.tap.dm.volume.Vinfo;
import com.ge.med.terra.tap.dm.volume.VolumeInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class VolumeDemo
extends JPanel {
    DMVolume dmv;
    int mode = 1;
    int[] dim = new int[3];
    BufferedImage img;
    int[] imgdata;
    short[] sum;
    short[] volume;
    DMVolume olddmv = null;
    int oldmode = this.mode;
    static long oldptime = System.nanoTime();
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    vpanel canvas = new vpanel();
    JButton jPload = new JButton();
    JTextField dir = new JTextField();
    JPanel jPanel2 = new JPanel();
    JButton jBget = new JButton();
    JButton jBset = new JButton();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JTextField jTinfo = new JTextField();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JComboBox jCmode = new JComboBox<String>(new String[]{"T", "S", "C"});

    public VolumeDemo() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("VolumeDemo");
        VolumeDemo p = new VolumeDemo();
        f.setContentPane(p);
        f.setDefaultCloseOperation(3);
        f.setBounds(10, 10, 512, 512);
        f.setVisible(true);
    }

    public void render(int w, int h, Graphics2D g2d) throws IOException {
        int i;
        VolumeDemo.ptime(null);
        g2d.setPaint(new GradientPaint(0.0f, 0.0f, Color.BLUE, w, h, Color.BLACK));
        g2d.fillRect(0, 0, w, h);
        g2d.setPaint(null);
        if (this.dmv == null) {
            return;
        }
        if (this.olddmv != this.dmv || this.mode != this.oldmode) {
            this.olddmv = this.dmv;
            this.oldmode = this.mode;
            this.dim = this.dmv.getVolumeDimensions(this.dim);
            int iw = this.dim[0 + this.mode];
            int ih = this.dim[(1 + this.mode) % 3];
            this.img = new BufferedImage(iw, ih, 1);
            this.imgdata = ((DataBufferInt)this.img.getRaster().getDataBuffer()).getData();
            this.sum = new short[iw * ih];
            this.volume = new short[this.dim[0] * this.dim[1]];
        }
        for (int i2 = 0; i2 < this.sum.length; ++i2) {
            this.sum[i2] = 0;
        }
        block6: for (int z = 0; z < this.dim[2]; ++z) {
            ByteBuffer buff = this.dmv.getSliceBuffer(z);
            buff.asShortBuffer().get(this.volume);
            this.dmv.closeLastBuffer();
            switch (this.mode) {
                case 0: {
                    for (i = 0; i < this.dim[1] * this.dim[0]; ++i) {
                        if (this.sum[i] >= this.volume[i]) continue;
                        this.sum[i] = this.volume[i];
                    }
                    continue block6;
                }
                case 1: {
                    int x;
                    int y;
                    i = 0;
                    for (y = 0; y < this.dim[1]; ++y) {
                        for (x = 0; x < this.dim[0]; ++x) {
                            if (this.sum[y + z * this.dim[1]] < this.volume[i]) {
                                this.sum[y + z * this.dim[1]] = this.volume[i];
                            }
                            ++i;
                        }
                    }
                    continue block6;
                }
                case 2: {
                    int x;
                    int y;
                    i = 0;
                    for (y = 0; y < this.dim[1]; ++y) {
                        for (x = 0; x < this.dim[0]; ++x) {
                            if (this.sum[z + x * this.dim[2]] < this.volume[i]) {
                                this.sum[z + x * this.dim[2]] = this.volume[i];
                            }
                            ++i;
                        }
                    }
                    continue block6;
                }
            }
        }
        short min = Short.MAX_VALUE;
        short max = Short.MIN_VALUE;
        for (i = 0; i < this.sum.length; ++i) {
            if (min > this.sum[i]) {
                min = this.sum[i];
                continue;
            }
            if (max >= this.sum[i]) continue;
            max = this.sum[i];
        }
        System.out.println("min,max=" + min + "," + max);
        min = 0;
        for (i = 0; i < this.sum.length; ++i) {
            int v = (this.sum[i] - min) * 255 / (max - min);
            if (v > 255) {
                v = 255;
            }
            this.imgdata[i] = 0xFF000000 | v * 65793;
        }
        Graphics g = this.img.getGraphics();
        g.setColor(Color.red);
        g2d.drawImage(this.img, 0, 0, w, h, null);
        VolumeDemo.ptime("render:");
    }

    static void ptime(String msg) {
        long ptime = System.nanoTime();
        if (msg != null) {
            System.out.println(msg + " " + (float)(ptime - oldptime) * 1.0E-9f + " sec");
        }
        oldptime = ptime;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jPload.setText("Load");
        this.jPload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VolumeDemo.this.jPload_actionPerformed(e);
            }
        });
        this.dir.setPreferredSize(new Dimension(140, 20));
        this.dir.setText("D:\\dev\\images\\pesi\\p30\\e46\\s90");
        this.jBget.setText("get");
        this.jBget.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VolumeDemo.this.jBget_actionPerformed(e);
            }
        });
        this.jBset.setText("Set");
        this.jBset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VolumeDemo.this.jBset_actionPerformed(e);
            }
        });
        this.jLabel1.setText("Info File:");
        this.jLabel2.setText(" : ");
        this.jPanel2.setLayout(this.gridBagLayout1);
        this.jCmode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VolumeDemo.this.jCmode_actionPerformed(e);
            }
        });
        this.jPanel1.add(this.jCmode);
        this.jPanel1.add(this.jPload);
        this.jPanel1.add(this.dir);
        this.add((Component)this.canvas, "Center");
        this.add((Component)this.jPanel2, "South");
        this.add((Component)this.jPanel1, "North");
        this.jPanel2.add((Component)this.jLabel2, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.jPanel2.add((Component)this.jTinfo, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.jPanel2.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.jPanel2.add((Component)this.jBget, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 2, 5, 2), 0, 0));
        this.jPanel2.add((Component)this.jBset, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 2, 5, 2), 0, 0));
    }

    public void jPload_actionPerformed(ActionEvent e) {
        DMSession dm = new DMSession("file", this.dir.getText(), null);
        this.dmv = DMVolume.buildVolume("DMObjectVolume", dm.getChildren());
        this.repaint();
    }

    public void jBget_actionPerformed(ActionEvent e) {
        this.jTinfo.setText(this.dmv.getInfoFileName().getPath());
    }

    public void jBset_actionPerformed(ActionEvent e) {
        String infoFile = this.jTinfo.getText();
        try {
            Vinfo inf = Vinfo.atach(infoFile);
            VolumeInfo v = (VolumeInfo)inf.getHeader(VolumeInfo.class.getName());
            this.dmv = v.getVolume();
            this.canvas.repaint();
        }
        catch (Exception ex) {
            System.err.println("failed to load \"" + infoFile + "\"");
            ex.printStackTrace();
        }
    }

    public void jCmode_actionPerformed(ActionEvent e) {
        this.mode = this.jCmode.getSelectedIndex();
        this.canvas.repaint();
    }

    class vpanel
    extends JPanel {
        vpanel() {
        }

        @Override
        public void paintComponent(Graphics g) {
            try {
                VolumeDemo.this.render(this.getWidth(), this.getHeight(), (Graphics2D)g);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

