/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.volume;

import com.ge.med.idc.XjImage;
import com.ge.med.idc.XjTagValue;
import com.ge.med.idc.XjVolume;
import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMVolume;
import com.ge.med.terra.tap.dm.volume.DMinfoVolume;
import com.ge.med.terra.tap.dm.volume.Vinfo;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;

public class VolumeInfo
extends Vinfo
implements XjVolume {
    protected int len = 0;
    protected int offset = 0;
    protected FileChannel channel;
    protected MappedByteBuffer map;
    int base_offset;
    int[] intBuff = new int[6];
    String basePath = null;
    byte[] bytBuf = new byte[128];
    static dicomParser dp = new dicomParser();
    private static final int off_dim = 12;
    private static final int off_oneFile = 24;
    private static final int off_pixelType = 28;
    private static final int off_BitsPerVoxel = 32;
    private static final int off_VolumeLittleEndian = 36;
    private static final int off_RASOrigin = 40;
    private static final int off_XDirectionRAS = 64;
    private static final int off_YDirectionRAS = 88;
    private static final int off_ZDirectionRAS = 112;
    private static final int off_refDicomFile = 136;
    private static final int off_baseFileName = 264;
    private static final int off_filename = 392;
    private static final int off_offsets = 392;
    private static final int STRING_SIZE = 128;

    public XjImage getImage(int _int) {
        return null;
    }

    public VolumeInfo() {
    }

    void fillFromFile(int len, int base_offset, HashMap all, String name, FileChannel ch, MappedByteBuffer map) {
        this.len = len;
        this.offset = base_offset;
        this.all = all;
        this.channel = ch;
        this.map = map;
        this.name = name;
    }

    private void getBasePath() {
        this.map.position(264);
        this.map.get(this.bytBuf);
        this.basePath = new String(this.bytBuf).trim();
    }

    @Override
    public int[] getVolumeDimensions(int[] intArray) {
        if (intArray == null) {
            intArray = new int[3];
        }
        this.map.position(12);
        this.map.asIntBuffer().get(intArray);
        return intArray;
    }

    @Override
    public double[] getRASOfOrigin(double[] doubleArray) {
        if (doubleArray == null) {
            doubleArray = new double[3];
        }
        this.map.position(40);
        this.map.asDoubleBuffer().get(doubleArray);
        return doubleArray;
    }

    @Override
    public double[] getXDirectionRAS(double[] doubleArray) {
        if (doubleArray == null) {
            doubleArray = new double[3];
        }
        this.map.position(64);
        this.map.asDoubleBuffer().get(doubleArray);
        return doubleArray;
    }

    @Override
    public double[] getYDirectionRAS(double[] doubleArray) {
        if (doubleArray == null) {
            doubleArray = new double[3];
        }
        this.map.position(88);
        this.map.asDoubleBuffer().get(doubleArray);
        return doubleArray;
    }

    @Override
    public double[] getZDirectionRAS(double[] doubleArray) {
        if (doubleArray == null) {
            doubleArray = new double[3];
        }
        this.map.position(112);
        this.map.asDoubleBuffer().get(doubleArray);
        return doubleArray;
    }

    @Override
    public long getVSliceOffset(int slice) {
        int[] dim = this.getVolumeDimensions(null);
        int offoff = 392 + dim[2] * 128 + slice * 8;
        this.map.position(offoff);
        return this.map.asLongBuffer().get();
    }

    @Override
    public String getRelatedComposite() {
        this.map.position(136);
        this.map.get(this.bytBuf);
        return new String(this.bytBuf).trim();
    }

    @Override
    public String getVSlicePath(int slice) {
        if (this.basePath == null) {
            this.getBasePath();
        }
        this.map.position(392 + slice * 128);
        this.map.get(this.bytBuf);
        return this.basePath + new String(this.bytBuf).trim();
    }

    @Override
    public int getBitsPerVoxel() {
        this.map.position(32);
        return this.map.asIntBuffer().get();
    }

    @Override
    public int getPixelType() {
        this.map.position(28);
        return this.map.asIntBuffer().get();
    }

    @Override
    public boolean isVolumeLittleEndian() {
        this.map.position(36);
        return this.map.asIntBuffer().get() != 0;
    }

    @Override
    public Object getVSliceValue(int sliceNo, int group, int element) {
        try {
            dp.setFile(this.getRelatedComposite());
            tagValue[] tv = new tagValue[]{new tagValue(group, element)};
            dp.fill(tv);
            dp.clearFile();
            return tv[0].value;
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void getVSliceValues(int sliceNo, DMElement[] dme) {
        try {
            dp.setFile(this.getRelatedComposite());
            dp.fill(dme);
            dp.clearFile();
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getPath() {
        return this.name;
    }

    @Override
    public Object getValue(int group, int element) {
        return this.getVSliceValue(0, group, element);
    }

    @Override
    public int getValues(XjTagValue[] xjTagValueArray) {
        try {
            dp.setFile(this.getRelatedComposite());
            tagValue[] data = DMElement.genDMelements(xjTagValueArray);
            dp.fill(data);
            dp.clearFile();
            return DMElement.getXjTagValue((DMElement[])data, xjTagValueArray);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static VolumeInfo createTmpInfo(DMVolume volume) throws IOException {
        File f = File.createTempFile("volume", ".vif");
        f.deleteOnExit();
        return new VolumeInfo(f.getAbsolutePath(), volume);
    }

    public DMVolume getVolume() {
        return new DMinfoVolume(this);
    }

    public VolumeInfo(String name, DMVolume volume) throws FileNotFoundException, IOException {
        int i;
        this.name = name;
        int[] iData = new int[10];
        double[] dData = new double[12];
        byte[] sData = null;
        int bitsPerVoxel = volume.getBitsPerVoxel();
        int pixelType = volume.getPixelType();
        boolean littleEndian = volume.isVolumeLittleEndian();
        int[] dim = volume.getVolumeDimensions(null);
        double[] rASOfOrigin = volume.getRASOfOrigin(null);
        double[] xDir = volume.getXDirectionRAS(null);
        double[] yDir = volume.getYDirectionRAS(null);
        double[] zDir = volume.getZDirectionRAS(null);
        String[] fileNames = new String[dim[2]];
        long[] offsets = new long[dim[2]];
        for (int i2 = 0; i2 < offsets.length; ++i2) {
            fileNames[i2] = volume.getVSlicePath(i2);
            offsets[i2] = volume.getVSliceOffset(i2);
        }
        boolean oneFile = true;
        for (int i3 = 0; i3 < fileNames.length; ++i3) {
            if (fileNames[i3].equals(fileNames[0])) continue;
            oneFile = false;
            break;
        }
        String base = fileNames[0];
        if (!oneFile) {
            boolean done = false;
            System.err.println("striping base " + base);
            while (!done) {
                done = true;
                for (i = 0; i < fileNames.length; ++i) {
                    if (fileNames[i].indexOf(base) == 0) continue;
                    done = false;
                }
                if (done) continue;
                base = base.substring(0, base.length() - 1);
            }
            System.err.println("striping base " + base);
        }
        int p = 0;
        iData[p++] = 0;
        iData[p++] = 0;
        iData[p++] = -1;
        iData[p++] = dim[0];
        iData[p++] = dim[1];
        iData[p++] = dim[2];
        iData[p++] = oneFile ? 1 : 0;
        iData[p++] = pixelType;
        iData[p++] = bitsPerVoxel;
        iData[p++] = littleEndian ? 1 : 0;
        p = 0;
        for (i = 0; i < rASOfOrigin.length; ++i) {
            dData[p++] = rASOfOrigin[i];
        }
        for (i = 0; i < xDir.length; ++i) {
            dData[p++] = xDir[i];
        }
        for (i = 0; i < yDir.length; ++i) {
            dData[p++] = yDir[i];
        }
        for (i = 0; i < zDir.length; ++i) {
            dData[p++] = zDir[i];
        }
        VolumeInfo.pl(iData);
        VolumeInfo.pl(dData);
        sData = new byte[(dim[2] + 2) * 128];
        p = 0;
        System.err.println("encoding ref \"" + volume.getRelatedComposite() + "\"");
        byte[] rComp = volume.getRelatedComposite().getBytes();
        System.arraycopy(rComp, 0, sData, 128 * p++, rComp.length);
        System.err.println("encoding base\"" + base + "\"");
        System.arraycopy(base.getBytes(), 0, sData, 128 * p++, base.length());
        for (int i4 = 0; i4 < fileNames.length; ++i4) {
            System.err.println("encoding file[" + i4 + "]\"" + fileNames[i4] + "\"");
            String sub = fileNames[i4].substring(base.length());
            System.arraycopy(sub.getBytes(), 0, sData, 128 * p++, sub.length());
        }
        File f = new File(name);
        RandomAccessFile r = new RandomAccessFile(f, "rw");
        this.len = iData.length * 4 + dData.length * 8 + sData.length + offsets.length * 8;
        System.err.println("40=" + iData.length * 4);
        System.err.println("96=" + dData.length * 8);
        r.setLength(this.len);
        iData[2] = this.len;
        this.channel = r.getChannel();
        this.map = this.channel.map(FileChannel.MapMode.READ_WRITE, 0L, f.length());
        this.map.position(0);
        this.map.asIntBuffer().put(iData);
        this.map.position(40);
        this.map.asDoubleBuffer().put(dData);
        this.map.position(136);
        this.map.put(sData);
        this.map.position(392 + 128 * fileNames.length);
        System.err.println("length=" + (this.len - this.map.position()));
        this.map.asLongBuffer().put(offsets);
    }

    @Override
    protected int getGroup() {
        return 0;
    }

    @Override
    protected int getElement() {
        return 0;
    }

    public void printData() {
        this.printData(System.out);
    }

    public void debugMap() {
        int[] iData = new int[10];
        double[] dData = new double[12];
        this.map.position(0);
        this.map.asIntBuffer().get(iData);
        VolumeInfo.pl(iData);
        this.map.position(40);
        this.map.asDoubleBuffer().get(dData);
        VolumeInfo.pl(dData);
    }

    public static void pl(int[] a) {
        for (int i = 0; i < a.length; ++i) {
            System.out.print((i == 0 ? "" : ",") + a[i]);
        }
        System.out.println();
    }

    public static void pl(double[] a) {
        for (int i = 0; i < a.length; ++i) {
            System.out.print((i == 0 ? "" : ",") + a[i]);
        }
        System.out.println();
    }

    public void printData(PrintStream out) {
        out.println(this.GROUP + "," + this.ELEMENT);
        int[] dim = this.getVolumeDimensions(null);
        double[] rASOfOrigin = this.getRASOfOrigin(null);
        double[] xDir = this.getXDirectionRAS(null);
        double[] yDir = this.getYDirectionRAS(null);
        double[] zDir = this.getZDirectionRAS(null);
        out.println("                 dim =" + dim[0] + "x" + dim[1] + "x" + dim[2]);
        out.println("        getPixelType = " + this.getPixelType());
        out.println("isVolumeLittleEndian = " + this.isVolumeLittleEndian());
        out.println("         rASOfOrigin =" + rASOfOrigin[0] + "x" + rASOfOrigin[1] + "x" + rASOfOrigin[2]);
        out.println("                xDir =" + xDir[0] + "x" + xDir[1] + "x" + xDir[2]);
        out.println("                yDir =" + yDir[0] + "x" + yDir[1] + "x" + yDir[2]);
        out.println("                zDir =" + zDir[0] + "x" + zDir[1] + "x" + zDir[2]);
        out.println("                zDir =" + zDir[0] + "x" + zDir[1] + "x" + zDir[2]);
        for (int i = 0; i < dim[2]; ++i) {
            out.println("          slice(" + i + ") =" + this.getVSlicePath(i) + "(" + this.getVSliceOffset(i) + ")");
        }
    }
}

