/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dmui.table;

import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.peerutils.Util;
import com.ge.med.terra.tap.dmui.table.DmuFormatterAdapter;
import java.util.ArrayList;
import java.util.Comparator;

public class DmuFormatIS
extends DmuFormatterAdapter {
    protected String tagStr = "(0x0020,0x0011)";
    protected Comparator<DMObject> iscomp = new Comparator<DMObject>(){

        @Override
        public int compare(DMObject dmo1, DMObject dmo2) {
            if (dmo1 == null) {
                return 1;
            }
            if (dmo2 == null) {
                return -1;
            }
            Object value1 = dmo1.getValue(DmuFormatIS.this.tagStr);
            Object value2 = dmo2.getValue(DmuFormatIS.this.tagStr);
            if (value1 == null) {
                return 1;
            }
            if (value2 == null) {
                return -1;
            }
            String s1 = value1.toString();
            String s2 = value2.toString();
            try {
                int num1 = DmuFormatIS.parse(s1);
                int num2 = DmuFormatIS.parse(s2);
                return num1 - num2;
            }
            catch (NumberFormatException nfex) {
                return 0;
            }
        }
    };

    public DmuFormatIS() {
    }

    public DmuFormatIS(String str) {
        this.tagStr = str;
    }

    @Override
    public int getPreferredWidth() {
        return 100;
    }

    @Override
    public Comparator getComparator() {
        return this.iscomp;
    }

    @Override
    public DMTag[] getNeededTags() {
        String[] tagStrs = Util.breakupString(this.tagStr);
        ArrayList<DMTag> tags = new ArrayList<DMTag>(tagStrs.length);
        for (int i = 0; i < tagStrs.length; ++i) {
            if ((i & 1) != 0) continue;
            tags.add(DMTag.parseTagString(tagStrs[i]));
        }
        return tags.toArray(new DMTag[tags.size()]);
    }

    @Override
    public Object getValue(DMTagValueInterface tagValIF) {
        Object value = Util.getValue(tagValIF, this.tagStr);
        if (null == value) {
            return "";
        }
        String str = value.toString();
        try {
            int num = DmuFormatIS.parse(str);
            return num;
        }
        catch (NumberFormatException ex) {
            return str;
        }
    }

    public static int parse(String str) throws NumberFormatException {
        String val;
        val = val.substring((val = str.trim()).charAt(0) == '+' ? 1 : 0);
        int num = Integer.parseInt(val);
        return num;
    }
}

