/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dmui.table;

import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.peerutils.Util;
import com.ge.med.terra.tap.dmui.table.DmuFormatterAdapter;
import com.ge.med.terra.tap.util.dicom.PersonName;
import java.util.ArrayList;
import java.util.Comparator;

public class DmuFormatPN
extends DmuFormatterAdapter {
    protected String tagStr = "(0x0010,0x0010)";
    protected Comparator<DMObject> pncomp = new Comparator<DMObject>(){

        @Override
        public int compare(DMObject dmo1, DMObject dmo2) {
            if (dmo1 == null) {
                return 1;
            }
            if (dmo2 == null) {
                return -1;
            }
            PersonName pn1 = new PersonName((String)dmo1.getValue(DmuFormatPN.this.tagStr));
            PersonName pn2 = new PersonName((String)dmo2.getValue(DmuFormatPN.this.tagStr));
            String s1 = pn1.toFormattedString();
            String s2 = pn2.toFormattedString();
            return s1.compareToIgnoreCase(s2);
        }
    };

    public DmuFormatPN() {
    }

    public DmuFormatPN(String str) {
        this.tagStr = str;
    }

    @Override
    public String getName() {
        return "PN Formatter";
    }

    @Override
    public int getPreferredWidth() {
        return 160;
    }

    @Override
    public Comparator<DMObject> getComparator() {
        return this.pncomp;
    }

    @Override
    public DMTag[] getNeededTags() {
        String[] tagStrs = Util.breakupString(this.tagStr);
        ArrayList<DMTag> tags = new ArrayList<DMTag>(tagStrs.length);
        for (int i = 0; i < tagStrs.length; ++i) {
            if ((i & 1) != 0) continue;
            tags.add(DMTag.parseTagString(tagStrs[i]));
        }
        return tags.toArray(new DMTag[tags.size()]);
    }

    @Override
    public Object getValue(DMTagValueInterface tagValIF) {
        String str = (String)Util.getValue(tagValIF, this.tagStr);
        String pnStr = PersonName.toFormattedString(str);
        return pnStr;
    }

    @Override
    public String getToolTip(DMTagValueInterface tagValIF) {
        String exchangeFormat = null;
        if (null != tagValIF) {
            exchangeFormat = (String)Util.getValue(tagValIF, this.tagStr);
        }
        return exchangeFormat;
    }
}

