/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dmui.table;

import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.peerutils.Util;
import com.ge.med.terra.tap.dmui.table.DmuFormatterAdapter;
import java.util.ArrayList;
import java.util.Comparator;

public class DmuFormatSH
extends DmuFormatterAdapter {
    protected String tagStr = "(0x0020,0x0010)";
    protected Comparator<DMObject> shcomp = new Comparator<DMObject>(){

        @Override
        public int compare(DMObject dmo1, DMObject dmo2) {
            if (dmo1 == null) {
                return 1;
            }
            if (dmo2 == null) {
                return -1;
            }
            Object value1 = dmo1.getValue(DmuFormatSH.this.tagStr);
            Object value2 = dmo2.getValue(DmuFormatSH.this.tagStr);
            if (value1 == null) {
                return 1;
            }
            if (value2 == null) {
                return -1;
            }
            String s1 = value1.toString();
            String s2 = value2.toString();
            Integer num1 = null;
            Integer num2 = null;
            try {
                num1 = new Integer(Integer.parseInt(s1));
                num2 = new Integer(Integer.parseInt(s2));
                return num1 - num2;
            }
            catch (NumberFormatException ex) {
                if (num1 == null && num2 == null) {
                    return s1.compareTo(s2);
                }
                if (num1 == null) {
                    return 1;
                }
                return -1;
            }
        }
    };

    public DmuFormatSH() {
    }

    public DmuFormatSH(String str) {
        this.tagStr = str;
    }

    @Override
    public int getPreferredWidth() {
        return 50;
    }

    @Override
    public Comparator<DMObject> getComparator() {
        return this.shcomp;
    }

    @Override
    public DMTag[] getNeededTags() {
        String[] tagStrs = Util.breakupString(this.tagStr);
        ArrayList<DMTag> tags = new ArrayList<DMTag>(tagStrs.length);
        for (int i = 0; i < tagStrs.length; ++i) {
            if ((i & 1) != 0) continue;
            tags.add(DMTag.parseTagString(tagStrs[i]));
        }
        return tags.toArray(new DMTag[tags.size()]);
    }

    @Override
    public Object getValue(DMTagValueInterface tagValIF) {
        String shStr = "";
        Object obj = Util.getValue(tagValIF, this.tagStr);
        if (null != obj) {
            shStr = obj.toString();
        }
        return shStr;
    }
}

