/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dmui.table;

import com.ge.med.terra.tap.dmui.table.DmuFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

public class DmuTableColumnModel
extends DefaultTableColumnModel {
    protected List totalList = new ArrayList();
    protected Set hiddenList = new HashSet();
    protected boolean[] visibility;
    protected DmuFormatter[] formatters;

    public Enumeration getColumns(boolean includeHidden) {
        return includeHidden ? Collections.enumeration(this.totalList) : this.getColumns();
    }

    public int getTotalColumnCount() {
        return this.totalList.size();
    }

    public int getHiddenColumnCount() {
        return this.hiddenList.size();
    }

    public int getVisibleColumnCount() {
        return this.getColumnCount();
    }

    public Enumeration getHiddenColumns() {
        return Collections.enumeration(this.hiddenList);
    }

    public TableColumn getInternalColumn(int index) {
        return (TableColumn)this.totalList.get(index);
    }

    public boolean[] getColumnVisibility() {
        boolean[] b;
        if (this.visibility != null) {
            b = this.visibility;
        } else {
            b = new boolean[this.totalList.size()];
            for (int i = 0; i < b.length; ++i) {
                b[i] = true;
            }
        }
        return b;
    }

    public void setColumnVisibility(boolean[] b) {
        if (this.totalList.size() != b.length) {
            throw new IllegalArgumentException("number of flags doesn't match the number of columns");
        }
        this.visibility = b;
        for (int i = 0; i < this.visibility.length; ++i) {
            TableColumn column = (TableColumn)this.totalList.get(i);
            if (this.visibility[i]) {
                this.setColumnVisible(column);
                continue;
            }
            this.setColumnHidden(column);
        }
    }

    @Override
    public void addColumn(TableColumn column) {
        if (!this.columnExists(column)) {
            this.totalList.add(column);
            super.addColumn(column);
            if (this.visibility != null && this.visibility.length == this.totalList.size()) {
                this.setColumnVisibility(this.visibility);
            }
        }
        this.applyFormatters();
    }

    @Override
    public void removeColumn(TableColumn column) {
        this.hiddenList.remove(column);
        this.totalList.remove(column);
        super.removeColumn(column);
        if (this.getColumnCount() == 0) {
            this.clear();
        }
    }

    @Override
    public void moveColumn(int columnIndex, int newIndex) {
        this.shiftColumns(columnIndex, newIndex);
        super.moveColumn(columnIndex, newIndex);
    }

    private void shiftColumns(int oldIndex, int newIndex) {
        if (oldIndex != newIndex) {
            TableColumn sourceColumn = (TableColumn)this.tableColumns.elementAt(oldIndex);
            int oldPosition = this.totalList.indexOf(sourceColumn);
            TableColumn targetColumn = (TableColumn)this.tableColumns.elementAt(newIndex);
            int newPosition = this.totalList.indexOf(targetColumn);
            this.totalList.remove(oldPosition);
            this.totalList.add(newPosition, sourceColumn);
        }
    }

    public void clear() {
        this.hiddenList.clear();
        this.totalList.clear();
    }

    public boolean isColumnVisible(TableColumn column) {
        return !this.hiddenList.contains(column);
    }

    private boolean columnExists(Object identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("Identifier is null");
        }
        for (int i = 0; i < this.totalList.size(); ++i) {
            TableColumn column = (TableColumn)this.totalList.get(i);
            if (!identifier.equals(column.getIdentifier())) continue;
            return true;
        }
        return false;
    }

    protected void setColumnHidden(TableColumn column) {
        if (this.isColumnVisible(column)) {
            this.hiddenList.add(column);
            super.removeColumn(column);
        }
    }

    protected void setColumnVisible(TableColumn column) {
        if (!this.isColumnVisible(column)) {
            this.hiddenList.remove(column);
            super.addColumn(column);
            int addIndex = this.totalList.indexOf(column);
            for (int i = 0; i < this.getColumnCount() - 1; ++i) {
                TableColumn tableColumn = this.getColumn(i);
                int actualPosition = this.totalList.indexOf(tableColumn);
                if (actualPosition <= addIndex) continue;
                super.moveColumn(this.getColumnCount() - 1, i);
                break;
            }
        }
    }

    public void setFormatter(DmuFormatter[] formatters) {
        this.formatters = formatters;
        this.applyFormatters();
    }

    protected void applyFormatters() {
        if (this.formatters == null || this.formatters.length != this.totalList.size()) {
            return;
        }
        for (int i = 0; i < this.formatters.length; ++i) {
            DmuFormatter formatter = this.formatters[i];
            TableColumn column = this.getInternalColumn(i);
            column.setPreferredWidth(formatter.getPreferredWidth());
            if (formatter.getMaxWidth() > 0) {
                column.setMaxWidth(formatter.getMaxWidth());
            }
            if (formatter.getMinWidth() > 0) {
                column.setMinWidth(formatter.getMinWidth());
            }
            if (formatter.getRenderer() != null) {
                column.setCellRenderer(formatter.getRenderer());
            }
            if (formatter.getEditor() == null) continue;
            column.setCellEditor(formatter.getEditor());
        }
    }
}

