/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dmui.table;

import com.ge.med.terra.tap.dmui.table.DmuTableColumnModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;

public class DmuTableControlPopup
extends JPopupMenu {
    private ArrayList actions;
    private DmuTableColumnModel model;
    private TableColumnModelListener listener;

    public DmuTableControlPopup(DmuTableColumnModel model) {
        this.model = model;
        this.actions = new ArrayList();
        this.listener = new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                DmuTableControlPopup.this.populatePopup();
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
                if (e.getFromIndex() != e.getToIndex()) {
                    DmuTableControlPopup.this.populatePopup();
                }
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
                DmuTableControlPopup.this.populatePopup();
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        };
        model.addColumnModelListener(this.listener);
    }

    @Override
    public void show(Component invoker, int x, int y) {
        if (this.getComponentCount() > 0) {
            super.show(invoker, x, y);
        }
    }

    protected void populatePopup() {
        this.removeAll();
        this.actions.clear();
        Enumeration columns = this.model.getColumns(true);
        while (columns.hasMoreElements()) {
            TableColumn column = (TableColumn)columns.nextElement();
            boolean visible = this.model.isColumnVisible(column);
            DmuColumnAction action = new DmuColumnAction(column, visible);
            this.actions.add(action);
            JCheckBoxMenuItem cb = new JCheckBoxMenuItem(action);
            cb.setSelected(visible);
            this.add(cb);
        }
    }

    private void enableLastAction(boolean b) {
        for (int i = 0; i < this.actions.size(); ++i) {
            DmuColumnAction action = (DmuColumnAction)this.actions.get(i);
            if (action.isSelected() == b) continue;
            action.setEnabled(b);
            break;
        }
    }

    private class DmuColumnAction
    extends AbstractAction {
        private TableColumn column;
        private boolean selected;

        public DmuColumnAction(TableColumn column) {
            this.column = column;
            this.selected = true;
            Object value = column.getHeaderValue();
            if (value instanceof Icon) {
                this.putValue("SmallIcon", (Icon)value);
            } else {
                this.putValue("Name", value.toString());
            }
        }

        public DmuColumnAction(TableColumn column, boolean selected) {
            this(column);
            this.selected = selected;
        }

        public boolean isSelected() {
            return this.selected;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean bl = this.selected = !this.selected;
            if (this.selected) {
                if (DmuTableControlPopup.this.model.getVisibleColumnCount() == 1) {
                    DmuTableControlPopup.this.enableLastAction(true);
                }
                DmuTableControlPopup.this.model.setColumnVisible(this.column);
            } else {
                DmuTableControlPopup.this.model.setColumnHidden(this.column);
                if (DmuTableControlPopup.this.model.getVisibleColumnCount() == 1) {
                    DmuTableControlPopup.this.enableLastAction(false);
                }
            }
        }
    }
}

