/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dmui.table;

import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMObjectReceiver;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dmui.table.DmuFormatDefault;
import com.ge.med.terra.tap.dmui.table.DmuFormatNull;
import com.ge.med.terra.tap.dmui.table.DmuFormatter;
import com.ge.med.terra.tap.dmui.table.DmuRowFormatter;
import com.ge.med.terra.tap.dmui.table.DmuRowFormatterAdapter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.table.DefaultTableModel;

public class DmuTableModel
extends DefaultTableModel {
    private static HashMap<String, String> formatMap = new HashMap();
    protected int sortCol = -1;
    protected boolean sortDown = true;
    private Object[] colNames = new String[]{"Patient Name", "Date Of Birth", "Series No", "Date", "Description"};
    private String[] columns = new String[]{"PatientName", "PatientDOB", "0x0020,0x0011", "StudyDate", "0x0020,0x10"};
    private DmuFormatter[] formatters = null;
    private DmuRowFormatter rowFormatter = new DmuRowFormatterAdapter();
    private DmuRowFormatter selectedRowFormatter = new DmuRowFormatterAdapter();
    private DMElement[] elem;
    private DMQuery query = null;
    private int level = 1;
    private static String[] model;
    private boolean[] loaded = new boolean[20];
    private Vector data = new Vector();
    private int lastUpdate = -1;
    private int unInserted = -1;
    private boolean autoSort = false;
    private Comparator sortUsing = null;
    private Object timerLock = new Object();
    private Timer tim = new Timer(100, new ActionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            int u = DmuTableModel.this.unInserted;
            if (u != -1) {
                if (DmuTableModel.this.autoSort) {
                    DmuTableModel.this.fireTableDataChanged();
                } else {
                    DmuTableModel.this.fireTableRowsInserted(DmuTableModel.this.lastUpdate, u);
                    DmuTableModel.this.sortCol = -1;
                }
            }
            DmuTableModel.this.lastUpdate = u;
            Object object = DmuTableModel.this.timerLock;
            synchronized (object) {
                DmuTableModel.this.tim.stop();
                DmuTableModel.this.timerLock.notifyAll();
            }
        }
    });
    private ModelReceiver rec;

    public DmuTableModel() {
        this.setColumnTypes(this.columns);
    }

    @Override
    public String getColumnName(int columnIndex) {
        Object col = this.colNames[columnIndex];
        return col instanceof String ? (String)col : "";
    }

    public Object getColName(int columnIndex) {
        return this.colNames[columnIndex];
    }

    public Object[] getColNames() {
        return this.colNames;
    }

    public void setColNames(Object[] colNames) {
        this.colNames = colNames;
        this.fireTableStructureChanged();
    }

    public String[] getColumnTypes() {
        return this.columns;
    }

    public void setColumnTypes(String[] cols) {
        this.columns = cols;
        this.formatters = new DmuFormatter[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            String f = formatMap.get(cols[i]);
            if (f != null) {
                try {
                    int bracket = f.indexOf("(");
                    if (bracket > 0) {
                        String fclass = f.substring(0, bracket);
                        String arg = f.substring(bracket + 1, f.length() - 1);
                        Class[] strarg = new Class[]{String.class};
                        Constructor<?> c = Class.forName(fclass).getConstructor(strarg);
                        this.formatters[i] = (DmuFormatter)c.newInstance(arg);
                        continue;
                    }
                    this.formatters[i] = (DmuFormatter)Class.forName(f).newInstance();
                }
                catch (Exception ex) {
                    this.formatters[i] = new DmuFormatNull();
                }
                continue;
            }
            this.formatters[i] = new DmuFormatDefault(cols[i]);
        }
        this.setNeededTags();
    }

    private void setNeededTags() {
        ArrayList<DMTag> al = new ArrayList<DMTag>(this.formatters.length);
        for (int i = 0; i < this.formatters.length; ++i) {
            DMTag[] tag2 = this.formatters[i].getNeededTags();
            for (int k = 0; k < tag2.length; ++k) {
                al.add(tag2[k]);
            }
        }
        DMTag[] tags = this.rowFormatter.getNeededTags();
        for (int i = 0; i < tags.length; ++i) {
            al.add(tags[i]);
        }
        DMTag[] neededTags = al.toArray(new DMTag[al.size()]);
        Object[] el = new DMElement[neededTags.length];
        for (int i = 0; i < neededTags.length; ++i) {
            el[i] = new DMElement(neededTags[i].getGroup(), neededTags[i].getElement());
        }
        Arrays.sort(el);
        this.elem = el;
        this.fireTableStructureChanged();
    }

    public DmuFormatter[] getFormatters() {
        return this.formatters;
    }

    public DmuFormatter getFormatter(int columnIndex) {
        return this.formatters[columnIndex];
    }

    public static void addFormatter(String name, String classname) {
        formatMap.put(name, classname);
    }

    public DmuRowFormatter getRowFormatter() {
        return this.rowFormatter;
    }

    public void setRowFormatter(DmuRowFormatter rf) {
        this.rowFormatter = rf;
    }

    public DmuRowFormatter getSelectedRowFormatter() {
        return this.selectedRowFormatter;
    }

    public void setSelectedRowFormatter(DmuRowFormatter rf) {
        this.selectedRowFormatter = rf;
    }

    public DMQuery getQuery() {
        return this.query;
    }

    public void setQuery(DMQuery q) {
        this.query = q;
    }

    public String getLevel() {
        return model[this.level];
    }

    public void setLevel(String levelStr) {
        for (int i = 0; i < model.length; ++i) {
            if (!model[i].equalsIgnoreCase(levelStr)) continue;
            this.level = i;
            return;
        }
        throw new IllegalArgumentException("unknown level \"" + levelStr + "\"");
    }

    public boolean isAutoSort() {
        return this.autoSort;
    }

    public void setAutoSort(boolean autoSort) {
        this.autoSort = autoSort;
    }

    public DMObject getNextInBrowser(DMObject dmo, boolean reverse) {
        int i;
        int[] rows = new int[this.getRowCount()];
        for (int i2 = 0; i2 < rows.length; ++i2) {
            rows[i2] = i2;
        }
        DMObject[] dmos = this.getData(rows);
        for (i = 0; i < dmos.length && !dmo.equals(dmos[i]); ++i) {
        }
        if (reverse) {
            if (i == 0) {
                return dmos[dmos.length - 1];
            }
            return dmos[--i];
        }
        if (i == dmos.length - 1) {
            return dmos[0];
        }
        return dmos[++i];
    }

    public DMObject[] getData(int[] rows) {
        if (rows == null) {
            return null;
        }
        DMObject[] dmo = new DMObject[rows.length];
        for (int i = 0; i < dmo.length; ++i) {
            dmo[i] = this.getData(rows[i]);
        }
        return dmo;
    }

    public DMObject getData(int row) {
        DMObject object = null;
        if (this.data != null && this.data.size() > row) {
            object = (DMObject)this.data.get(row);
        }
        return object;
    }

    public void addObject(DMObject dmo) {
        if (this.rec == null) {
            this.rec = new ModelReceiver();
            this.data.clear();
            this.data = new Vector();
            this.fireTableDataChanged();
        }
        this.rec.gotOne(dmo);
        this.waitForTableUpdate();
    }

    public void setData(DMObject dmo) {
        if (this.rec != null) {
            this.rec.stop();
        }
        this.rec = new ModelReceiver();
        this.data.clear();
        this.data = new Vector();
        this.fireTableDataChanged();
        if (dmo != null) {
            dmo.getRelated(model[this.level], this.query, this.rec);
        }
        this.waitForTableUpdate();
    }

    public void setData(DMObject[] dmo) {
        if (this.rec != null) {
            this.rec.stop();
        }
        this.rec = new ModelReceiver();
        this.data.clear();
        this.data = new Vector();
        this.fireTableDataChanged();
        if (dmo != null) {
            for (int i = 0; i < dmo.length; ++i) {
                dmo[i].getRelated(model[this.level], this.query, this.rec);
            }
        }
        this.waitForTableUpdate();
    }

    public void setData(DMSession dms) {
        if (this.rec != null) {
            this.rec.stop();
        }
        this.rec = new ModelReceiver();
        this.data.clear();
        this.data = new Vector();
        this.fireTableDataChanged();
        dms.getRelated(model[this.level], this.query, this.rec);
        this.waitForTableUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForTableUpdate() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        Object object = this.timerLock;
        synchronized (object) {
            while (this.tim.isRunning()) {
                try {
                    this.timerLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @Override
    public int getColumnCount() {
        return this.colNames.length;
    }

    @Override
    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.size();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            if (!this.loaded[rowIndex]) {
                if (this.elem != null) {
                    ((DMObject)this.data.get(rowIndex)).getValues(this.elem);
                }
                this.loaded[rowIndex] = true;
            }
            return this.formatters[columnIndex].getValue((DMObject)this.data.get(rowIndex));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "";
        }
    }

    public String getToolTipAt(int rowIndex, int colIndex) {
        String tip = null;
        try {
            if (!this.loaded[rowIndex]) {
                if (this.elem != null) {
                    ((DMObject)this.data.get(rowIndex)).getValues(this.elem);
                }
                this.loaded[rowIndex] = true;
            }
            tip = this.formatters[colIndex].getToolTip((DMObject)this.data.get(rowIndex));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return tip;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void sort(int col) {
        Vector v = this.data;
        this.data = new Vector();
        Object[] arr = v.toArray();
        this.sortUsing = this.formatters[col].getComparator();
        Arrays.sort(arr, this.sortUsing);
        if (this.sortCol == col && this.sortDown) {
            for (int i = arr.length - 1; i >= 0; --i) {
                this.data.add(arr[i]);
            }
            this.sortDown = false;
        } else {
            for (int i = 0; i < arr.length; ++i) {
                this.data.add(arr[i]);
            }
            this.sortDown = true;
        }
        this.sortCol = col;
        this.fireTableDataChanged();
    }

    public void sort(int col, boolean down) {
        Vector v = this.data;
        this.data = new Vector();
        Object[] arr = v.toArray();
        this.sortUsing = this.formatters[col].getComparator();
        Arrays.sort(arr, this.sortUsing);
        this.sortDown = down;
        this.sortCol = col;
        if (this.sortDown) {
            for (int i = arr.length - 1; i >= 0; --i) {
                this.data.add(arr[i]);
            }
        } else {
            for (int i = 0; i < arr.length; ++i) {
                this.data.add(arr[i]);
            }
        }
        this.fireTableDataChanged();
    }

    public boolean isSortDown() {
        return this.sortDown;
    }

    public void setSortDirection(boolean down) {
        this.sort(this.sortCol, down);
    }

    public int getSortCol() {
        return this.sortCol;
    }

    public void setSortCol(int col) {
        this.sort(col, this.sortDown);
    }

    static /* synthetic */ boolean[] access$802(DmuTableModel x0, boolean[] x1) {
        x0.loaded = x1;
        return x1;
    }

    static {
        DmuTableModel.addFormatter("PatientName", "com.ge.med.terra.tap.dmui.table.DmuFormatPN");
        DmuTableModel.addFormatter("PatientDOB", "com.ge.med.terra.tap.dmui.table.DmuFormatDA");
        DmuTableModel.addFormatter("StudyDate", "com.ge.med.terra.tap.dmui.table.DmuFormatDA(0x0008,0x0020)");
        model = new String[]{"patient", "study", "series", "image"};
    }

    private class ModelReceiver
    implements DMObjectReceiver {
        private int row;
        private boolean cont = true;
        private Comparator reverse = new Comparator(){

            public int compare(Object o1, Object o2) {
                return -DmuTableModel.this.sortUsing.compare(o1, o2);
            }
        };

        private ModelReceiver() {
        }

        public void stop() {
            this.cont = false;
        }

        public boolean addRow(int row) {
            try {
                DmuTableModel.this.unInserted = row;
                DmuTableModel.this.tim.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
            return true;
        }

        public int insertSorted(Vector v, Object o, Comparator c) {
            if (c == null) {
                v.add(o);
                return 0;
            }
            if (!DmuTableModel.this.sortDown) {
                c = this.reverse;
            }
            if (v.isEmpty()) {
                v.add(o);
                return 0;
            }
            int start = 0;
            int end = v.size() - 1;
            while (end - start > 0) {
                int sum = start + end;
                int mid = sum >> 1;
                sum &= 1;
                int diff = c.compare(o, v.get(mid));
                if (diff > 0) {
                    start = mid + sum;
                    continue;
                }
                if (diff < 0) {
                    end = mid;
                    continue;
                }
                start = end = mid;
            }
            v.add(start + (start == end && c.compare(o, v.get(start)) > 0 ? 1 : 0), o);
            return end;
        }

        public void printData() {
            int i = 0;
            for (DMObject item : DmuTableModel.this.data) {
                System.out.println(i + ">" + item);
                ++i;
            }
        }

        @Override
        public boolean gotOne(DMObject o) {
            if (this.cont) {
                if (DmuTableModel.this.autoSort & DmuTableModel.this.sortUsing != null) {
                    int pos = this.insertSorted(DmuTableModel.this.data, o, DmuTableModel.this.sortUsing);
                    this.row = DmuTableModel.this.data.size() - 1;
                    if (DmuTableModel.this.loaded.length <= this.row) {
                        boolean[] tmp = new boolean[DmuTableModel.this.loaded.length * 2];
                        System.arraycopy(DmuTableModel.this.loaded, 0, tmp, 0, DmuTableModel.this.loaded.length);
                        DmuTableModel.access$802(DmuTableModel.this, tmp);
                    }
                    System.arraycopy(DmuTableModel.this.loaded, pos, DmuTableModel.this.loaded, pos + 1, DmuTableModel.this.loaded.length - pos - 1);
                    ((DmuTableModel)DmuTableModel.this).loaded[pos] = false;
                    this.addRow(this.row);
                } else {
                    DmuTableModel.this.data.add(o);
                    this.row = DmuTableModel.this.data.size() - 1;
                    if (DmuTableModel.this.loaded.length <= this.row) {
                        boolean[] tmp = new boolean[DmuTableModel.this.loaded.length * 2];
                        System.arraycopy(DmuTableModel.this.loaded, 0, tmp, 0, DmuTableModel.this.loaded.length);
                        DmuTableModel.access$802(DmuTableModel.this, tmp);
                    }
                    ((DmuTableModel)DmuTableModel.this).loaded[this.row] = false;
                    this.addRow(this.row);
                }
            }
            return this.cont;
        }
    }
}

