/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.ui.listSelect;

import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.ui.listSelect.DmNodeComparator;
import com.ge.med.terra.tap.ui.listSelect.DmObjectComparator;
import com.ge.med.terra.tap.ui.listSelect.DmObjectNode;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreeNode;

public abstract class DmTreeNode
implements TreeNode {
    protected DMQuery dmQuery_;
    protected Comparator comparator_;
    protected Vector children_ = null;
    protected static Map childMap_ = new HashMap();
    protected Set changeListeners_ = new HashSet();

    protected DmTreeNode() {
        this(null, null);
    }

    protected DmTreeNode(DMQuery dmQuery, Comparator comparator) {
        this.dmQuery_ = dmQuery;
        this.comparator_ = comparator;
    }

    public DMQuery getDmQuery() {
        return this.dmQuery_;
    }

    public void setDmQuery(DMQuery dmQuery) {
        this.dmQuery_ = dmQuery;
        this.children_ = null;
        this.fireStateChanged();
    }

    public Comparator getComparator() {
        return this.comparator_;
    }

    public void setComparator(Comparator comparator) {
        this.comparator_ = comparator;
        if (this.children_ != null) {
            Object[] nodeArr = new DmObjectNode[this.children_.size()];
            this.children_.copyInto(nodeArr);
            Arrays.sort(nodeArr, new DmNodeComparator((DmObjectComparator)this.comparator_));
            this.children_.removeAllElements();
            for (int i = 0; i < nodeArr.length; ++i) {
                this.children_.add(nodeArr[i]);
            }
            Object var2_2 = null;
        }
        this.fireStateChanged();
    }

    public Vector getChildren() {
        if (this.children_ == null) {
            DMObject[] dmChildren = this.getDmChildren();
            this.children_ = new Vector();
            if (this.comparator_ != null) {
                Arrays.sort(dmChildren, this.comparator_);
            }
            for (int i = 0; dmChildren != null && i < dmChildren.length; ++i) {
                this.children_.add(new DmObjectNode(this, dmChildren[i]));
            }
            Object var1_1 = null;
        }
        return this.children_;
    }

    public abstract DMObject[] getDmChildren();

    @Override
    public TreeNode getParent() {
        return null;
    }

    public Enumeration children() {
        return this.children_.elements();
    }

    @Override
    public int getChildCount() {
        return this.getChildren().size();
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.children_.elementAt(childIndex);
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.children_.indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    protected static String getChildType(String parentType) {
        return (String)childMap_.get(parentType);
    }

    protected static String getType(Object object) {
        if (object instanceof DMSession) {
            return "DB";
        }
        if (object instanceof DMObject) {
            try {
                return ((DMObject)object).getType();
            }
            catch (Exception e) {
                return "Image";
            }
        }
        return "?";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener l) {
        Set set = this.changeListeners_;
        synchronized (set) {
            this.changeListeners_.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener l) {
        Set set = this.changeListeners_;
        synchronized (set) {
            this.changeListeners_.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireStateChanged() {
        Set set = this.changeListeners_;
        synchronized (set) {
            ChangeEvent event = new ChangeEvent(this);
            Iterator i = this.changeListeners_.iterator();
            while (i.hasNext()) {
                ((ChangeListener)i.next()).stateChanged(event);
            }
        }
    }

    static {
        childMap_.put("DB", "Patient");
        childMap_.put("Patient", "Study");
        childMap_.put("Study", "Series");
        childMap_.put("Series", "Image");
    }
}

